/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.cos.internal;

import com.qcloud.cos.model.GetObjectRequest;
import com.qcloud.cos.model.ObjectMetadata;
import com.qcloud.cos.model.PutObjectRequest;
import com.qcloud.cos.model.UploadPartRequest;

public class SkipMd5CheckStrategy {
    public static final String DISABLE_GET_OBJECT_MD5_VALIDATION_PROPERTY = "com.Qcloud.services.cos.disableGetObjectMD5Validation";
    public static final String DISABLE_PUT_OBJECT_MD5_VALIDATION_PROPERTY = "com.Qcloud.services.cos.disablePutObjectMD5Validation";
    public static final SkipMd5CheckStrategy INSTANCE = new SkipMd5CheckStrategy();

    private SkipMd5CheckStrategy() {
    }

    public boolean skipClientSideValidationPerGetResponse(ObjectMetadata metadata) {
        if (this.isGetObjectMd5ValidationDisabledByProperty()) {
            return true;
        }
        return this.skipClientSideValidationPerResponse(metadata);
    }

    public boolean skipClientSideValidationPerPutResponse(ObjectMetadata metadata) {
        if (this.isPutObjectMd5ValidationDisabledByProperty()) {
            return true;
        }
        return this.skipClientSideValidationPerResponse(metadata);
    }

    public boolean skipClientSideValidationPerUploadPartResponse(ObjectMetadata metadata) {
        return this.skipClientSideValidationPerPutResponse(metadata);
    }

    public boolean skipClientSideValidation(GetObjectRequest request, ObjectMetadata returnedMetadata) {
        return this.skipClientSideValidationPerRequest(request) || this.skipClientSideValidationPerGetResponse(returnedMetadata);
    }

    public boolean skipClientSideValidationPerRequest(PutObjectRequest request) {
        if (this.isPutObjectMd5ValidationDisabledByProperty()) {
            return true;
        }
        return this.putRequestInvolvesSse(request) || this.metadataInvolvesSse(request.getMetadata());
    }

    public boolean skipClientSideValidationPerRequest(UploadPartRequest request) {
        if (this.isPutObjectMd5ValidationDisabledByProperty()) {
            return true;
        }
        return request.getSSECustomerKey() != null;
    }

    public boolean skipServerSideValidation(PutObjectRequest request) {
        return this.isPutObjectMd5ValidationDisabledByProperty();
    }

    public boolean skipClientSideValidationPerRequest(GetObjectRequest request) {
        if (this.isGetObjectMd5ValidationDisabledByProperty()) {
            return true;
        }
        return request.getRange() != null;
    }

    private boolean skipClientSideValidationPerResponse(ObjectMetadata metadata) {
        if (metadata == null) {
            return true;
        }
        return metadata.getETag() == null || SkipMd5CheckStrategy.isMultipartUploadETag(metadata.getETag()) || SkipMd5CheckStrategy.isV4ETag(metadata.getETag()) || this.isSSECustomerResponse(metadata);
    }

    private boolean isSSECustomerResponse(ObjectMetadata metadata) {
        return null != metadata.getSSECustomerAlgorithm() && null != metadata.getSSECustomerKeyMd5();
    }

    private boolean isGetObjectMd5ValidationDisabledByProperty() {
        String propertyValue = System.getProperty(DISABLE_GET_OBJECT_MD5_VALIDATION_PROPERTY);
        return propertyValue == null || !propertyValue.equalsIgnoreCase("false");
    }

    private boolean isPutObjectMd5ValidationDisabledByProperty() {
        return System.getProperty(DISABLE_PUT_OBJECT_MD5_VALIDATION_PROPERTY) != null;
    }

    private boolean metadataInvolvesSse(ObjectMetadata metadata) {
        if (metadata == null) {
            return false;
        }
        return SkipMd5CheckStrategy.containsNonNull(metadata.getSSECustomerAlgorithm(), metadata.getSSECustomerKeyMd5(), metadata.getSSECOSKmsKeyId());
    }

    private boolean putRequestInvolvesSse(PutObjectRequest request) {
        return SkipMd5CheckStrategy.containsNonNull(request.getSSECustomerKey(), request.getSSECOSKeyManagementParams());
    }

    private static boolean isMultipartUploadETag(String eTag) {
        return eTag.contains("-");
    }

    private static boolean isV4ETag(String eTag) {
        return eTag.length() != 32;
    }

    private static boolean containsNonNull(Object ... items) {
        for (Object item : items) {
            if (item == null) continue;
            return true;
        }
        return false;
    }
}

