/*
 * Decompiled with CFR 0.152.
 */
package com.qiniu.util;

import com.qiniu.common.Constants;
import com.qiniu.storage.persistent.FileRecorder;
import com.qiniu.util.Json;
import com.qiniu.util.StringUtils;
import java.util.HashMap;
import java.util.concurrent.ConcurrentHashMap;

public class Cache<T> {
    private final String version;
    private final Class<T> objectClass;
    private boolean isFlushing = false;
    private final ConcurrentHashMap<String, T> memCache = new ConcurrentHashMap();
    private final FileRecorder diskCache;

    private Cache(Class<T> objectClass, String cacheDir, String version) {
        this.objectClass = objectClass;
        this.version = version;
        FileRecorder fileRecorder = null;
        try {
            if (objectClass != null && cacheDir != null && !cacheDir.isEmpty()) {
                fileRecorder = new FileRecorder(cacheDir + "/" + objectClass.getName());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.diskCache = fileRecorder;
        this.load();
    }

    private void load() {
        if (this.diskCache == null || this.objectClass == null) {
            return;
        }
        byte[] cacheData = this.diskCache.get(this.version);
        if (cacheData == null || cacheData.length == 0) {
            return;
        }
        try {
            HashMap cacheJson = Json.decode(new String(cacheData), HashMap.class);
            for (String key : cacheJson.keySet()) {
                try {
                    Object jsonMap = cacheJson.get(key);
                    String jsonString = Json.encode(jsonMap);
                    T object = Json.decode(jsonString, this.objectClass);
                    this.memCache.put(key, object);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    break;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.diskCache.del(this.version);
        }
    }

    public T cacheForKey(String cacheKey) {
        return this.memCache.get(cacheKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cache(String cacheKey, T object) {
        if (StringUtils.isNullOrEmpty(cacheKey) || object == null) {
            return;
        }
        Cache cache = this;
        synchronized (cache) {
            this.memCache.put(cacheKey, object);
        }
        this.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flush() {
        if (this.diskCache == null) {
            return;
        }
        HashMap<String, T> flushCache = null;
        Cache cache = this;
        synchronized (cache) {
            if (this.isFlushing) {
                return;
            }
            this.isFlushing = true;
            flushCache = new HashMap<String, T>(this.memCache);
        }
        if (flushCache.isEmpty()) {
            return;
        }
        String jsonString = Json.encode(flushCache);
        if (jsonString == null || jsonString.isEmpty()) {
            return;
        }
        byte[] cacheData = jsonString.getBytes();
        if (cacheData.length == 0) {
            return;
        }
        this.diskCache.set(this.version, cacheData);
        Cache cache2 = this;
        synchronized (cache2) {
            this.isFlushing = false;
        }
    }

    public void clearMemoryCache() {
        this.memCache.clear();
    }

    public static class Builder<T> {
        private String version = "v1";
        private String cacheDir = Constants.CACHE_DIR;
        private final Class<T> objectClass;

        public Builder(Class<T> objectClass) {
            this.objectClass = objectClass;
        }

        public Builder<T> setCacheDir(String cacheDir) {
            this.cacheDir = cacheDir;
            return this;
        }

        public Builder<T> setVersion(String version) {
            this.version = version;
            return this;
        }

        public Cache<T> builder() {
            return new Cache(this.objectClass, this.cacheDir, this.version);
        }
    }
}

