/*
 * Decompiled with CFR 0.152.
 */
package com.qiniu.iam.apis;

import com.google.gson.annotations.SerializedName;
import com.qiniu.common.Constants;
import com.qiniu.common.QiniuException;
import com.qiniu.http.Client;
import com.qiniu.http.MethodType;
import com.qiniu.storage.Api;
import com.qiniu.util.Json;

public class ApiCreateUser
extends Api {
    public ApiCreateUser(Client client) {
        super(client);
    }

    public ApiCreateUser(Client client, Api.Config config) {
        super(client, config);
    }

    public Response request(Request request) throws QiniuException {
        return new Response(this.requestWithInterceptor(request));
    }

    public static class Response
    extends Api.Response {
        private CreatedIamUserResp data;

        protected Response(com.qiniu.http.Response response) throws QiniuException {
            super(response);
            this.data = Json.decode(response.bodyString(), CreatedIamUserResp.class);
        }

        public CreatedIamUserResp getData() {
            return this.data;
        }

        public static final class CreatedIamUserResp {
            @SerializedName(value="data")
            private CreatedIamUserData data;

            public CreatedIamUserData getData() {
                return this.data;
            }
        }

        public static final class CreatedIamUserData {
            @SerializedName(value="id")
            private String id;
            @SerializedName(value="root_uid")
            private Integer rootUid;
            @SerializedName(value="iuid")
            private Integer iuid;
            @SerializedName(value="alias")
            private String alias;
            @SerializedName(value="created_at")
            private String createdAt;
            @SerializedName(value="updated_at")
            private String updatedAt;
            @SerializedName(value="last_login_time")
            private String lastLoginTime;
            @SerializedName(value="enabled")
            private Boolean enabled;

            public String getId() {
                return this.id;
            }

            public Integer getRootUid() {
                return this.rootUid;
            }

            public Integer getIuid() {
                return this.iuid;
            }

            public String getAlias() {
                return this.alias;
            }

            public String getCreatedAt() {
                return this.createdAt;
            }

            public String getUpdatedAt() {
                return this.updatedAt;
            }

            public String getLastLoginTime() {
                return this.lastLoginTime;
            }

            public Boolean getEnabled() {
                return this.enabled;
            }
        }
    }

    public static class Request
    extends Api.Request {
        private CreateIamUserParam data;

        public Request(String urlPrefix, CreateIamUserParam data) {
            super(urlPrefix);
            this.setMethod(MethodType.POST);
            this.setAuthType(1);
            this.data = data;
        }

        @Override
        protected void prepareToRequest() throws QiniuException {
            if (this.data == null) {
                throw new QiniuException(new NullPointerException("data can't empty"));
            }
            super.prepareToRequest();
        }

        @Override
        protected void buildPath() throws QiniuException {
            this.addPathSegment("iam/v1/users");
            super.buildPath();
        }

        @Override
        protected void buildQuery() throws QiniuException {
            super.buildQuery();
        }

        @Override
        protected void buildHeader() throws QiniuException {
            super.buildHeader();
        }

        @Override
        protected void buildBodyInfo() throws QiniuException {
            byte[] body = Json.encode(this.data).getBytes(Constants.UTF_8);
            this.setBody(body, 0, body.length, "application/json");
            super.buildBodyInfo();
        }

        public static final class CreateIamUserParam {
            @SerializedName(value="alias")
            private String alias;
            @SerializedName(value="password")
            private String password;

            public CreateIamUserParam setAlias(String alias) {
                this.alias = alias;
                return this;
            }

            public CreateIamUserParam setPassword(String password) {
                this.password = password;
                return this;
            }
        }
    }
}

