/*
 * Decompiled with CFR 0.152.
 */
package com.qiniu.qvs;

import com.qiniu.common.QiniuException;
import com.qiniu.http.Client;
import com.qiniu.http.Response;
import com.qiniu.qvs.QvsResponse;
import com.qiniu.util.Auth;
import com.qiniu.util.StringMap;
import com.qiniu.util.UrlUtils;

public class PTZManager {
    private final String apiServer;
    private final Client client;
    private final Auth auth;

    public PTZManager(Auth auth) {
        this(auth, "http://qvs.qiniuapi.com");
    }

    public PTZManager(Auth auth, String apiServer) {
        this(auth, apiServer, new Client());
    }

    public PTZManager(Auth auth, String apiServer, Client client) {
        this.auth = auth;
        this.apiServer = apiServer;
        this.client = client;
    }

    public Response ptzControl(String namespaceId, String gbId, String cmd, int speed, String chId) throws QiniuException {
        StringMap params = new StringMap().put("cmd", cmd).put("speed", speed).putNotEmpty("chId", chId);
        String url = String.format("%s/v1/namespaces/%s/devices/%s/ptz", this.apiServer, namespaceId, gbId);
        return QvsResponse.post(url, params, this.client, this.auth);
    }

    public Response focusControl(String namespaceId, String gbId, String cmd, int speed, String chId) throws QiniuException {
        StringMap params = new StringMap().put("cmd", cmd).put("speed", speed).putNotEmpty("chId", chId);
        String url = String.format("%s/v1/namespaces/%s/devices/%s/focus", this.apiServer, namespaceId, gbId);
        return QvsResponse.post(url, params, this.client, this.auth);
    }

    public Response irisControl(String namespaceId, String gbId, String cmd, int speed, String chId) throws QiniuException {
        StringMap params = new StringMap().put("cmd", cmd).put("speed", speed).putNotEmpty("chId", chId);
        String url = String.format("%s/v1/namespaces/%s/devices/%s/iris", this.apiServer, namespaceId, gbId);
        return QvsResponse.post(url, params, this.client, this.auth);
    }

    public Response presetsControl(String namespaceId, String gbId, String cmd, String name, int presetId, String chId) throws QiniuException {
        StringMap params = new StringMap().put("cmd", cmd).putNotEmpty("name", name).putNotEmpty("chId", chId).putNotNull("presetId", presetId);
        String url = String.format("%s/v1/namespaces/%s/devices/%s/presets", this.apiServer, namespaceId, gbId);
        return QvsResponse.post(url, params, this.client, this.auth);
    }

    public Response listPresets(String namespaceId, String gbId, String chId) throws QiniuException {
        String url = String.format("%s/v1/namespaces/%s/devices/%s/presets", this.apiServer, namespaceId, gbId);
        StringMap map = new StringMap().putNotEmpty("chId", chId);
        url = UrlUtils.composeUrlWithQueries(url, map);
        return QvsResponse.get(url, this.client, this.auth);
    }
}

