/*
 * Decompiled with CFR 0.152.
 */
package com.qiniu.rtc.service;

import com.qiniu.common.QiniuException;
import com.qiniu.http.Response;
import com.qiniu.rtc.model.MergeJob;
import com.qiniu.rtc.service.AbstractService;
import com.qiniu.util.Auth;
import com.qiniu.util.StringUtils;
import java.util.HashMap;

public class MergeServiceV4
extends AbstractService {
    public MergeServiceV4(Auth auth) {
        super(auth);
    }

    public Response createMergeJob(MergeJob job, String appId, String roomName) throws QiniuException {
        String urlPattern = "/v4/apps/%s/rooms/%s/jobs";
        return this.postCall(job, urlPattern, appId, roomName);
    }

    public Response updateMergeJob(MergeJob job, String appId, String roomName) throws QiniuException {
        if (job == null || StringUtils.isNullOrEmpty(job.getId())) {
            throw new IllegalArgumentException("");
        }
        String urlPattern = "/v4/apps/%s/rooms/%s/jobs/update";
        return this.postCall(job, urlPattern, appId, roomName);
    }

    public Response stopMergeJob(String jobId, String appId, String roomName) throws QiniuException {
        if (StringUtils.isNullOrEmpty(jobId)) {
            throw new IllegalArgumentException("");
        }
        String urlPattern = "/v4/apps/%s/rooms/%s/jobs/stop";
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("id", jobId);
        return this.postCall(params, urlPattern, appId, roomName);
    }
}

