/*
 * Decompiled with CFR 0.152.
 */
package com.qiniu.storage;

import com.qiniu.common.QiniuException;
import com.qiniu.http.Client;
import com.qiniu.http.Response;
import com.qiniu.storage.Configuration;
import com.qiniu.storage.Recorder;
import com.qiniu.storage.ResumeUploader;
import com.qiniu.util.StringMap;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

public class ConcurrentResumeUploader
extends ResumeUploader {
    public ConcurrentResumeUploader(Client client, String upToken, String key, File file, StringMap params, String mime, Recorder recorder, Configuration configuration) {
        super(client, upToken, key, file, params, mime, recorder, configuration);
    }

    public ConcurrentResumeUploader(Client client, String upToken, String key, InputStream stream, StringMap params, String mime, Configuration configuration) {
        super(client, upToken, key, stream, null, params, mime, configuration);
    }

    public ConcurrentResumeUploader(Client client, String upToken, String key, InputStream stream, String fileName, StringMap params, String mime, Configuration configuration) {
        super(client, upToken, key, stream, fileName, params, mime, configuration);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    Response uploadData() throws QiniuException {
        int maxConcurrentTaskCount = this.config.resumableUploadMaxConcurrentTaskCount;
        ExecutorService pool = this.config.resumableUploadConcurrentTaskExecutorService;
        if (maxConcurrentTaskCount < 1) {
            maxConcurrentTaskCount = 1;
        }
        boolean needPollShutdown = false;
        if (pool == null) {
            needPollShutdown = true;
            pool = Executors.newFixedThreadPool(maxConcurrentTaskCount);
        }
        try {
            Response response = this.uploadDataWithPool(pool, maxConcurrentTaskCount);
            return response;
        }
        finally {
            if (needPollShutdown) {
                pool.shutdown();
            }
        }
    }

    private Response uploadDataWithPool(ExecutorService pool, int maxConcurrentTaskCount) throws QiniuException {
        ArrayList<Future<Response>> futures = new ArrayList<Future<Response>>();
        for (int i = 0; i < maxConcurrentTaskCount; ++i) {
            Future<Response> future = pool.submit(new Callable<Response>(){

                @Override
                public Response call() throws Exception {
                    return ConcurrentResumeUploader.super.uploadData();
                }
            });
            futures.add(future);
        }
        Response response = null;
        QiniuException exception = null;
        for (Future future : futures) {
            try {
                Response responseP = (Response)future.get();
                if (response != null && (responseP == null || !responseP.isOK())) continue;
                response = responseP;
            }
            catch (Exception e) {
                exception = new QiniuException(e);
            }
        }
        if (this.uploadPerformer.isAllBlocksUploaded()) {
            return response;
        }
        if (exception != null) {
            throw exception;
        }
        return response;
    }
}

