/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.codegen;

import com.querydsl.core.annotations.QueryInit;
import com.querydsl.core.annotations.QueryType;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;

public enum PropertyHandling {
    ALL{

        @Override
        public Config getConfig(Class<?> type) {
            return Config.ALL;
        }
    }
    ,
    FIELDS{

        @Override
        public Config getConfig(Class<?> type) {
            return Config.FIELDS;
        }
    }
    ,
    METHODS{

        @Override
        public Config getConfig(Class<?> type) {
            return Config.METHODS;
        }
    }
    ,
    NONE{

        @Override
        public Config getConfig(Class<?> type) {
            return Config.NONE;
        }
    }
    ,
    JDO{

        @Override
        public Config getConfig(Class<?> type) {
            boolean fields = false;
            boolean methods = false;
            for (Field field : type.getDeclaredFields()) {
                fields |= PropertyHandling.hasAnnotations(field, "javax.jdo.annotations.");
            }
            for (AccessibleObject accessibleObject : type.getDeclaredMethods()) {
                methods |= PropertyHandling.hasAnnotations(accessibleObject, "javax.jdo.annotations.");
            }
            return Config.of(fields, methods, Config.FIELDS);
        }
    }
    ,
    JPA{

        @Override
        public Config getConfig(Class<?> type) {
            boolean fields = false;
            boolean methods = false;
            for (Field field : type.getDeclaredFields()) {
                fields |= PropertyHandling.hasAnnotations(field, "javax.persistence.");
            }
            for (AccessibleObject accessibleObject : type.getDeclaredMethods()) {
                methods |= PropertyHandling.hasAnnotations(accessibleObject, "javax.persistence.");
            }
            return Config.of(fields, methods, Config.ALL);
        }
    };


    private static boolean hasAnnotations(AnnotatedElement element, String packagePrefix) {
        for (Annotation ann : element.getAnnotations()) {
            if (!ann.annotationType().getName().startsWith(packagePrefix)) continue;
            return true;
        }
        return element.isAnnotationPresent(QueryType.class) || element.isAnnotationPresent(QueryInit.class);
    }

    public abstract Config getConfig(Class<?> var1);

    public static enum Config {
        ALL(true, true),
        FIELDS(true, false),
        METHODS(false, true),
        NONE(false, false);

        private final boolean fields;
        private final boolean methods;

        private Config(boolean fields, boolean methods) {
            this.fields = fields;
            this.methods = methods;
        }

        public boolean isFields() {
            return this.fields;
        }

        public boolean isMethods() {
            return this.methods;
        }

        public static Config of(boolean fields, boolean methods, Config defaultConfig) {
            if (fields && methods) {
                return ALL;
            }
            if (fields) {
                return FIELDS;
            }
            if (methods) {
                return METHODS;
            }
            return defaultConfig;
        }
    }
}

