/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.codegen;

import com.google.common.base.Function;
import com.mysema.codegen.StringUtils;
import com.mysema.codegen.model.Constructor;
import com.mysema.codegen.model.Type;
import com.mysema.codegen.model.TypeAdapter;
import com.mysema.codegen.model.TypeCategory;
import com.querydsl.codegen.DefaultVariableNameFunction;
import com.querydsl.codegen.Delegate;
import com.querydsl.codegen.Property;
import com.querydsl.codegen.Supertype;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.annotation.Nullable;

public class EntityType
extends TypeAdapter
implements Comparable<EntityType> {
    private final Map<Class<?>, Annotation> annotations = new HashMap();
    private final Set<Constructor> constructors = new LinkedHashSet<Constructor>();
    private int escapeSuffix = 1;
    private final Set<Delegate> delegates = new HashSet<Delegate>();
    private final Set<Property> properties = new TreeSet<Property>();
    private final Set<String> propertyNames = new HashSet<String>();
    private final Set<String> escapedPropertyNames = new HashSet<String>();
    private final Set<Supertype> superTypes;
    private final Map<Object, Object> data = new HashMap<Object, Object>();
    private String modifiedSimpleName;

    public EntityType(Type type) {
        this(type, new LinkedHashSet<Supertype>(), DefaultVariableNameFunction.INSTANCE);
    }

    public EntityType(Type type, Function<EntityType, String> variableNameFunction) {
        this(type, new LinkedHashSet<Supertype>(), variableNameFunction);
    }

    public EntityType(Type type, Set<Supertype> superTypes) {
        this(type, superTypes, DefaultVariableNameFunction.INSTANCE);
    }

    private EntityType(Type type, Set<Supertype> superTypes, Function<EntityType, String> variableNameFunction) {
        super(type);
        this.superTypes = superTypes;
        this.modifiedSimpleName = (String)variableNameFunction.apply((Object)this);
    }

    public void addAnnotation(Annotation annotation) {
        this.annotations.put(annotation.annotationType(), annotation);
    }

    public void addConstructor(Constructor co) {
        this.constructors.add(co);
    }

    public void addDelegate(Delegate delegate) {
        this.delegates.add(delegate);
    }

    public void addProperty(Property field) {
        if (!this.propertyNames.contains(field.getName())) {
            this.propertyNames.add(field.getName());
            this.escapedPropertyNames.add(field.getEscapedName());
            this.properties.add(this.validateField(field));
        }
    }

    public void addSupertype(Supertype entityType) {
        this.superTypes.add(entityType);
    }

    @Override
    public int compareTo(EntityType o) {
        return this.getType().getSimpleName().compareTo(o.getType().getSimpleName());
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof Type) {
            return this.getFullName().equals(((Type)o).getFullName());
        }
        return false;
    }

    public <T extends Annotation> T getAnnotation(Class<T> type) {
        return (T)this.annotations.get(type);
    }

    public Collection<Annotation> getAnnotations() {
        return this.annotations.values();
    }

    public Type as(TypeCategory category) {
        if (this.getCategory() == category) {
            return this;
        }
        return super.as(category);
    }

    public TypeCategory getCategory() {
        if (this.getType().getCategory() == TypeCategory.ENTITY || !this.properties.isEmpty()) {
            return TypeCategory.ENTITY;
        }
        return TypeCategory.CUSTOM;
    }

    public Set<Constructor> getConstructors() {
        return this.constructors;
    }

    public Map<Object, Object> getData() {
        return this.data;
    }

    public Set<Delegate> getDelegates() {
        return this.delegates;
    }

    public TypeCategory getOriginalCategory() {
        return super.getCategory();
    }

    public Set<Property> getProperties() {
        return this.properties;
    }

    @Nullable
    public Supertype getSuperType() {
        return this.superTypes.size() == 1 ? this.superTypes.iterator().next() : null;
    }

    public Set<Supertype> getSuperTypes() {
        return this.superTypes;
    }

    @Deprecated
    public String getUncapSimpleName() {
        return this.modifiedSimpleName;
    }

    public String getModifiedSimpleName() {
        return this.modifiedSimpleName;
    }

    public int hashCode() {
        return this.getFullName().hashCode();
    }

    public boolean hasArrays() {
        return this.hasPropertyWithType(TypeCategory.ARRAY);
    }

    public boolean hasEntityFields() {
        return this.hasPropertyWithType(TypeCategory.ENTITY);
    }

    public boolean hasInits() {
        for (Property property : this.properties) {
            if (property.getInits().isEmpty()) continue;
            return true;
        }
        return false;
    }

    public boolean hasLists() {
        return this.hasPropertyWithType(TypeCategory.LIST);
    }

    public boolean hasCollections() {
        return this.hasPropertyWithType(TypeCategory.COLLECTION);
    }

    public boolean hasSets() {
        return this.hasPropertyWithType(TypeCategory.SET);
    }

    public boolean hasMaps() {
        return this.hasPropertyWithType(TypeCategory.MAP);
    }

    private boolean hasPropertyWithType(TypeCategory category) {
        for (Property property : this.properties) {
            if (property.getType().getCategory() != category) continue;
            return true;
        }
        return false;
    }

    public void include(Supertype supertype) {
        EntityType entityType = supertype.getEntityType();
        for (Delegate delegate : entityType.getDelegates()) {
            this.addDelegate(delegate);
        }
        for (Property property : entityType.getProperties()) {
            this.addProperty(property.createCopy(this));
        }
    }

    private Property validateField(Property field) {
        if (field.getName().equals(this.modifiedSimpleName) || field.getEscapedName().equals(this.modifiedSimpleName)) {
            do {
                this.modifiedSimpleName = StringUtils.uncapitalize((String)this.getType().getSimpleName()) + this.escapeSuffix++;
            } while (this.propertyNames.contains(this.modifiedSimpleName));
        }
        return field;
    }

    public Set<String> getPropertyNames() {
        return this.propertyNames;
    }

    public Set<String> getEscapedPropertyNames() {
        return this.escapedPropertyNames;
    }

    public Type getInnerType() {
        return this.type;
    }
}

