/*
 * Decompiled with CFR 0.152.
 */
package com.redis.testcontainers;

import org.testcontainers.containers.GenericContainer;
import org.testcontainers.lifecycle.Startable;
import org.testcontainers.shaded.org.apache.commons.lang3.ClassUtils;
import org.testcontainers.shaded.org.apache.commons.lang3.StringUtils;

public interface RedisServer
extends Startable {
    public String getRedisURI();

    public boolean isCluster();

    public boolean isEnabled();

    public static String redisURI(String host, int port) {
        return "redis://" + host + ":" + port;
    }

    public static String redisURI(GenericContainer<?> container) {
        return RedisServer.redisURI(container.getHost(), container.getFirstMappedPort());
    }

    public static String toString(RedisServer server) {
        return ClassUtils.getShortClassName(server.getClass());
    }

    public static boolean isEnabled(String suffix) {
        String name = "TESTCONTAINERS_" + suffix;
        String value = System.getProperty(name, System.getenv(name));
        if (StringUtils.isEmpty((CharSequence)value)) {
            return true;
        }
        return !value.toLowerCase().matches("disabled|off|false|no");
    }
}

