/*
 * Decompiled with CFR 0.152.
 */
package com.ryantenney.metrics.spring.reporter;

import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricFilter;
import com.codahale.metrics.MetricRegistry;
import java.util.Map;
import java.util.regex.Pattern;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.core.convert.support.DefaultConversionService;

public abstract class AbstractReporterFactoryBean<T>
implements FactoryBean<T>,
InitializingBean,
BeanFactoryAware {
    protected static final String FILTER_PATTERN = "filter";
    protected static final String FILTER_REF = "filter-ref";
    private MetricRegistry metricRegistry;
    private BeanFactory beanFactory;
    private ConversionService conversionService;
    private Map<String, String> properties;
    private T instance;
    private boolean enabled = true;
    private boolean initialized = false;

    public abstract Class<? extends T> getObjectType();

    public boolean isSingleton() {
        return true;
    }

    public T getObject() {
        if (!this.enabled) {
            return null;
        }
        if (!this.initialized) {
            throw new IllegalStateException("Singleton instance not initialized yet");
        }
        return this.instance;
    }

    public void afterPropertiesSet() throws Exception {
        this.instance = this.createInstance();
        this.initialized = true;
    }

    protected abstract T createInstance() throws Exception;

    public void setBeanFactory(BeanFactory beanFactory) {
        this.beanFactory = beanFactory;
        if (beanFactory instanceof ConfigurableBeanFactory) {
            this.conversionService = ((ConfigurableBeanFactory)beanFactory).getConversionService();
        }
    }

    public BeanFactory getBeanFactory() {
        return this.beanFactory;
    }

    public ConversionService getConversionService() {
        if (this.conversionService == null) {
            this.conversionService = new DefaultConversionService();
        }
        return this.conversionService;
    }

    public void setMetricRegistry(MetricRegistry metricRegistry) {
        this.metricRegistry = metricRegistry;
    }

    public MetricRegistry getMetricRegistry() {
        return this.metricRegistry;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setProperties(Map<String, String> properties) {
        this.properties = properties;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    protected boolean hasProperty(String key) {
        return this.getProperty(key) != null;
    }

    protected String getProperty(String key) {
        return this.properties.get(key);
    }

    protected String getProperty(String key, String defaultValue) {
        String value = this.properties.get(key);
        if (value == null) {
            return defaultValue;
        }
        return value;
    }

    protected <V> V getProperty(String key, Class<V> requiredType) {
        return this.getProperty(key, requiredType, null);
    }

    protected <V> V getProperty(String key, Class<V> requiredType, V defaultValue) {
        String value = this.properties.get(key);
        if (value == null) {
            return defaultValue;
        }
        return (V)this.getConversionService().convert((Object)value, TypeDescriptor.forObject((Object)value), TypeDescriptor.valueOf(requiredType));
    }

    protected Object getPropertyRef(String key) {
        return this.getPropertyRef(key, null);
    }

    protected <V> V getPropertyRef(String key, Class<V> requiredType) {
        String value = this.properties.get(key);
        if (value == null) {
            return null;
        }
        return (V)this.beanFactory.getBean(value, requiredType);
    }

    protected MetricFilter getMetricFilter() {
        if (this.hasProperty(FILTER_PATTERN)) {
            return this.metricFilterPattern(this.getProperty(FILTER_PATTERN));
        }
        if (this.hasProperty(FILTER_REF)) {
            return this.getPropertyRef(FILTER_REF, MetricFilter.class);
        }
        return MetricFilter.ALL;
    }

    protected MetricFilter metricFilterPattern(String pattern) {
        final Pattern filter = Pattern.compile(pattern);
        return new MetricFilter(){

            public boolean matches(String name, Metric metric) {
                return filter.matcher(name).matches();
            }

            public String toString() {
                return "[MetricFilter regex=" + filter.pattern() + "]";
            }
        };
    }
}

