/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.jdbc.converters;

import com.sap.db.annotations.JDBCAPI;
import com.sap.db.annotations.NotThreadSafe;
import com.sap.db.jdbc.HanaClob;
import com.sap.db.jdbc.PassportListener;
import com.sap.db.jdbc.converters.AbstractGetval;
import com.sap.db.jdbc.converters.ReaderInputStream;
import com.sap.db.jdbc.converters.SQLParamController;
import com.sap.db.jdbc.exceptions.SQLExceptionSapDB;
import com.sap.db.jdbc.exceptions.StreamIOException;
import com.sap.db.jdbc.packet.HDataPart;
import com.sap.db.jdbc.trace.TraceRecord;
import com.sap.db.util.BufferUtils;
import com.sap.db.util.Cesu8Utils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.sql.Clob;
import java.sql.NClob;
import java.sql.SQLException;

@NotThreadSafe
public abstract class GetvalClob
extends AbstractGetval
implements Clob,
NClob {
    private final boolean _isNClob;

    protected GetvalClob(SQLParamController controller, HDataPart dataPart, int lobFieldOffset, int length, boolean isNClob) throws SQLException {
        super(controller, dataPart, lobFieldOffset, length);
        this._isNClob = isNClob;
    }

    @Override
    protected long _length() {
        return this._charLength;
    }

    @Override
    protected String _getString() throws SQLException {
        return this._getSubString(1L, -1);
    }

    @Override
    protected byte[] _getBytes() throws SQLException {
        return this._getSubString(1L, -1).getBytes();
    }

    @Override
    protected Reader _getCharacterStream() throws SQLException {
        HanaClob getvalClob = new HanaClob(this._controller, this._dataPart, this._lobFieldOffset, this._length, this._isNClob);
        return super._newClobReader();
    }

    @Override
    protected InputStream _getAsciiStream() throws SQLException {
        HanaClob getvalClob = new HanaClob(this._controller, this._dataPart, this._lobFieldOffset, this._length, this._isNClob);
        return new ReaderInputStream(super._newClobReader(), 4096, StandardCharsets.ISO_8859_1);
    }

    @Override
    protected InputStream _getBinaryStream() throws SQLException {
        HanaClob getvalClob = new HanaClob(this._controller, this._dataPart, this._lobFieldOffset, this._length, this._isNClob);
        return new ReaderInputStream(super._newClobReader(), 4096);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public long length() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("Clob", "length") : null;
        try {
            long result;
            if (on) {
                this._tracer.printCall(this, "length", new Object[0]);
            }
            try {
                if (aon) {
                    this._connection.apiStart();
                }
                result = this._length();
            }
            finally {
                if (aon) {
                    this._connection.apiFinish();
                }
            }
            if (on) {
                this._tracer.printResult(result);
            }
            long l = result;
            return l;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="true")
    public String getSubString(long pos, int length) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("Clob", "getSubString") : null;
        PassportListener pl = this._connection.getPassportListener();
        try {
            String result;
            if (on) {
                this._tracer.printCall(this, "getSubString", pos, length);
            }
            try {
                if (aon || pl != null) {
                    this._connection.apiStart();
                }
                result = this._getSubString(pos, length);
            }
            finally {
                if (aon || pl != null) {
                    this._connection.apiFinish(aon, pl);
                }
            }
            if (on) {
                this._tracer.printResult(result);
            }
            String string = result;
            return string;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public Reader getCharacterStream() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("Clob", "getCharacterStream") : null;
        try {
            Reader result;
            if (on) {
                this._tracer.printCall(this, "getCharacterStream", new Object[0]);
            }
            try {
                if (aon) {
                    this._connection.apiStart();
                }
                result = this._getCharacterStream();
            }
            finally {
                if (aon) {
                    this._connection.apiFinish();
                }
            }
            if (on) {
                this._tracer.printResult(result);
            }
            Reader reader = result;
            return reader;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public InputStream getAsciiStream() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("Clob", "getAsciiStream") : null;
        try {
            InputStream result;
            if (on) {
                this._tracer.printCall(this, "getAsciiStream", new Object[0]);
            }
            try {
                if (aon) {
                    this._connection.apiStart();
                }
                result = this._getAsciiStream();
            }
            finally {
                if (aon) {
                    this._connection.apiFinish();
                }
            }
            if (on) {
                this._tracer.printResult(result);
            }
            InputStream inputStream = result;
            return inputStream;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    @JDBCAPI(packetExchange="false")
    public long position(String searchstr, long start) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("Clob", "position") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "position", searchstr, start);
                }
                try {
                    if (aon) {
                        this._connection.apiStart();
                    }
                    throw GetvalClob._getUnsupportedMethodException("Clob", "position( String, long )");
                }
                catch (Throwable throwable) {
                    if (aon) {
                        this._connection.apiFinish();
                    }
                    throw throwable;
                }
            }
            catch (Throwable e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    @JDBCAPI(packetExchange="false")
    public long position(Clob searchstr, long start) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("Clob", "position") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "position", searchstr, start);
                }
                try {
                    if (aon) {
                        this._connection.apiStart();
                    }
                    throw GetvalClob._getUnsupportedMethodException("Clob", "position( Clob, long )");
                }
                catch (Throwable throwable) {
                    if (aon) {
                        this._connection.apiFinish();
                    }
                    throw throwable;
                }
            }
            catch (Throwable e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    @JDBCAPI(packetExchange="false")
    public int setString(long pos, String str) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("Clob", "setString") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "setString", pos, str);
                }
                try {
                    if (aon) {
                        this._connection.apiStart();
                    }
                    throw GetvalClob._getUnsupportedMethodException("Clob", "setString( long, String )");
                }
                catch (Throwable throwable) {
                    if (aon) {
                        this._connection.apiFinish();
                    }
                    throw throwable;
                }
            }
            catch (Throwable e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    @JDBCAPI(packetExchange="false")
    public int setString(long pos, String str, int offset, int len) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("Clob", "setString") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "setString", pos, str, offset, len);
                }
                try {
                    if (aon) {
                        this._connection.apiStart();
                    }
                    throw GetvalClob._getUnsupportedMethodException("Clob", "setString( long, String, int, int )");
                }
                catch (Throwable throwable) {
                    if (aon) {
                        this._connection.apiFinish();
                    }
                    throw throwable;
                }
            }
            catch (Throwable e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    @JDBCAPI(packetExchange="false")
    public Writer setCharacterStream(long pos) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("Clob", "setCharacterStream") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "setCharacterStream", pos);
                }
                try {
                    if (aon) {
                        this._connection.apiStart();
                    }
                    throw GetvalClob._getUnsupportedMethodException("Clob", "setCharacterStream( long )");
                }
                catch (Throwable throwable) {
                    if (aon) {
                        this._connection.apiFinish();
                    }
                    throw throwable;
                }
            }
            catch (Throwable e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    @JDBCAPI(packetExchange="false")
    public OutputStream setAsciiStream(long pos) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("Clob", "setAsciiStream") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "setAsciiStream", pos);
                }
                try {
                    if (aon) {
                        this._connection.apiStart();
                    }
                    throw GetvalClob._getUnsupportedMethodException("Clob", "setAsciiStream( long )");
                }
                catch (Throwable throwable) {
                    if (aon) {
                        this._connection.apiFinish();
                    }
                    throw throwable;
                }
            }
            catch (Throwable e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    @JDBCAPI(packetExchange="false")
    public void truncate(long len) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("Clob", "truncate") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "truncate", len);
                }
                try {
                    if (aon) {
                        this._connection.apiStart();
                    }
                    throw GetvalClob._getUnsupportedMethodException("Clob", "truncate( int )");
                }
                catch (Throwable throwable) {
                    if (aon) {
                        this._connection.apiFinish();
                    }
                    throw throwable;
                }
            }
            catch (Throwable e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="true")
    public void free() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        PassportListener pl = this._connection.getPassportListener();
        TraceRecord r = pon ? this._newTraceRecord("Clob", "free") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "free", new Object[0]);
            }
            try {
                if (aon || pl != null) {
                    this._connection.apiStart();
                }
                this.removeAppLob(true);
            }
            finally {
                if (aon || pl != null) {
                    this._connection.apiFinish(aon, pl);
                }
            }
            if (on) {
                this._tracer.printVoidResult();
            }
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    @JDBCAPI(packetExchange="false")
    public Reader getCharacterStream(long pos, long length) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("Clob", "getCharacterStream") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "getCharacterStream", pos, length);
                }
                try {
                    if (aon) {
                        this._connection.apiStart();
                    }
                    throw GetvalClob._getUnsupportedMethodException("Clob", "getCharacterStream( long, long )");
                }
                catch (Throwable throwable) {
                    if (aon) {
                        this._connection.apiFinish();
                    }
                    throw throwable;
                }
            }
            catch (Throwable e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    private String _getSubString(long pos, int length) throws SQLException {
        String s;
        ClobReader reader = null;
        try {
            if (this._isNClob) {
                reader = this._newClobReader();
                this._changeCharPosition(pos, reader);
            } else {
                reader = new ClobReader(true, length != -1 ? pos + (long)length - 1L : Long.MAX_VALUE);
                this._changeBytePosition(pos);
            }
            if (length == -1) {
                int n;
                StringBuilder builder = new StringBuilder(4096);
                char[] buf = new char[4096];
                while ((n = reader.read(buf)) != -1) {
                    builder.append(buf, 0, n);
                }
                s = builder.toString();
            } else {
                char[] buf = new char[length];
                int n = reader.read(buf);
                if (n == -1) {
                    n = 0;
                }
                s = new String(buf, 0, n);
            }
        }
        catch (StreamIOException e) {
            throw e.getSQLException();
        }
        catch (IOException e) {
            throw SQLExceptionSapDB.newInstance((Throwable)e, "error.stream.ioexception", e.getMessage());
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
        }
        return s;
    }

    private ClobReader _newClobReader() throws SQLException {
        return new ClobReader(false, Long.MAX_VALUE);
    }

    private void _changeCharPosition(long newPosition, ClobReader reader) throws SQLException, StreamIOException {
        if (newPosition >= this._firstPosition) {
            if (newPosition < this._currentPosition) {
                BufferUtils.rewind(this._byteBuffer);
                this._currentPosition = this._firstPosition;
            }
            while (this._currentPosition < newPosition && this._byteBuffer.remaining() > 0 && reader._readChar(true) != -1) {
            }
        }
        if (newPosition != this._currentPosition) {
            this._currentPosition = newPosition;
            if (this._byteLength == 0L) {
                return;
            }
            this._atEnd = false;
            this._isLastChunk = false;
            this._nextChunk();
        }
    }

    private class ClobReader
    extends Reader {
        private static final char REPLACEMENT_CHAR = '?';
        private final boolean _allowPartialCharactersAtBoundaries;
        private final long _stopAtPosition;
        private boolean _hasReadValidCharacter;

        private ClobReader(boolean allowPartialCharactersAtBoundaries, long stopAtPosition) {
            this._allowPartialCharactersAtBoundaries = allowPartialCharactersAtBoundaries;
            this._stopAtPosition = stopAtPosition;
        }

        @Override
        public int read() throws StreamIOException {
            return this._readChar(false);
        }

        @Override
        public int read(char[] b, int off, int len) throws StreamIOException {
            int i;
            if (b == null) {
                throw new NullPointerException();
            }
            if (off < 0 || len < 0 || off + len > b.length) {
                throw new IndexOutOfBoundsException();
            }
            if (len == 0) {
                return 0;
            }
            int c = this._readChar(false);
            if (c == -1) {
                return -1;
            }
            b[off] = (char)c;
            for (i = 1; i < len && (c = this._readChar(false)) != -1; ++i) {
                b[off + i] = (char)c;
            }
            return i;
        }

        @Override
        public void close() throws IOException {
        }

        private int _readChar(boolean stopAtEndOfChunk) throws StreamIOException {
            int c;
            if (GetvalClob.this._isNClob && GetvalClob.this._currentPosition > GetvalClob.this._charLength) {
                return -1;
            }
            int b0 = this._readByte(stopAtEndOfChunk);
            if (b0 == -1) {
                return -1;
            }
            if ((b0 & 0x80) == 0) {
                c = b0;
                this._hasReadValidCharacter = true;
            } else if ((b0 & 0xE0) == 192) {
                int b1 = this._readByte(stopAtEndOfChunk);
                if (b1 == -1 && this._allowPartialCharactersAtBoundaries) {
                    c = 63;
                } else {
                    Cesu8Utils.validate(b1 != -1 && (b1 & 0xC0) == 128, (byte)b0, (byte)b1);
                    c = (char)((short)((b0 & 0x1F) << 6) + (short)(b1 & 0x3F));
                    this._hasReadValidCharacter = true;
                }
            } else if ((b0 & 0xF0) == 224) {
                int b1 = this._readByte(stopAtEndOfChunk);
                if (b1 == -1 && this._allowPartialCharactersAtBoundaries) {
                    c = 63;
                } else {
                    Cesu8Utils.validate(b1 != -1 && (b1 & 0xC0) == 128, (byte)b0, (byte)b1);
                    int b2 = this._readByte(stopAtEndOfChunk);
                    if (b2 == -1 && this._allowPartialCharactersAtBoundaries) {
                        c = 63;
                    } else {
                        Cesu8Utils.validate(b2 != -1 && (b2 & 0xC0) == 128, (byte)b0, (byte)b1, (byte)b2);
                        c = (char)((short)((b0 & 0xF) << 12) + (short)((b1 & 0x3F) << 6) + (short)(b2 & 0x3F));
                        this._hasReadValidCharacter = true;
                    }
                }
            } else if (!this._hasReadValidCharacter && this._allowPartialCharactersAtBoundaries) {
                c = 63;
            } else {
                Cesu8Utils.validate(false, (byte)b0);
                throw new AssertionError((Object)"Cesu8Utils.validate didn't throw exception");
            }
            if (GetvalClob.this._isNClob) {
                ++GetvalClob.this._currentPosition;
            }
            return c;
        }

        private int _readByte(boolean stopAtEndOfChunk) throws StreamIOException {
            if (!GetvalClob.this._isNClob && GetvalClob.this._currentPosition > GetvalClob.this._byteLength || GetvalClob.this._currentPosition > this._stopAtPosition) {
                return -1;
            }
            if (!GetvalClob.this._atEnd && GetvalClob.this._byteBuffer.remaining() == 0) {
                if (stopAtEndOfChunk) {
                    return -1;
                }
                try {
                    GetvalClob.this._nextChunk();
                }
                catch (SQLException e) {
                    throw new StreamIOException(e);
                }
            }
            if (GetvalClob.this._atEnd) {
                return -1;
            }
            int result = GetvalClob.this._byteBuffer.get() & 0xFF;
            if (!GetvalClob.this._isNClob) {
                ++GetvalClob.this._currentPosition;
            }
            return result;
        }
    }
}

