/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.jdbc.converters;

import com.sap.db.annotations.NotThreadSafe;
import com.sap.db.jdbc.packet.DataType;
import com.sap.db.jdbc.packet.HDataPart;
import java.sql.SQLException;

@NotThreadSafe
public abstract class AbstractPutval {
    protected final int _inputFieldPos;
    protected HDataPart _dataPart;
    protected int _descriptorOffset;
    private byte[] _locatorID;
    private boolean _isLocatorIDStale;

    protected AbstractPutval(int inputFieldPos) {
        this(inputFieldPos, null, -1);
    }

    protected AbstractPutval(int inputFieldPos, HDataPart dataPart, int descriptorOffset) {
        this._inputFieldPos = inputFieldPos;
        this._dataPart = dataPart;
        this._descriptorOffset = descriptorOffset;
    }

    public abstract DataType getDataType();

    public abstract AbstractPutval cloneForBatch();

    public abstract void transferData(boolean var1, HDataPart var2) throws SQLException;

    public abstract boolean isEOF();

    public abstract void markEOF();

    public int getInputFieldPos() {
        return this._inputFieldPos;
    }

    public void setLocatorID(byte[] locatorID) {
        this._locatorID = locatorID;
        this._isLocatorIDStale = false;
    }

    public boolean isLocatorIDStale() {
        return this._isLocatorIDStale;
    }

    public void setLocatorIDStale() {
        this._isLocatorIDStale = true;
    }

    public int putDescriptor(boolean isExecuteRequest, HDataPart dataPart) {
        this._dataPart = dataPart;
        this._descriptorOffset = dataPart.getCurrentFieldOffset();
        return dataPart.putLOBDescriptor(isExecuteRequest, this.getDataType(), this._locatorID);
    }
}

