/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.util;

import com.sap.db.annotations.Immutable;

@Immutable
public final class VersionInfo {
    private final String _versionString;
    private final int _majorVersion;
    private final int _minorVersion;
    private final int _revisionNumber;
    private final int _patchNumber;
    private final int _buildNumber;

    public VersionInfo() {
        this("1.00.000.00.0000000000");
    }

    public VersionInfo(String versionString) {
        this._versionString = versionString;
        int majorVersion = 1;
        int minorVersion = 0;
        int revisionNumber = 0;
        int patchNumber = 0;
        int buildNumber = 0;
        String[] components = versionString.split("\\.");
        int n = components.length;
        if (n >= 3) {
            try {
                majorVersion = Integer.parseInt(components[0]);
                minorVersion = Integer.parseInt(components[1]);
                revisionNumber = Integer.parseInt(components[2]);
                if (n >= 4) {
                    patchNumber = Integer.parseInt(components[3]);
                }
                if (n >= 5) {
                    buildNumber = Integer.parseInt(components[4]);
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        this._majorVersion = majorVersion;
        this._minorVersion = minorVersion;
        this._revisionNumber = revisionNumber;
        this._patchNumber = patchNumber;
        this._buildNumber = buildNumber;
    }

    public String toString() {
        return this._versionString;
    }

    public int getMajorVersion() {
        return this._majorVersion;
    }

    public int getMinorVersion() {
        return this._minorVersion;
    }

    public int getRevisionNumber() {
        return this._revisionNumber;
    }

    public int getPatchNumber() {
        return this._patchNumber;
    }

    public int getBuildNumber() {
        return this._buildNumber;
    }
}

