/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.jdbcext.wrapper;

import com.sap.db.annotations.GuardedBy;
import com.sap.db.annotations.ThreadSafe;
import com.sap.db.jdbcext.wrapper.Array;
import com.sap.db.jdbcext.wrapper.Blob;
import com.sap.db.jdbcext.wrapper.Clob;
import com.sap.db.jdbcext.wrapper.Connection;
import com.sap.db.jdbcext.wrapper.WrappedArray;
import com.sap.db.jdbcext.wrapper.WrappedBlob;
import com.sap.db.jdbcext.wrapper.WrappedClob;
import com.sap.db.jdbcext.wrapper.WrappedResultSetMetaData;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLType;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;

@ThreadSafe
public abstract class ResultSet
implements java.sql.ResultSet {
    protected final java.sql.ResultSet _inner;
    protected final Object _creator;
    protected final Connection _clientConnection;
    @GuardedBy(value="this")
    protected ResultSetMetaData _wrappedResultSetMetaData;

    protected ResultSet(java.sql.ResultSet inner, Object creator, Connection clientConnection) {
        this._inner = inner;
        this._creator = creator;
        this._clientConnection = clientConnection;
    }

    @Override
    public boolean next() throws SQLException {
        try {
            return this._inner.next();
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public void close() throws SQLException {
        try {
            this._inner.close();
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public boolean wasNull() throws SQLException {
        try {
            return this._inner.wasNull();
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        try {
            return this._inner.getWarnings();
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public void clearWarnings() throws SQLException {
        try {
            this._inner.clearWarnings();
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public String getCursorName() throws SQLException {
        try {
            return this._inner.getCursorName();
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public synchronized ResultSetMetaData getMetaData() throws SQLException {
        try {
            if (this._wrappedResultSetMetaData == null) {
                this._wrappedResultSetMetaData = this._inner.getMetaData();
            }
            if (this._wrappedResultSetMetaData != null) {
                this._wrappedResultSetMetaData = WrappedResultSetMetaData.newInstance(this._wrappedResultSetMetaData, this, this._clientConnection);
            }
            return this._wrappedResultSetMetaData;
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public int findColumn(String columnLabel) throws SQLException {
        try {
            return this._inner.findColumn(columnLabel);
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public Object getObject(int columnIndex) throws SQLException {
        try {
            return this._inner.getObject(columnIndex);
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public Object getObject(String columnLabel) throws SQLException {
        try {
            return this._inner.getObject(columnLabel);
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public boolean getBoolean(int columnIndex) throws SQLException {
        try {
            return this._inner.getBoolean(columnIndex);
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public boolean getBoolean(String columnLabel) throws SQLException {
        try {
            return this._inner.getBoolean(columnLabel);
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public byte getByte(int columnIndex) throws SQLException {
        try {
            return this._inner.getByte(columnIndex);
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public byte getByte(String columnLabel) throws SQLException {
        try {
            return this._inner.getByte(columnLabel);
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public short getShort(int columnIndex) throws SQLException {
        try {
            return this._inner.getShort(columnIndex);
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public short getShort(String columnLabel) throws SQLException {
        try {
            return this._inner.getShort(columnLabel);
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public int getInt(int columnIndex) throws SQLException {
        try {
            return this._inner.getInt(columnIndex);
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public int getInt(String columnLabel) throws SQLException {
        try {
            return this._inner.getInt(columnLabel);
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public long getLong(int columnIndex) throws SQLException {
        try {
            return this._inner.getLong(columnIndex);
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public long getLong(String columnLabel) throws SQLException {
        try {
            return this._inner.getLong(columnLabel);
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public float getFloat(int columnIndex) throws SQLException {
        try {
            return this._inner.getFloat(columnIndex);
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public float getFloat(String columnLabel) throws SQLException {
        try {
            return this._inner.getFloat(columnLabel);
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public double getDouble(int columnIndex) throws SQLException {
        try {
            return this._inner.getDouble(columnIndex);
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public double getDouble(String columnLabel) throws SQLException {
        try {
            return this._inner.getDouble(columnLabel);
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    @Deprecated
    public BigDecimal getBigDecimal(int columnIndex, int scale) throws SQLException {
        try {
            return this._inner.getBigDecimal(columnIndex, scale);
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    @Deprecated
    public BigDecimal getBigDecimal(String columnLabel, int scale) throws SQLException {
        try {
            return this._inner.getBigDecimal(columnLabel, scale);
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public Date getDate(int columnIndex) throws SQLException {
        try {
            return this._inner.getDate(columnIndex);
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public Date getDate(String columnLabel) throws SQLException {
        try {
            return this._inner.getDate(columnLabel);
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public Time getTime(int columnIndex) throws SQLException {
        try {
            return this._inner.getTime(columnIndex);
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public Time getTime(String columnLabel) throws SQLException {
        try {
            return this._inner.getTime(columnLabel);
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public Timestamp getTimestamp(int columnIndex) throws SQLException {
        try {
            return this._inner.getTimestamp(columnIndex);
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public Timestamp getTimestamp(String columnLabel) throws SQLException {
        try {
            return this._inner.getTimestamp(columnLabel);
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public String getString(int columnIndex) throws SQLException {
        try {
            return this._inner.getString(columnIndex);
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public String getString(String columnLabel) throws SQLException {
        try {
            return this._inner.getString(columnLabel);
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public byte[] getBytes(int columnIndex) throws SQLException {
        try {
            return this._inner.getBytes(columnIndex);
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public byte[] getBytes(String columnLabel) throws SQLException {
        try {
            return this._inner.getBytes(columnLabel);
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public InputStream getAsciiStream(int columnIndex) throws SQLException {
        try {
            return this._inner.getAsciiStream(columnIndex);
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public InputStream getAsciiStream(String columnLabel) throws SQLException {
        try {
            return this._inner.getAsciiStream(columnLabel);
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    @Deprecated
    public InputStream getUnicodeStream(int columnIndex) throws SQLException {
        try {
            return this._inner.getUnicodeStream(columnIndex);
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    @Deprecated
    public InputStream getUnicodeStream(String columnLabel) throws SQLException {
        try {
            return this._inner.getUnicodeStream(columnLabel);
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public InputStream getBinaryStream(int columnIndex) throws SQLException {
        try {
            return this._inner.getBinaryStream(columnIndex);
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public InputStream getBinaryStream(String columnLabel) throws SQLException {
        try {
            return this._inner.getBinaryStream(columnLabel);
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public boolean isBeforeFirst() throws SQLException {
        try {
            return this._inner.isBeforeFirst();
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public boolean isAfterLast() throws SQLException {
        try {
            return this._inner.isAfterLast();
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public boolean isFirst() throws SQLException {
        try {
            return this._inner.isFirst();
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public boolean isLast() throws SQLException {
        try {
            return this._inner.isLast();
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public void beforeFirst() throws SQLException {
        try {
            this._inner.beforeFirst();
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public void afterLast() throws SQLException {
        try {
            this._inner.afterLast();
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public boolean first() throws SQLException {
        try {
            return this._inner.first();
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public boolean last() throws SQLException {
        try {
            return this._inner.last();
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public int getRow() throws SQLException {
        try {
            return this._inner.getRow();
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public boolean absolute(int row) throws SQLException {
        try {
            return this._inner.absolute(row);
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public boolean relative(int rows) throws SQLException {
        try {
            return this._inner.relative(rows);
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public boolean previous() throws SQLException {
        try {
            return this._inner.previous();
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public int getFetchDirection() throws SQLException {
        try {
            return this._inner.getFetchDirection();
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        try {
            this._inner.setFetchDirection(direction);
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public int getFetchSize() throws SQLException {
        try {
            return this._inner.getFetchSize();
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public void setFetchSize(int fetchSize) throws SQLException {
        try {
            this._inner.setFetchSize(fetchSize);
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public int getType() throws SQLException {
        try {
            return this._inner.getType();
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public int getConcurrency() throws SQLException {
        try {
            return this._inner.getConcurrency();
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public boolean rowInserted() throws SQLException {
        try {
            return this._inner.rowInserted();
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public boolean rowUpdated() throws SQLException {
        try {
            return this._inner.rowUpdated();
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public boolean rowDeleted() throws SQLException {
        try {
            return this._inner.rowDeleted();
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public void insertRow() throws SQLException {
        try {
            this._inner.insertRow();
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public void updateRow() throws SQLException {
        try {
            this._inner.updateRow();
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public void deleteRow() throws SQLException {
        try {
            this._inner.deleteRow();
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public void refreshRow() throws SQLException {
        try {
            this._inner.refreshRow();
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public void cancelRowUpdates() throws SQLException {
        try {
            this._inner.cancelRowUpdates();
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public void moveToInsertRow() throws SQLException {
        try {
            this._inner.moveToInsertRow();
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public void moveToCurrentRow() throws SQLException {
        try {
            this._inner.moveToCurrentRow();
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public Statement getStatement() throws SQLException {
        return (Statement)this._creator;
    }

    @Override
    public Object getObject(int columnIndex, Map<String, Class<?>> map) throws SQLException {
        try {
            return this._inner.getObject(columnIndex, map);
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public Object getObject(String columnLabel, Map<String, Class<?>> map) throws SQLException {
        try {
            return this._inner.getObject(columnLabel, map);
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex) throws SQLException {
        try {
            return this._inner.getBigDecimal(columnIndex);
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public BigDecimal getBigDecimal(String columnLabel) throws SQLException {
        try {
            return this._inner.getBigDecimal(columnLabel);
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public Date getDate(int columnIndex, Calendar cal) throws SQLException {
        try {
            return this._inner.getDate(columnIndex, cal);
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public Date getDate(String columnLabel, Calendar cal) throws SQLException {
        try {
            return this._inner.getDate(columnLabel, cal);
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public Time getTime(int columnIndex, Calendar cal) throws SQLException {
        try {
            return this._inner.getTime(columnIndex, cal);
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public Time getTime(String columnLabel, Calendar cal) throws SQLException {
        try {
            return this._inner.getTime(columnLabel, cal);
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public Timestamp getTimestamp(int columnIndex, Calendar cal) throws SQLException {
        try {
            return this._inner.getTimestamp(columnIndex, cal);
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public Timestamp getTimestamp(String columnLabel, Calendar cal) throws SQLException {
        try {
            return this._inner.getTimestamp(columnLabel, cal);
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public Reader getCharacterStream(int columnIndex) throws SQLException {
        try {
            return this._inner.getCharacterStream(columnIndex);
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public Reader getCharacterStream(String columnLabel) throws SQLException {
        try {
            return this._inner.getCharacterStream(columnLabel);
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public java.sql.Clob getClob(int columnIndex) throws SQLException {
        try {
            java.sql.Clob result = this._inner.getClob(columnIndex);
            if (result != null) {
                result = WrappedClob.newInstance(result, this, this._clientConnection);
            }
            return result;
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public java.sql.Clob getClob(String columnLabel) throws SQLException {
        try {
            java.sql.Clob result = this._inner.getClob(columnLabel);
            if (result != null) {
                result = WrappedClob.newInstance(result, this, this._clientConnection);
            }
            return result;
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public java.sql.Blob getBlob(int columnIndex) throws SQLException {
        try {
            java.sql.Blob result = this._inner.getBlob(columnIndex);
            if (result != null) {
                result = WrappedBlob.newInstance(result, this, this._clientConnection);
            }
            return result;
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public java.sql.Blob getBlob(String columnLabel) throws SQLException {
        try {
            java.sql.Blob result = this._inner.getBlob(columnLabel);
            if (result != null) {
                result = WrappedBlob.newInstance(result, this, this._clientConnection);
            }
            return result;
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public java.sql.Array getArray(int columnIndex) throws SQLException {
        try {
            java.sql.Array result = this._inner.getArray(columnIndex);
            if (result != null) {
                result = WrappedArray.newInstance(result, this, this._clientConnection);
            }
            return result;
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public java.sql.Array getArray(String columnLabel) throws SQLException {
        try {
            java.sql.Array result = this._inner.getArray(columnLabel);
            if (result != null) {
                result = WrappedArray.newInstance(result, this, this._clientConnection);
            }
            return result;
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public Ref getRef(int columnIndex) throws SQLException {
        try {
            return this._inner.getRef(columnIndex);
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public Ref getRef(String columnLabel) throws SQLException {
        try {
            return this._inner.getRef(columnLabel);
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public void updateNull(int columnIndex) throws SQLException {
        try {
            this._inner.updateNull(columnIndex);
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public void updateNull(String columnLabel) throws SQLException {
        try {
            this._inner.updateNull(columnLabel);
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public void updateObject(int columnIndex, Object x) throws SQLException {
        try {
            this._inner.updateObject(columnIndex, x);
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public void updateObject(String columnLabel, Object x) throws SQLException {
        try {
            this._inner.updateObject(columnLabel, x);
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public void updateObject(int columnIndex, Object x, int scale) throws SQLException {
        try {
            this._inner.updateObject(columnIndex, x, scale);
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public void updateObject(String columnLabel, Object x, int scale) throws SQLException {
        try {
            this._inner.updateObject(columnLabel, x, scale);
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public void updateBoolean(int columnIndex, boolean x) throws SQLException {
        try {
            this._inner.updateBoolean(columnIndex, x);
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public void updateBoolean(String columnLabel, boolean x) throws SQLException {
        try {
            this._inner.updateBoolean(columnLabel, x);
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public void updateByte(int columnIndex, byte x) throws SQLException {
        try {
            this._inner.updateByte(columnIndex, x);
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public void updateByte(String columnLabel, byte x) throws SQLException {
        try {
            this._inner.updateByte(columnLabel, x);
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public void updateShort(int columnIndex, short x) throws SQLException {
        try {
            this._inner.updateShort(columnIndex, x);
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public void updateShort(String columnLabel, short x) throws SQLException {
        try {
            this._inner.updateShort(columnLabel, x);
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public void updateInt(int columnIndex, int x) throws SQLException {
        try {
            this._inner.updateInt(columnIndex, x);
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public void updateInt(String columnLabel, int x) throws SQLException {
        try {
            this._inner.updateInt(columnLabel, x);
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public void updateLong(int columnIndex, long x) throws SQLException {
        try {
            this._inner.updateLong(columnIndex, x);
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public void updateLong(String columnLabel, long x) throws SQLException {
        try {
            this._inner.updateLong(columnLabel, x);
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public void updateFloat(int columnIndex, float x) throws SQLException {
        try {
            this._inner.updateFloat(columnIndex, x);
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public void updateFloat(String columnLabel, float x) throws SQLException {
        try {
            this._inner.updateFloat(columnLabel, x);
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public void updateDouble(int columnIndex, double x) throws SQLException {
        try {
            this._inner.updateDouble(columnIndex, x);
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public void updateDouble(String columnLabel, double x) throws SQLException {
        try {
            this._inner.updateDouble(columnLabel, x);
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public void updateBigDecimal(int columnIndex, BigDecimal x) throws SQLException {
        try {
            this._inner.updateBigDecimal(columnIndex, x);
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public void updateBigDecimal(String columnLabel, BigDecimal x) throws SQLException {
        try {
            this._inner.updateBigDecimal(columnLabel, x);
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public void updateDate(int columnIndex, Date x) throws SQLException {
        try {
            this._inner.updateDate(columnIndex, x);
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public void updateDate(String columnLabel, Date x) throws SQLException {
        try {
            this._inner.updateDate(columnLabel, x);
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public void updateTime(int columnIndex, Time x) throws SQLException {
        try {
            this._inner.updateTime(columnIndex, x);
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public void updateTime(String columnLabel, Time x) throws SQLException {
        try {
            this._inner.updateTime(columnLabel, x);
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public void updateTimestamp(int columnIndex, Timestamp x) throws SQLException {
        try {
            this._inner.updateTimestamp(columnIndex, x);
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public void updateTimestamp(String columnLabel, Timestamp x) throws SQLException {
        try {
            this._inner.updateTimestamp(columnLabel, x);
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public void updateString(int columnIndex, String x) throws SQLException {
        try {
            this._inner.updateString(columnIndex, x);
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public void updateString(String columnLabel, String x) throws SQLException {
        try {
            this._inner.updateString(columnLabel, x);
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public void updateBytes(int columnIndex, byte[] x) throws SQLException {
        try {
            this._inner.updateBytes(columnIndex, x);
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public void updateBytes(String columnLabel, byte[] x) throws SQLException {
        try {
            this._inner.updateBytes(columnLabel, x);
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x, int length) throws SQLException {
        try {
            this._inner.updateAsciiStream(columnIndex, x, length);
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x, int length) throws SQLException {
        try {
            this._inner.updateAsciiStream(columnLabel, x, length);
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x, int length) throws SQLException {
        try {
            this._inner.updateCharacterStream(columnIndex, x, length);
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader x, int length) throws SQLException {
        try {
            this._inner.updateCharacterStream(columnLabel, x, length);
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x, int length) throws SQLException {
        try {
            this._inner.updateBinaryStream(columnIndex, x, length);
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x, int length) throws SQLException {
        try {
            this._inner.updateBinaryStream(columnLabel, x, length);
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public URL getURL(int columnIndex) throws SQLException {
        try {
            return this._inner.getURL(columnIndex);
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public URL getURL(String columnLabel) throws SQLException {
        try {
            return this._inner.getURL(columnLabel);
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public void updateClob(int columnIndex, java.sql.Clob x) throws SQLException {
        try {
            this._inner.updateClob(columnIndex, Clob.getInner(x));
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public void updateClob(String columnLabel, java.sql.Clob x) throws SQLException {
        try {
            this._inner.updateClob(columnLabel, Clob.getInner(x));
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public void updateBlob(int columnIndex, java.sql.Blob x) throws SQLException {
        try {
            this._inner.updateBlob(columnIndex, Blob.getInner(x));
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public void updateBlob(String columnLabel, java.sql.Blob x) throws SQLException {
        try {
            this._inner.updateBlob(columnLabel, Blob.getInner(x));
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public void updateArray(int columnIndex, java.sql.Array x) throws SQLException {
        try {
            this._inner.updateArray(columnIndex, Array.getInner(x));
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public void updateArray(String columnLabel, java.sql.Array x) throws SQLException {
        try {
            this._inner.updateArray(columnLabel, Array.getInner(x));
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public void updateRef(int columnIndex, Ref x) throws SQLException {
        try {
            this._inner.updateRef(columnIndex, x);
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public void updateRef(String columnLabel, Ref x) throws SQLException {
        try {
            this._inner.updateRef(columnLabel, x);
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public int getHoldability() throws SQLException {
        try {
            return this._inner.getHoldability();
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public boolean isClosed() throws SQLException {
        try {
            return this._inner.isClosed();
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public String getNString(int columnIndex) throws SQLException {
        try {
            return this._inner.getNString(columnIndex);
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public String getNString(String columnLabel) throws SQLException {
        try {
            return this._inner.getNString(columnLabel);
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public Reader getNCharacterStream(int columnIndex) throws SQLException {
        try {
            return this._inner.getNCharacterStream(columnIndex);
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public Reader getNCharacterStream(String columnLabel) throws SQLException {
        try {
            return this._inner.getNCharacterStream(columnLabel);
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public NClob getNClob(int columnIndex) throws SQLException {
        try {
            NClob result = this._inner.getNClob(columnIndex);
            if (result != null) {
                result = WrappedClob.newInstance(result, this, this._clientConnection);
            }
            return result;
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public NClob getNClob(String columnLabel) throws SQLException {
        try {
            NClob result = this._inner.getNClob(columnLabel);
            if (result != null) {
                result = WrappedClob.newInstance(result, this, this._clientConnection);
            }
            return result;
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public RowId getRowId(int columnIndex) throws SQLException {
        try {
            return this._inner.getRowId(columnIndex);
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public RowId getRowId(String columnLabel) throws SQLException {
        try {
            return this._inner.getRowId(columnLabel);
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public SQLXML getSQLXML(int columnIndex) throws SQLException {
        try {
            return this._inner.getSQLXML(columnIndex);
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public SQLXML getSQLXML(String columnLabel) throws SQLException {
        try {
            return this._inner.getSQLXML(columnLabel);
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public void updateNString(int columnIndex, String x) throws SQLException {
        try {
            this._inner.updateNString(columnIndex, x);
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public void updateNString(String columnLabel, String x) throws SQLException {
        try {
            this._inner.updateNString(columnLabel, x);
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x) throws SQLException {
        try {
            this._inner.updateAsciiStream(columnIndex, x);
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x) throws SQLException {
        try {
            this._inner.updateAsciiStream(columnLabel, x);
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x, long length) throws SQLException {
        try {
            this._inner.updateAsciiStream(columnIndex, x, length);
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x, long length) throws SQLException {
        try {
            this._inner.updateAsciiStream(columnLabel, x, length);
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x) throws SQLException {
        try {
            this._inner.updateCharacterStream(columnIndex, x);
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader x) throws SQLException {
        try {
            this._inner.updateCharacterStream(columnLabel, x);
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
        try {
            this._inner.updateCharacterStream(columnIndex, x, length);
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader x, long length) throws SQLException {
        try {
            this._inner.updateCharacterStream(columnLabel, x, length);
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader x) throws SQLException {
        try {
            this._inner.updateNCharacterStream(columnIndex, x);
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public void updateNCharacterStream(String columnLabel, Reader x) throws SQLException {
        try {
            this._inner.updateNCharacterStream(columnLabel, x);
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
        try {
            this._inner.updateNCharacterStream(columnIndex, x, length);
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public void updateNCharacterStream(String columnLabel, Reader x, long length) throws SQLException {
        try {
            this._inner.updateNCharacterStream(columnLabel, x, length);
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x) throws SQLException {
        try {
            this._inner.updateBinaryStream(columnIndex, x);
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x) throws SQLException {
        try {
            this._inner.updateBinaryStream(columnLabel, x);
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x, long length) throws SQLException {
        try {
            this._inner.updateBinaryStream(columnIndex, x, length);
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x, long length) throws SQLException {
        try {
            this._inner.updateBinaryStream(columnLabel, x, length);
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public void updateClob(int columnIndex, Reader x) throws SQLException {
        try {
            this._inner.updateClob(columnIndex, x);
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public void updateClob(String columnLabel, Reader x) throws SQLException {
        try {
            this._inner.updateClob(columnLabel, x);
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public void updateClob(int columnIndex, Reader x, long length) throws SQLException {
        try {
            this._inner.updateClob(columnIndex, x, length);
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public void updateClob(String columnLabel, Reader x, long length) throws SQLException {
        try {
            this._inner.updateClob(columnLabel, x, length);
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public void updateNClob(int columnIndex, NClob x) throws SQLException {
        try {
            this._inner.updateNClob(columnIndex, (NClob)Clob.getInner(x));
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public void updateNClob(String columnLabel, NClob x) throws SQLException {
        try {
            this._inner.updateNClob(columnLabel, (NClob)Clob.getInner(x));
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public void updateNClob(int columnIndex, Reader x) throws SQLException {
        try {
            this._inner.updateNClob(columnIndex, x);
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public void updateNClob(String columnLabel, Reader x) throws SQLException {
        try {
            this._inner.updateNClob(columnLabel, x);
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public void updateNClob(int columnIndex, Reader x, long length) throws SQLException {
        try {
            this._inner.updateNClob(columnIndex, x, length);
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public void updateNClob(String columnLabel, Reader x, long length) throws SQLException {
        try {
            this._inner.updateNClob(columnLabel, x, length);
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public void updateBlob(int columnIndex, InputStream x) throws SQLException {
        try {
            this._inner.updateBlob(columnIndex, x);
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public void updateBlob(String columnLabel, InputStream x) throws SQLException {
        try {
            this._inner.updateBlob(columnLabel, x);
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public void updateBlob(int columnIndex, InputStream x, long length) throws SQLException {
        try {
            this._inner.updateBlob(columnIndex, x, length);
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public void updateBlob(String columnLabel, InputStream x, long length) throws SQLException {
        try {
            this._inner.updateBlob(columnLabel, x, length);
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public void updateRowId(int columnIndex, RowId x) throws SQLException {
        try {
            this._inner.updateRowId(columnIndex, x);
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public void updateRowId(String columnLabel, RowId x) throws SQLException {
        try {
            this._inner.updateRowId(columnLabel, x);
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public void updateSQLXML(int columnIndex, SQLXML x) throws SQLException {
        try {
            this._inner.updateSQLXML(columnIndex, x);
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public void updateSQLXML(String columnLabel, SQLXML x) throws SQLException {
        try {
            this._inner.updateSQLXML(columnLabel, x);
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public <T> T getObject(int columnIndex, Class<T> type) throws SQLException {
        try {
            return this._inner.getObject(columnIndex, type);
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public <T> T getObject(String columnLabel, Class<T> type) throws SQLException {
        try {
            return this._inner.getObject(columnLabel, type);
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public void updateObject(int columnIndex, Object x, SQLType targetSqlType) throws SQLException {
        try {
            this._inner.updateObject(columnIndex, x, targetSqlType);
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public void updateObject(String columnLabel, Object x, SQLType targetSqlType) throws SQLException {
        try {
            this._inner.updateObject(columnLabel, x, targetSqlType);
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public void updateObject(int columnIndex, Object x, SQLType targetSqlType, int scaleOrLength) throws SQLException {
        try {
            this._inner.updateObject(columnIndex, x, targetSqlType, scaleOrLength);
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public void updateObject(String columnLabel, Object x, SQLType targetSqlType, int scaleOrLength) throws SQLException {
        try {
            this._inner.updateObject(columnLabel, x, targetSqlType, scaleOrLength);
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        try {
            return this._inner.unwrap(iface);
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        try {
            return this._inner.isWrapperFor(iface);
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    public java.sql.ResultSet getInner() {
        return this._inner;
    }
}

