/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.util;

import com.sap.db.annotations.NotThreadSafe;
import com.sap.db.util.PKCS7Padding;
import egovframework.rte.fdl.cryptography.impl.aria.ARIAEngine;
import egovframework.rte.fdl.cryptography.impl.aria.CryptoPadding;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.util.ArrayList;
import java.util.List;
import javax.crypto.BadPaddingException;
import javax.crypto.spec.IvParameterSpec;

@NotThreadSafe
class ARIACBCImpl {
    static final int BLOCK_SIZE_IN_BITS = 128;
    static final int BLOCK_SIZE_IN_BYTES = 16;
    private byte[] _key = null;
    private byte[] _iv = null;
    private boolean _prependIV = false;
    private ARIAEngine _cipherEngine;
    private KeySize _keySize;
    private CryptoPadding _padder;

    ARIACBCImpl(KeySize keySize) throws InvalidKeyException {
        this._keySize = keySize;
        this._cipherEngine = new ARIAEngine(keySize.getKeySizeInBits());
        this._padder = PKCS7Padding.getInstance();
    }

    void setKey(byte[] key) throws InvalidKeyException {
        if (key == null || key.length != this._keySize.getKeySizeInBytes()) {
            throw new InvalidKeyException("Invalid key specified. Key should be: " + this._keySize.getKeySizeInBytes() + " bytes.");
        }
        this._key = key;
    }

    void setKey(Key key) throws InvalidKeyException {
        if (key == null || key.getEncoded() == null || !key.getAlgorithm().equals("SAP_HANA_ARIA") || key.getEncoded().length != this._keySize.getKeySizeInBytes()) {
            throw new InvalidKeyException("Invalid key specified. ARIA Key of " + this._keySize.getKeySizeInBytes() + " bytes should be specified");
        }
        this._key = new byte[this._keySize.getKeySizeInBytes()];
        System.arraycopy(key.getEncoded(), 0, this._key, 0, key.getEncoded().length);
    }

    KeySize getKeySize() {
        return this._keySize;
    }

    void setIV(byte[] iv) throws InvalidAlgorithmParameterException {
        if (iv == null || iv.length != 16) {
            throw new InvalidAlgorithmParameterException("Invalid IV specified. IV should be: 16 bytes.");
        }
        this._iv = iv;
    }

    void setIV(IvParameterSpec iv) throws InvalidAlgorithmParameterException {
        if (iv == null || iv.getIV() == null || iv.getIV().length != 16) {
            throw new InvalidAlgorithmParameterException("Invalid IV specified. IV should be: 16 bytes.");
        }
        this._iv = new byte[16];
        System.arraycopy(iv.getIV(), 0, this._iv, 0, iv.getIV().length);
    }

    void prependIV(boolean prependIV) {
        this._prependIV = prependIV;
    }

    byte[] encrypt(byte[] plaintext) throws InvalidKeyException, InvalidAlgorithmParameterException {
        byte[] cipherText;
        if (this._key == null) {
            throw new InvalidKeyException("No key was specified");
        }
        if (this._iv == null) {
            throw new InvalidAlgorithmParameterException("No iv was specified");
        }
        if (plaintext == null) {
            throw new InvalidAlgorithmParameterException("Invalid plaintext specified");
        }
        ArrayList<byte[]> cipherTextBlocks = new ArrayList<byte[]>();
        BufferBlockIterator blockIterator = new BufferBlockIterator(plaintext, 0, plaintext.length, BufferBlockIterator.CipherType.ENCRYPT, this._padder);
        blockIterator.next();
        byte[] previousCipherText = this._iv;
        int totalCiphertextLength = 0;
        byte[] dataToEncrypt = this._performXOR(previousCipherText, blockIterator.getCurrentBlock());
        previousCipherText = this._cipherEngine.encrypt(dataToEncrypt, this._key);
        totalCiphertextLength += previousCipherText.length;
        cipherTextBlocks.add(previousCipherText);
        while (blockIterator.next()) {
            dataToEncrypt = this._performXOR(previousCipherText, blockIterator.getCurrentBlock());
            previousCipherText = this._cipherEngine.encrypt(dataToEncrypt, this._key);
            totalCiphertextLength += previousCipherText.length;
            cipherTextBlocks.add(previousCipherText);
        }
        int startCopyLocation = 0;
        if (this._prependIV) {
            cipherText = new byte[this._iv.length + totalCiphertextLength];
            System.arraycopy(this._iv, 0, cipherText, startCopyLocation, this._iv.length);
            startCopyLocation += this._iv.length;
        } else {
            cipherText = new byte[totalCiphertextLength];
        }
        for (byte[] cipherTextBlock : cipherTextBlocks) {
            System.arraycopy(cipherTextBlock, 0, cipherText, startCopyLocation, cipherTextBlock.length);
            startCopyLocation += cipherTextBlock.length;
        }
        return cipherText;
    }

    byte[] decrypt(byte[] ciphertext) throws InvalidKeyException, InvalidAlgorithmParameterException, BadPaddingException {
        if (ciphertext == null) {
            throw new InvalidAlgorithmParameterException("Invalid ciphertext specified");
        }
        return this.decrypt(ciphertext, 0, ciphertext.length);
    }

    byte[] decrypt(byte[] ciphertext, int offset, int length) throws InvalidKeyException, InvalidAlgorithmParameterException, BadPaddingException {
        if (this._key == null) {
            throw new InvalidKeyException("No key was specified");
        }
        if (this._iv == null) {
            throw new InvalidAlgorithmParameterException("No iv was specified");
        }
        if (ciphertext == null) {
            throw new InvalidAlgorithmParameterException("Invalid ciphertext specified");
        }
        ArrayList<byte[]> plainTextBlocks = new ArrayList<byte[]>();
        BufferBlockIterator blockIterator = new BufferBlockIterator(ciphertext, offset, length, BufferBlockIterator.CipherType.DECRYPT, this._padder);
        blockIterator.next();
        byte[] previousCipherText = this._iv;
        byte[] decryptedDataBeforeXOR = this._cipherEngine.decrypt(blockIterator.getCurrentBlock(), this._key);
        byte[] decryptedData = this._performXOR(previousCipherText, decryptedDataBeforeXOR);
        plainTextBlocks.add(decryptedData);
        while (blockIterator.next()) {
            previousCipherText = blockIterator.getPreviousBlock();
            decryptedDataBeforeXOR = this._cipherEngine.decrypt(blockIterator.getCurrentBlock(), this._key);
            decryptedData = this._performXOR(previousCipherText, decryptedDataBeforeXOR);
            plainTextBlocks.add(decryptedData);
        }
        this._removePaddingFromLastBlock(plainTextBlocks);
        byte[] lastBlock = (byte[])plainTextBlocks.get(plainTextBlocks.size() - 1);
        int totalPlaintextLength = (plainTextBlocks.size() - 1) * 16 + lastBlock.length;
        byte[] plainText = new byte[totalPlaintextLength];
        int startCopyLocation = 0;
        for (byte[] plainTextBlock : plainTextBlocks) {
            System.arraycopy(plainTextBlock, 0, plainText, startCopyLocation, plainTextBlock.length);
            startCopyLocation += plainTextBlock.length;
        }
        return plainText;
    }

    private byte[] _performXOR(byte[] input1, byte[] input2) {
        if (input1.length != input2.length) {
            throw new IllegalArgumentException("input1 lengt and input 2 length are not equal");
        }
        byte[] xorBytes = new byte[input1.length];
        for (int i = 0; i < input1.length; ++i) {
            xorBytes[i] = (byte)(input1[i] ^ input2[i]);
        }
        return xorBytes;
    }

    private void _removePaddingFromLastBlock(List<byte[]> plainTextBlocks) throws BadPaddingException {
        if (plainTextBlocks.size() >= 2) {
            byte[] lastBlock = plainTextBlocks.get(plainTextBlocks.size() - 1);
            if (this._padder.entireBlockIsPadding(lastBlock, 16)) {
                plainTextBlocks.remove(plainTextBlocks.size() - 1);
            } else {
                lastBlock = this._padder.removePadding(lastBlock, 16);
                plainTextBlocks.set(plainTextBlocks.size() - 1, lastBlock);
            }
        } else {
            byte[] lastBlock = plainTextBlocks.get(plainTextBlocks.size() - 1);
            lastBlock = this._padder.removePadding(lastBlock, 16);
            plainTextBlocks.set(plainTextBlocks.size() - 1, lastBlock);
        }
    }

    private static class BufferBlockIterator {
        private byte[] _currentBlock = new byte[16];
        private byte[] _previousBlock = null;
        private byte[] _additionalBlock = null;
        private byte[] _input;
        private CipherType _cipherType;
        private CryptoPadding _padder;
        private int _startIndex;
        private int _offset;
        private int _length;

        BufferBlockIterator(byte[] input, int offset, int length, CipherType cipherType, CryptoPadding padder) {
            if (input == null) {
                throw new IllegalArgumentException("input cannot be null");
            }
            if (offset < 0 || offset > Math.max(0, input.length - 1) || length < 0 || offset + length > input.length) {
                throw new IllegalArgumentException("The offset|length is outside the range of indices for the array");
            }
            this._input = input;
            this._cipherType = cipherType;
            this._startIndex = offset;
            this._offset = offset;
            this._length = length;
            this._padder = padder;
        }

        byte[] getCurrentBlock() {
            if (this._startIndex == this._offset) {
                throw new IllegalArgumentException("getCurrentBlock() called before first call to next()");
            }
            return this._currentBlock;
        }

        byte[] getPreviousBlock() {
            if (this._startIndex == this._offset) {
                throw new IllegalArgumentException("getPreviousBlock() called before first call to next()");
            }
            return this._previousBlock;
        }

        boolean next() throws InvalidAlgorithmParameterException {
            if (this._startIndex > this._offset && this._startIndex >= this._offset + this._length && this._additionalBlock == null) {
                return false;
            }
            if (this._previousBlock == null) {
                this._previousBlock = new byte[this._currentBlock.length];
            } else {
                if (this._previousBlock.length != this._currentBlock.length) {
                    this._previousBlock = new byte[this._currentBlock.length];
                }
                System.arraycopy(this._currentBlock, 0, this._previousBlock, 0, this._currentBlock.length);
            }
            if (this._additionalBlock != null) {
                System.arraycopy(this._additionalBlock, 0, this._currentBlock, 0, this._additionalBlock.length);
                this._additionalBlock = null;
            } else if (this._cipherType == CipherType.ENCRYPT && this.lastBlock(this._startIndex)) {
                byte[] newBlock = new byte[this._offset + this._length - this._startIndex];
                System.arraycopy(this._input, this._startIndex, newBlock, 0, this._offset + this._length - this._startIndex);
                newBlock = this._padder.addPadding(newBlock, 16);
                if (newBlock.length == 32) {
                    this._additionalBlock = new byte[16];
                    System.arraycopy(newBlock, 0, this._currentBlock, 0, 16);
                    System.arraycopy(newBlock, 16, this._additionalBlock, 0, 16);
                } else if (newBlock.length == 16) {
                    System.arraycopy(newBlock, 0, this._currentBlock, 0, 16);
                } else if (newBlock.length % 16 != 0) {
                    throw new InvalidAlgorithmParameterException(String.format("Unsupported new block size found from %s padding: %d", this._padder.toString(), newBlock.length));
                }
            } else {
                System.arraycopy(this._input, this._startIndex, this._currentBlock, 0, 16);
            }
            this._startIndex += 16;
            return true;
        }

        boolean lastBlock(int startIndex) {
            int remainingLength = this._offset + this._length - startIndex;
            return remainingLength <= 16;
        }

        private static enum CipherType {
            ENCRYPT,
            DECRYPT;

        }
    }

    static enum KeySize {
        KEYSIZE_128(128),
        KEYSIZE_192(192),
        KEYSIZE_256(256);

        private int _keySize;

        private KeySize(int keySize) {
            this._keySize = keySize;
        }

        int getKeySizeInBits() {
            return this._keySize;
        }

        int getKeySizeInBytes() {
            return this._keySize / 8;
        }

        static boolean isValidKeySizeInBytes(int keySize) {
            return keySize == KEYSIZE_128.getKeySizeInBytes() || keySize == KEYSIZE_192.getKeySizeInBytes() || keySize == KEYSIZE_256.getKeySizeInBytes();
        }

        static boolean isValidKeySizeInBits(int keySize) {
            return keySize == KEYSIZE_128.getKeySizeInBits() || keySize == KEYSIZE_192.getKeySizeInBits() || keySize == KEYSIZE_256.getKeySizeInBits();
        }

        static KeySize getKeySize(int keySizeInBits) throws InvalidKeyException {
            if (!KeySize.isValidKeySizeInBits(keySizeInBits)) {
                throw new InvalidKeyException(String.format("Keysize %d is invalid", keySizeInBits));
            }
            if (keySizeInBits == KEYSIZE_128.getKeySizeInBits()) {
                return KEYSIZE_128;
            }
            if (keySizeInBits == KEYSIZE_192.getKeySizeInBits()) {
                return KEYSIZE_192;
            }
            return KEYSIZE_256;
        }
    }
}

