/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.util.security;

import com.sap.db.annotations.NotThreadSafe;
import com.sap.db.jdbc.exceptions.SQLExceptionSapDB;
import com.sap.db.jdbc.packet.HAuthenticationPart;
import com.sap.db.jdbc.trace.Tracer;
import com.sap.db.util.ByteUtils;
import com.sap.db.util.CharsetUtils;
import com.sap.db.util.security.ScramSHA256;
import com.sap.db.util.security.ScramSHA256Authentication;
import java.sql.SQLException;
import java.util.Arrays;

@NotThreadSafe
class ScramPBKDF2SHA256Authentication
extends ScramSHA256Authentication {
    static final String METHOD_NAME = "SCRAMPBKDF2SHA256";
    private int _iterations;
    private byte[] _serverProof;

    ScramPBKDF2SHA256Authentication() {
    }

    @Override
    String getMethodName() {
        return METHOD_NAME;
    }

    @Override
    byte[] evaluateAuthenticateReply(Tracer tracer, HAuthenticationPart authenticationPart) throws SQLException {
        HAuthenticationPart part = new HAuthenticationPart(authenticationPart);
        if (!part.nextField()) {
            throw SQLExceptionSapDB.newInstance("error.connection.wrongserverchallengereceived", new String[0]);
        }
        this._salt = part.getValueAsBytes();
        if (this._salt.length < 16) {
            throw SQLExceptionSapDB.newInstance("error.connection.wrongserverchallengereceived", new String[0]);
        }
        if (!part.nextField()) {
            throw SQLExceptionSapDB.newInstance("error.connection.wrongserverchallengereceived", new String[0]);
        }
        this._serverChallenge = part.getValueAsBytes();
        if (!part.nextField()) {
            throw SQLExceptionSapDB.newInstance("error.connection.wrongserverchallengereceived", new String[0]);
        }
        this._iterations = ByteUtils.getIntBigEndian(part.getValueAsBytes(), 0);
        if (this._iterations < 15000) {
            throw SQLExceptionSapDB.newInstance("error.connection.wrongserverchallengereceived", new String[0]);
        }
        return null;
    }

    @Override
    byte[] evaluateConnectReply(Tracer tracer, HAuthenticationPart authenticationPart) throws SQLException {
        HAuthenticationPart part = new HAuthenticationPart(authenticationPart);
        if (!part.nextField()) {
            throw SQLExceptionSapDB.newInstance("error.packet.wrongpacketformat", new String[0]);
        }
        byte[] serverProof = part.getValueAsBytes();
        if (!Arrays.equals(serverProof, this._serverProof)) {
            throw SQLExceptionSapDB.newInstance("error.packet.wrongpacketformat", new String[0]);
        }
        return null;
    }

    @Override
    protected byte[] _getClientProof(String pass) {
        byte[] passBytes = pass.getBytes(CharsetUtils.UTF_8);
        byte[] data = new byte[35];
        ByteUtils.putShortBigEndian(1, data, 0);
        byte[][] proof = ScramSHA256.scramPBKDF2SHA256(this._salt, passBytes, this._getClientChallenge(), this._serverChallenge, this._iterations);
        byte[] clientProof = proof[0];
        this._serverProof = proof[1];
        data[2] = 32;
        System.arraycopy(clientProof, 0, data, 3, clientProof.length);
        return data;
    }
}

