/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.jdbc;

import com.sap.db.annotations.Immutable;
import com.sap.db.jdbc.ConnectionSapDB;
import com.sap.db.jdbc.trace.TraceRecord;
import com.sap.db.jdbc.trace.TraceRecordPublisher;
import com.sap.db.jdbc.trace.Tracer;
import com.sap.db.util.UUIDUtils;
import java.sql.SQLException;
import java.sql.Savepoint;
import java.util.UUID;

@Immutable
public abstract class SavepointSapDB
implements Savepoint {
    private final ConnectionSapDB _connection;
    private final Tracer _tracer;
    private final int _id;
    private final String _name;

    protected SavepointSapDB(ConnectionSapDB connection, int id, String name) {
        this._connection = connection;
        this._tracer = connection.getTracer();
        this._id = id;
        this._name = name == null || name.isEmpty() ? UUIDUtils.toHexString(UUID.randomUUID()) : name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getSavepointId() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("getSavepointId") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "getSavepointId", new Object[0]);
            }
            int result = this._id;
            if (on) {
                this._tracer.printResult(result);
            }
            int n = result;
            return n;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getSavepointName() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("getSavepointName") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "getSavepointName", new Object[0]);
            }
            String result = this._name;
            if (on) {
                this._tracer.printResult(result);
            }
            String string = result;
            return string;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    protected String _getName() {
        return this._name;
    }

    private TraceRecord _newTraceRecord(String methodName) {
        return new TraceRecord(this._connection, null, null, "Savepoint", methodName);
    }

    private void _publish(TraceRecord r) {
        r.update(this._connection);
        TraceRecordPublisher.getInstance().publish(r);
    }
}

