/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.jdbc;

import com.sap.db.annotations.GuardedBy;
import com.sap.db.annotations.NotThreadSafe;
import com.sap.db.jdbc.Address;
import com.sap.db.jdbc.ConnectionProperty;
import com.sap.db.jdbc.ConnectionSapDB;
import com.sap.db.jdbc.Driver;
import com.sap.db.jdbc.HanaWebSocket;
import com.sap.db.jdbc.RteReturnCode;
import com.sap.db.jdbc.Session;
import com.sap.db.jdbc.SessionFactory;
import com.sap.db.jdbc.exceptions.RTEException;
import com.sap.db.jdbc.exceptions.SQLExceptionSapDB;
import com.sap.db.util.Base64Utils;
import com.sap.db.util.BufferUtils;
import com.sap.db.util.MessageTranslator;
import com.sap.db.util.SSLUtils;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.security.KeyFactory;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.CertificateParsingException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SNIHostName;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import javax.security.auth.x500.X500Principal;
import javax.security.cert.X509Certificate;

@NotThreadSafe
public class SecureSession
extends Session {
    static final SessionFactory SECURE_SESSION_FACTORY = new SessionFactory(){

        @Override
        public Session newInstance(ConnectionSapDB connection, Address address) throws RTEException {
            return new SecureSession(connection, address);
        }
    };
    private static final int MAX_SSL_RETRY_COUNT = 500;
    private final boolean _validateCertificate;
    private final String _hostNameInCertificate;
    private final String _keyStore;
    private final String _keyStoreType;
    private final String _keyStorePasswd;
    private final String _sslKeyStore;
    private final String _trustStore;
    private final String _trustStoreType;
    private final String _trustStorePasswd;
    private final String _sslTrustStore;
    private final String _sniHostname;
    @GuardedBy(value="_connection (implicit)")
    private final SSLEngine _sslEngine;
    @GuardedBy(value="_connection (implicit)")
    private final Socket _socket;
    @GuardedBy(value="_connection (implicit)")
    private final HanaWebSocket _webSocket;
    @GuardedBy(value="_connection (implicit)")
    private final InputStream _inputStream;
    @GuardedBy(value="_connection (implicit)")
    private final OutputStream _outputStream;
    @GuardedBy(value="_connection (implicit)")
    private SSLSession _sslSession;
    @GuardedBy(value="_connection (implicit)")
    private ByteBuffer _sendBuffer;
    @GuardedBy(value="_connection (implicit)")
    private ByteBuffer _receiveBuffer;
    @GuardedBy(value="_connection (implicit)")
    private ByteBuffer _applicationBuffer;
    @GuardedBy(value="_connection (implicit)")
    private X509Certificate[] _peerCertificateChain;

    SecureSession(ConnectionSapDB connection, Address address) throws RTEException {
        super(connection, address);
        this._validateCertificate = this._connectionProperties.getBooleanProperty(ConnectionProperty.VALIDATE_CERTIFICATE);
        this._hostNameInCertificate = this._connectionProperties.getProperty(ConnectionProperty.HOST_NAME_IN_CERTIFICATE);
        this._keyStore = this._connectionProperties.getProperty(ConnectionProperty.KEY_STORE);
        this._keyStoreType = this._connectionProperties.getProperty(ConnectionProperty.KEY_STORE_TYPE);
        this._keyStorePasswd = this._connectionProperties.getProperty(ConnectionProperty.KEY_STORE_PASSWD);
        this._sslKeyStore = this._connectionProperties.getProperty(ConnectionProperty.SSL_KEY_STORE);
        this._trustStore = this._connectionProperties.getProperty(ConnectionProperty.TRUST_STORE);
        this._trustStoreType = this._connectionProperties.getProperty(ConnectionProperty.TRUST_STORE_TYPE);
        this._trustStorePasswd = this._connectionProperties.getProperty(ConnectionProperty.TRUST_STORE_PASSWD);
        this._sslTrustStore = this._connectionProperties.getProperty(ConnectionProperty.SSL_TRUST_STORE);
        this._sniHostname = this._connectionProperties.getProperty(ConnectionProperty.SNI_HOSTNAME);
        HanaWebSocket[] webSocketOutputParm = new HanaWebSocket[1];
        try {
            this._sslEngine = this._startSSLInit();
            this._socket = this._openSocket(this._sslEngine, webSocketOutputParm);
            this._webSocket = webSocketOutputParm[0];
            this._inputStream = this._socket.getInputStream();
            this._outputStream = this._socket.getOutputStream();
            this._finishSSLInit();
        }
        catch (IOException e) {
            this.destroy();
            throw new RTEException(this._tracer, MessageTranslator.translate("error.host.connect", address.toString(), e.getMessage(), RteReturnCode.SQLSTART_REQUIRED.getCommunicationErrorCode()), RteReturnCode.SQLSTART_REQUIRED);
        }
    }

    @Override
    protected Socket _getSocket() {
        return this._socket;
    }

    @Override
    protected HanaWebSocket _getWebSocket() {
        return this._webSocket;
    }

    @Override
    protected void _sendBytes(byte[] buffer, int len) throws RTEException {
        this._encodeBytes(buffer, len);
    }

    @Override
    protected int _receiveBytes(byte[] buffer, int off, int len) throws RTEException {
        return this._decodeBytes(buffer, off, len);
    }

    @Override
    protected void _writeBytes(byte[] buffer, int len) throws RTEException {
        this._writeSocket(this._outputStream, buffer, len);
    }

    @Override
    protected int _readBytes(byte[] buffer, int off, int len) throws RTEException {
        return this._readSocket(this._inputStream, buffer, off, len);
    }

    @Override
    protected X509Certificate[] _getPeerCertificateChain() {
        return this._peerCertificateChain;
    }

    private SSLEngine _startSSLInit() throws RTEException {
        String host = ((Address)this._address.get()).getHost();
        SSLContext sslContext = null;
        KeyManager[] keyManagers = null;
        TrustManager[] trustManagers = null;
        try {
            String[] supportedProtocols;
            if (!this._validateCertificate) {
                keyManagers = null;
                trustManagers = new TrustManager[]{new X509TrustManager(){

                    @Override
                    public java.security.cert.X509Certificate[] getAcceptedIssuers() {
                        return null;
                    }

                    @Override
                    public void checkClientTrusted(java.security.cert.X509Certificate[] certs, String authType) {
                    }

                    @Override
                    public void checkServerTrusted(java.security.cert.X509Certificate[] certs, String authType) {
                    }
                }};
            } else if (this._isSystemDefaultUsed()) {
                sslContext = SSLContext.getDefault();
            } else {
                KeyManagerFactory keyManagerFactory = this._getKeyManagerFactory(host);
                TrustManagerFactory trustManagerFactory = this._getTrustManagerFactory(host);
                keyManagers = keyManagerFactory != null ? keyManagerFactory.getKeyManagers() : null;
                TrustManager[] trustManagerArray = trustManagers = trustManagerFactory != null ? trustManagerFactory.getTrustManagers() : null;
            }
            if (sslContext == null) {
                sslContext = SSLContext.getInstance("TLS");
                sslContext.init(keyManagers, trustManagers, new SecureRandom());
            }
            SSLEngine sslEngine = sslContext.createSSLEngine();
            sslEngine.setUseClientMode(true);
            ArrayList<String> enabledProtocols = new ArrayList<String>();
            for (String supportedProtocol : supportedProtocols = sslEngine.getSupportedProtocols()) {
                if (!supportedProtocol.startsWith("TLS")) continue;
                enabledProtocols.add(supportedProtocol);
            }
            sslEngine.setEnabledProtocols(enabledProtocols.toArray(new String[0]));
            InetAddress inetAddress = InetAddress.getByName(host);
            if (Driver.getJavaVersion() >= 8 && !(inetAddress instanceof Inet6Address)) {
                SNIHostName sniServerName = new SNIHostName(this._sniHostname != null ? this._sniHostname : host);
                SSLParameters sslParameters = sslEngine.getSSLParameters();
                sslParameters.setServerNames(Collections.singletonList(sniServerName));
                sslEngine.setSSLParameters(sslParameters);
            }
            return sslEngine;
        }
        catch (NoSuchAlgorithmException e) {
            SQLException sqlex = SQLExceptionSapDB.newInstance((Throwable)e, "error.ssl.nosuchalgorithm", e.getMessage());
            this._throwRTEException(MessageTranslator.translate("error.host.connect", host, e.getMessage(), RteReturnCode.SQLSTART_REQUIRED.getCommunicationErrorCode()), RteReturnCode.SQLSTART_REQUIRED, sqlex);
        }
        catch (KeyManagementException e) {
            SQLException sqlex = SQLExceptionSapDB.newInstance((Throwable)e, "error.ssl.keymanagementexception", e.getMessage());
            this._throwRTEException(MessageTranslator.translate("error.host.connect", host, e.getMessage(), RteReturnCode.SQLSTART_REQUIRED.getCommunicationErrorCode()), RteReturnCode.SQLSTART_REQUIRED, sqlex);
        }
        catch (UnknownHostException e) {
            this._throwRTEException(MessageTranslator.translate("error.unknown.host", host, e.getMessage(), RteReturnCode.SQLSERVER_OR_DB_UNKNOWN.getCommunicationErrorCode()), RteReturnCode.SQLSERVER_OR_DB_UNKNOWN);
        }
        throw new AssertionError((Object)"_throwRTEException didn't throw an RTEException");
    }

    private void _finishSSLInit() throws RTEException {
        Address address = (Address)this._address.get();
        String host = address.getHost();
        try {
            Certificate[] certificates;
            this._doHandshake();
            this._sslSession = this._sslEngine.getSession();
            int packetBufferSize = this._sslSession.getPacketBufferSize();
            int applicationBufferSize = this._sslSession.getApplicationBufferSize();
            this._sendBuffer = ByteBuffer.allocate(packetBufferSize);
            this._receiveBuffer = ByteBuffer.allocate(packetBufferSize);
            this._applicationBuffer = ByteBuffer.allocate(applicationBufferSize);
            BufferUtils.flip(this._applicationBuffer);
            try {
                certificates = this._sslSession.getPeerCertificates();
                this._peerCertificateChain = this._sslSession.getPeerCertificateChain();
            }
            catch (SSLPeerUnverifiedException e) {
                certificates = new Certificate[]{};
            }
            this._validateHostName(certificates, host);
        }
        catch (RTEException e) {
            this._throwRTEException(e);
        }
    }

    private boolean _isSystemDefaultUsed() {
        return this._keyStore == null && this._keyStoreType == null && this._keyStorePasswd == null && this._sslKeyStore == null && this._trustStore == null && this._trustStorePasswd == null && this._trustStoreType == null && this._sslTrustStore == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private KeyManagerFactory _getKeyManagerFactory(String hostName) throws RTEException {
        SQLException sqlex;
        char[] passwd;
        KeyStore ks;
        KeyManagerFactory kmf;
        block31: {
            String type;
            String algorithm;
            String keyStoreFileName = this._getKeyStoreFileName();
            if (this._sslKeyStore == null && keyStoreFileName == null) {
                return null;
            }
            kmf = null;
            ks = null;
            if (this._sslKeyStore != null) {
                algorithm = "SunX509";
                type = "JKS";
                passwd = "".toCharArray();
            } else {
                algorithm = KeyManagerFactory.getDefaultAlgorithm();
                type = this._getKeyStoreType();
                passwd = this._getKeyStorePasswd().toCharArray();
            }
            try {
                kmf = KeyManagerFactory.getInstance(algorithm);
            }
            catch (NoSuchAlgorithmException e) {
                sqlex = SQLExceptionSapDB.newInstance((Throwable)e, "error.ssl.keymanagerfactorynodefault", e.getMessage());
                this._throwRTEException(MessageTranslator.translate("error.host.connect", hostName, e.getMessage(), RteReturnCode.SQLSTART_REQUIRED.getCommunicationErrorCode()), RteReturnCode.SQLSTART_REQUIRED, sqlex);
            }
            try {
                ks = KeyStore.getInstance(type);
            }
            catch (KeyStoreException e) {
                sqlex = SQLExceptionSapDB.newInstance((Throwable)e, "error.ssl.keystore.create", type, e.getMessage());
                this._throwRTEException(MessageTranslator.translate("error.host.connect", hostName, e.getMessage(), RteReturnCode.SQLSTART_REQUIRED.getCommunicationErrorCode()), RteReturnCode.SQLSTART_REQUIRED, sqlex);
            }
            try {
                if (this._sslKeyStore != null) {
                    ks.load(null);
                    List<Certificate> certs = SecureSession._createCertificatesFromPEM(this._sslKeyStore);
                    List<PrivateKey> keys = SecureSession._createPrivateKeysFromPEM(this._sslKeyStore);
                    if (!keys.isEmpty()) {
                        ks.setKeyEntry("key-alias", keys.get(0), passwd, certs.toArray(new Certificate[0]));
                    }
                    break block31;
                }
                FileInputStream fis = null;
                try {
                    fis = new FileInputStream(keyStoreFileName);
                    ks.load(fis, passwd);
                }
                catch (FileNotFoundException e) {
                    sqlex = SQLExceptionSapDB.newInstance((Throwable)e, "error.ssl.keystorefilenotfound", e.getMessage());
                    this._throwRTEException(MessageTranslator.translate("error.host.connect", hostName, e.getMessage(), RteReturnCode.SQLSTART_REQUIRED.getCommunicationErrorCode()), RteReturnCode.SQLSTART_REQUIRED, sqlex);
                }
                finally {
                    if (fis != null) {
                        try {
                            fis.close();
                        }
                        catch (IOException e) {}
                    }
                }
            }
            catch (NoSuchAlgorithmException e) {
                sqlex = SQLExceptionSapDB.newInstance((Throwable)e, "error.ssl.keystoreloadfailed.nosuchalgorithm", e.getMessage());
                this._throwRTEException(MessageTranslator.translate("error.host.connect", hostName, e.getMessage(), RteReturnCode.SQLSTART_REQUIRED.getCommunicationErrorCode()), RteReturnCode.SQLSTART_REQUIRED, sqlex);
            }
            catch (CertificateException e) {
                sqlex = SQLExceptionSapDB.newInstance((Throwable)e, "error.ssl.keystoreloadfailed.certificate", e.getMessage());
                this._throwRTEException(MessageTranslator.translate("error.host.connect", hostName, e.getMessage(), RteReturnCode.SQLSTART_REQUIRED.getCommunicationErrorCode()), RteReturnCode.SQLSTART_REQUIRED, sqlex);
            }
            catch (IOException e) {
                sqlex = SQLExceptionSapDB.newInstance((Throwable)e, "error.ssl.keystoreloadfailed.ioexception", e.getMessage());
                this._throwRTEException(MessageTranslator.translate("error.host.connect", hostName, e.getMessage(), RteReturnCode.SQLSTART_REQUIRED.getCommunicationErrorCode()), RteReturnCode.SQLSTART_REQUIRED, sqlex);
            }
            catch (InvalidKeySpecException e) {
                sqlex = SQLExceptionSapDB.newInstance((Throwable)e, "error.ssl.truststoreloadfailed.invalidkeyspec", e.getMessage());
                this._throwRTEException(MessageTranslator.translate("error.host.connect", hostName, e.getMessage(), RteReturnCode.SQLSTART_REQUIRED.getCommunicationErrorCode()), RteReturnCode.SQLSTART_REQUIRED, sqlex);
            }
            catch (KeyStoreException e) {
                this._throwRTEException(MessageTranslator.translate("error.host.connect", hostName, "Key manager initialization failed: " + e.getMessage(), RteReturnCode.SQLSTART_REQUIRED.getCommunicationErrorCode()), RteReturnCode.SQLSTART_REQUIRED);
            }
        }
        try {
            kmf.init(ks, passwd);
        }
        catch (KeyStoreException e) {
            this._throwRTEException(MessageTranslator.translate("error.host.connect", hostName, "Key manager initialization failed: " + e.getMessage(), RteReturnCode.SQLSTART_REQUIRED.getCommunicationErrorCode()), RteReturnCode.SQLSTART_REQUIRED);
        }
        catch (UnrecoverableKeyException e) {
            sqlex = SQLExceptionSapDB.newInstance((Throwable)e, "error.ssl.keymanagerfactory.unrecoverablekey", e.getMessage());
            this._throwRTEException(MessageTranslator.translate("error.host.connect", hostName, e.getMessage(), RteReturnCode.SQLSTART_REQUIRED.getCommunicationErrorCode()), RteReturnCode.SQLSTART_REQUIRED, sqlex);
        }
        catch (NoSuchAlgorithmException e) {
            sqlex = SQLExceptionSapDB.newInstance((Throwable)e, "error.ssl.keymanagerfactory.nosuchalgorithm", e.getMessage());
            this._throwRTEException(MessageTranslator.translate("error.host.connect", hostName, e.getMessage(), RteReturnCode.SQLSTART_REQUIRED.getCommunicationErrorCode()), RteReturnCode.SQLSTART_REQUIRED, sqlex);
        }
        return kmf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TrustManagerFactory _getTrustManagerFactory(String hostName) throws RTEException {
        SQLException sqlex;
        KeyStore ks;
        TrustManagerFactory tmf;
        block28: {
            char[] passwd;
            String type;
            String algorithm;
            String trustStoreFileName = this._getTrustStoreFileName();
            if (this._sslTrustStore == null && trustStoreFileName == null) {
                return null;
            }
            tmf = null;
            ks = null;
            if (this._sslTrustStore != null) {
                algorithm = "SunX509";
                type = "JKS";
                passwd = null;
            } else {
                algorithm = TrustManagerFactory.getDefaultAlgorithm();
                type = this._getTrustStoreType();
                String passwdString = this._getTrustStorePasswd();
                passwd = passwdString != null ? passwdString.toCharArray() : null;
            }
            try {
                tmf = TrustManagerFactory.getInstance(algorithm);
            }
            catch (NoSuchAlgorithmException e) {
                sqlex = SQLExceptionSapDB.newInstance((Throwable)e, "error.ssl.trustmanagerfactorynodefault", e.getMessage());
                this._throwRTEException(MessageTranslator.translate("error.host.connect", hostName, e.getMessage(), RteReturnCode.SQLSTART_REQUIRED.getCommunicationErrorCode()), RteReturnCode.SQLSTART_REQUIRED, sqlex);
            }
            try {
                ks = KeyStore.getInstance(type);
            }
            catch (KeyStoreException e) {
                sqlex = SQLExceptionSapDB.newInstance((Throwable)e, "error.ssl.truststore.create", e.getMessage());
                this._throwRTEException(MessageTranslator.translate("error.host.connect", hostName, e.getMessage(), RteReturnCode.SQLSTART_REQUIRED.getCommunicationErrorCode()), RteReturnCode.SQLSTART_REQUIRED, sqlex);
            }
            try {
                if (this._sslTrustStore != null) {
                    ks.load(null);
                    List<Certificate> certs = SecureSession._createCertificatesFromPEM(this._sslTrustStore);
                    int n = certs.size();
                    for (int i = 0; i < n; ++i) {
                        ks.setCertificateEntry("cert-alias-" + i, certs.get(i));
                    }
                    break block28;
                }
                FileInputStream fis = null;
                try {
                    fis = new FileInputStream(trustStoreFileName);
                    ks.load(fis, passwd);
                }
                catch (FileNotFoundException e) {
                    sqlex = SQLExceptionSapDB.newInstance((Throwable)e, "error.ssl.truststorefilenotfound", e.getMessage());
                    this._throwRTEException(MessageTranslator.translate("error.host.connect", hostName, e.getMessage(), RteReturnCode.SQLSTART_REQUIRED.getCommunicationErrorCode()), RteReturnCode.SQLSTART_REQUIRED, sqlex);
                }
                finally {
                    if (fis != null) {
                        try {
                            fis.close();
                        }
                        catch (IOException e) {}
                    }
                }
            }
            catch (NoSuchAlgorithmException e) {
                sqlex = SQLExceptionSapDB.newInstance((Throwable)e, "error.ssl.truststoreloadfailed.nosuchalgorithm", e.getMessage());
                this._throwRTEException(MessageTranslator.translate("error.host.connect", hostName, e.getMessage(), RteReturnCode.SQLSTART_REQUIRED.getCommunicationErrorCode()), RteReturnCode.SQLSTART_REQUIRED, sqlex);
            }
            catch (CertificateException e) {
                sqlex = SQLExceptionSapDB.newInstance((Throwable)e, "error.ssl.truststoreloadfailed.certificate", e.getMessage());
                this._throwRTEException(MessageTranslator.translate("error.host.connect", hostName, e.getMessage(), RteReturnCode.SQLSTART_REQUIRED.getCommunicationErrorCode()), RteReturnCode.SQLSTART_REQUIRED, sqlex);
            }
            catch (IOException e) {
                sqlex = SQLExceptionSapDB.newInstance((Throwable)e, "error.ssl.truststoreloadfailed.ioexception", e.getMessage());
                this._throwRTEException(MessageTranslator.translate("error.host.connect", hostName, e.getMessage(), RteReturnCode.SQLSTART_REQUIRED.getCommunicationErrorCode()), RteReturnCode.SQLSTART_REQUIRED, sqlex);
            }
            catch (KeyStoreException e) {
                sqlex = SQLExceptionSapDB.newInstance((Throwable)e, "error.ssl.trustmanagerfactory.keystore", e.getMessage());
                this._throwRTEException(MessageTranslator.translate("error.host.connect", hostName, e.getMessage(), RteReturnCode.SQLSTART_REQUIRED.getCommunicationErrorCode()), RteReturnCode.SQLSTART_REQUIRED, sqlex);
            }
        }
        try {
            tmf.init(ks);
        }
        catch (KeyStoreException e) {
            sqlex = SQLExceptionSapDB.newInstance((Throwable)e, "error.ssl.trustmanagerfactory.keystore", e.getMessage());
            this._throwRTEException(MessageTranslator.translate("error.host.connect", hostName, e.getMessage(), RteReturnCode.SQLSTART_REQUIRED.getCommunicationErrorCode()), RteReturnCode.SQLSTART_REQUIRED, sqlex);
        }
        return tmf;
    }

    private String _getKeyStoreFileName() {
        return this._keyStore != null ? this._keyStore : System.getProperty("javax.net.ssl.keyStore");
    }

    private String _getKeyStoreType() {
        return this._keyStoreType != null ? this._keyStoreType : "JKS";
    }

    private String _getKeyStorePasswd() {
        if (this._keyStorePasswd != null) {
            return this._keyStorePasswd;
        }
        String syspasswd = System.getProperty("javax.net.ssl.keyStorePassword");
        if (syspasswd != null) {
            return syspasswd;
        }
        return "";
    }

    private String _getTrustStoreFileName() {
        return this._trustStore != null ? this._trustStore : System.getProperty("javax.net.ssl.trustStore");
    }

    private String _getTrustStoreType() {
        return this._trustStoreType != null ? this._trustStoreType : "JKS";
    }

    private String _getTrustStorePasswd() {
        return this._trustStorePasswd != null ? this._trustStorePasswd : System.getProperty("javax.net.ssl.trustStorePassword");
    }

    private void _validateHostName(Certificate[] certs, String hostName) throws RTEException {
        if (!"*".equals(this._hostNameInCertificate) && this._validateCertificate) {
            SQLException sqlex;
            if (certs.length == 0) {
                sqlex = SQLExceptionSapDB.newInstance("error.ssl.nocertificatefound", new String[0]);
                this._throwRTEException(MessageTranslator.translate("error.host.connect", hostName, sqlex.getMessage(), RteReturnCode.SQLSTART_REQUIRED.getCommunicationErrorCode()), RteReturnCode.SQLSTART_REQUIRED, sqlex);
            }
            try {
                HostnameVerifier hostnameVerifier;
                java.security.cert.X509Certificate x509cert = (java.security.cert.X509Certificate)certs[0];
                X500Principal principal = x509cert.getSubjectX500Principal();
                String rfc2253name = principal.getName("RFC2253");
                Collection<List<?>> alternativenames = x509cert.getSubjectAlternativeNames();
                if (!(SSLUtils.validateHostName(rfc2253name, alternativenames, this._hostNameInCertificate == null ? hostName : this._hostNameInCertificate) || (hostnameVerifier = Driver.getHostnameVerifier()) != null && hostnameVerifier.verify(hostName, this._sslSession))) {
                    sqlex = SQLExceptionSapDB.newInstance("error.ssl.hostnameverificationfailed", rfc2253name, this._hostNameInCertificate == null ? hostName : this._hostNameInCertificate);
                    this._throwRTEException(MessageTranslator.translate("error.host.connect", hostName, sqlex.getMessage(), RteReturnCode.SQLSTART_REQUIRED.getCommunicationErrorCode()), RteReturnCode.SQLSTART_REQUIRED, sqlex);
                }
            }
            catch (ClassCastException e) {
                sqlex = SQLExceptionSapDB.newInstance((Throwable)e, "error.ssl.nox509certificate", new String[0]);
                this._throwRTEException(MessageTranslator.translate("error.host.connect", hostName, sqlex.getMessage(), RteReturnCode.SQLSTART_REQUIRED.getCommunicationErrorCode()), RteReturnCode.SQLSTART_REQUIRED, sqlex);
            }
            catch (CertificateParsingException e) {
                sqlex = SQLExceptionSapDB.newInstance((Throwable)e, "error.ssl.nox509certificate", new String[0]);
                this._throwRTEException(MessageTranslator.translate("error.host.connect", hostName, sqlex.getMessage(), RteReturnCode.SQLSTART_REQUIRED.getCommunicationErrorCode()), RteReturnCode.SQLSTART_REQUIRED, sqlex);
            }
        }
    }

    private static List<Certificate> _createCertificatesFromPEM(String pem) throws CertificateException {
        ArrayList<Certificate> certs = new ArrayList<Certificate>();
        List<byte[]> certsBytes = Base64Utils.decodeCertificates(pem);
        CertificateFactory factory = CertificateFactory.getInstance("X.509");
        for (byte[] certBytes : certsBytes) {
            Certificate cert = factory.generateCertificate(new ByteArrayInputStream(certBytes));
            certs.add(cert);
        }
        return certs;
    }

    private static List<PrivateKey> _createPrivateKeysFromPEM(String pem) throws NoSuchAlgorithmException, InvalidKeySpecException {
        ArrayList<PrivateKey> keys = new ArrayList<PrivateKey>();
        List<byte[]> keysBytes = Base64Utils.decodePrivateKeys(pem);
        KeyFactory factory = KeyFactory.getInstance("RSA");
        for (byte[] keyBytes : keysBytes) {
            PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(keyBytes);
            PrivateKey key = factory.generatePrivate(keySpec);
            keys.add(key);
        }
        return keys;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _doHandshake() throws RTEException {
        SSLEngineResult.HandshakeStatus handshakeStatus = this._sslEngine.getHandshakeStatus();
        boolean underflowCount = false;
        try {
            this._sslEngine.beginHandshake();
            handshakeStatus = this._sslEngine.getHandshakeStatus();
            SSLSession handshakeSession = this._sslEngine.getSession();
            int packetBufferSize = handshakeSession.getPacketBufferSize();
            int applicationBufferSize = handshakeSession.getApplicationBufferSize();
            ByteBuffer sendBuffer = ByteBuffer.allocate(packetBufferSize);
            ByteBuffer receiveBuffer = ByteBuffer.allocate(packetBufferSize);
            BufferUtils.flip(receiveBuffer);
            ByteBuffer applicationBuffer = ByteBuffer.allocate(applicationBufferSize);
            block23: while (true) {
                switch (handshakeStatus) {
                    case NOT_HANDSHAKING: 
                    case FINISHED: {
                        break block23;
                    }
                    case NEED_WRAP: {
                        SSLEngineResult result = this._sslEngine.wrap(applicationBuffer, sendBuffer);
                        handshakeStatus = result.getHandshakeStatus();
                        switch (result.getStatus()) {
                            case OK: {
                                break;
                            }
                            case BUFFER_UNDERFLOW: {
                                throw new AssertionError((Object)"Unexpected buffer underflow");
                            }
                            case BUFFER_OVERFLOW: {
                                throw new AssertionError((Object)"Unexpected buffer overflow");
                            }
                            case CLOSED: {
                                this._throwRTEException(MessageTranslator.translate("error.objectisclosed", this.toString()), RteReturnCode.SQLSEND_LINE_DOWN);
                                break;
                            }
                            default: {
                                throw new AssertionError((Object)("Unknown status: " + (Object)((Object)result.getStatus())));
                            }
                        }
                        BufferUtils.flip(sendBuffer);
                        this._writeBytes(sendBuffer.array(), sendBuffer.limit());
                        BufferUtils.clear(sendBuffer);
                        continue block23;
                    }
                    case NEED_UNWRAP: {
                        int readCount;
                        SSLEngineResult result;
                        if (receiveBuffer.remaining() == 0) {
                            BufferUtils.clear(receiveBuffer);
                            readCount = this._readBytes(receiveBuffer.array(), 0, receiveBuffer.capacity());
                            if (readCount == -1) {
                                this._throwRTEException(MessageTranslator.translate("error.objectisclosed", this.toString()), RteReturnCode.SQLRECEIVE_LINE_DOWN);
                            }
                            BufferUtils.position(receiveBuffer, readCount);
                            BufferUtils.flip(receiveBuffer);
                        }
                        int i = 0;
                        while (true) {
                            if (i >= 500) continue block23;
                            result = this._sslEngine.unwrap(receiveBuffer, applicationBuffer);
                            handshakeStatus = result.getHandshakeStatus();
                            switch (result.getStatus()) {
                                case OK: {
                                    continue block23;
                                }
                                case BUFFER_UNDERFLOW: {
                                    receiveBuffer.compact();
                                    readCount = this._readBytes(receiveBuffer.array(), receiveBuffer.position(), receiveBuffer.capacity() - receiveBuffer.position());
                                    if (readCount == -1) {
                                        this._throwRTEException(MessageTranslator.translate("error.objectisclosed", this.toString()), RteReturnCode.SQLRECEIVE_LINE_DOWN);
                                    }
                                    BufferUtils.position(receiveBuffer, receiveBuffer.position() + readCount);
                                    BufferUtils.flip(receiveBuffer);
                                    break;
                                }
                                case BUFFER_OVERFLOW: {
                                    throw new AssertionError((Object)"Unexpected buffer overflow");
                                }
                                case CLOSED: {
                                    this._throwRTEException(MessageTranslator.translate("error.objectisclosed", this.toString()), RteReturnCode.SQLRECEIVE_LINE_DOWN);
                                    break;
                                }
                                default: {
                                    throw new AssertionError((Object)("Unknown status: " + (Object)((Object)result.getStatus())));
                                }
                            }
                            ++i;
                        }
                    }
                    case NEED_TASK: {
                        this._sslEngine.getDelegatedTask().run();
                        handshakeStatus = this._sslEngine.getHandshakeStatus();
                        continue block23;
                    }
                    default: {
                        throw new AssertionError((Object)("Unknown handshake status: " + (Object)((Object)handshakeStatus)));
                    }
                }
                break;
            }
        }
        catch (SSLHandshakeException e) {
            SQLException sqlex = e.getMessage().contains("PKIX path building failed") ? SQLExceptionSapDB.newInstance((Throwable)e, "error.ssl.certificatepath", e.getMessage()) : SQLExceptionSapDB.newInstance((Throwable)e, "error.ssl.handshake", e.getMessage());
            this._throwRTEException(MessageTranslator.translate("error.host.connect", this._address.toString(), e.getMessage(), RteReturnCode.SQLSTART_REQUIRED.getCommunicationErrorCode()), RteReturnCode.SQLSERVER_OR_DB_UNKNOWN, RteReturnCode.SQLSTART_REQUIRED.getCommunicationErrorCode(), sqlex);
        }
        catch (SSLException e) {
            SQLException sqlex = e.getMessage().contains("Received fatal alert: internal_error") ? SQLExceptionSapDB.newInstance((Throwable)e, "error.ssl.nosslsupport", e.getMessage()) : SQLExceptionSapDB.newInstance((Throwable)e, "error.ssl.handshake", e.getMessage());
            this._throwRTEException(MessageTranslator.translate("error.host.connect", this._address.toString(), e.getMessage(), RteReturnCode.SQLSTART_REQUIRED.getCommunicationErrorCode()), RteReturnCode.SQLSERVER_OR_DB_UNKNOWN, RteReturnCode.SQLSTART_REQUIRED.getCommunicationErrorCode(), sqlex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _encodeBytes(byte[] buffer, int len) throws RTEException {
        SSLEngineResult.HandshakeStatus handshakeStatus = this._sslEngine.getHandshakeStatus();
        ByteBuffer src = ByteBuffer.wrap(buffer, 0, len);
        try {
            BufferUtils.clear(this._sendBuffer);
            while (src.remaining() > 0) {
                switch (handshakeStatus) {
                    case NOT_HANDSHAKING: 
                    case FINISHED: 
                    case NEED_WRAP: {
                        break;
                    }
                    case NEED_UNWRAP: 
                    case NEED_TASK: {
                        throw new AssertionError((Object)("Unexpected handshake status: " + (Object)((Object)handshakeStatus)));
                    }
                    default: {
                        throw new AssertionError((Object)("Unknown handshake status: " + (Object)((Object)handshakeStatus)));
                    }
                }
                SSLEngineResult result = this._sslEngine.wrap(src, this._sendBuffer);
                handshakeStatus = result.getHandshakeStatus();
                switch (result.getStatus()) {
                    case OK: {
                        break;
                    }
                    case BUFFER_UNDERFLOW: {
                        throw new AssertionError((Object)"Unexpected buffer underflow");
                    }
                    case BUFFER_OVERFLOW: {
                        throw new AssertionError((Object)"Unexpected buffer overflow");
                    }
                    case CLOSED: {
                        this._throwRTEException(MessageTranslator.translate("error.objectisclosed", this.toString()), RteReturnCode.SQLSEND_LINE_DOWN);
                        break;
                    }
                    default: {
                        throw new AssertionError((Object)("Unknown status: " + (Object)((Object)result.getStatus())));
                    }
                }
                BufferUtils.flip(this._sendBuffer);
                this._writeBytes(this._sendBuffer.array(), this._sendBuffer.limit());
                BufferUtils.clear(this._sendBuffer);
            }
        }
        catch (SSLException e) {
            this._throwRTEException(MessageTranslator.translate("error.wrap.failed", e.getMessage()), RteReturnCode.SQLSEND_LINE_DOWN);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int _decodeBytes(byte[] buffer, int off, int len) throws RTEException {
        SSLEngineResult.HandshakeStatus handshakeStatus = this._sslEngine.getHandshakeStatus();
        int pos = off;
        boolean underflowCount = false;
        boolean overflowCount = false;
        try {
            int copiedCount;
            BufferUtils.clear(this._receiveBuffer);
            for (int remaining = len; remaining > 0; remaining -= copiedCount) {
                if (this._applicationBuffer.remaining() == 0) {
                    BufferUtils.clear(this._applicationBuffer);
                    BufferUtils.clear(this._receiveBuffer);
                    int readCount = this._readBytes(this._receiveBuffer.array(), 0, this._receiveBuffer.capacity());
                    if (readCount == -1) {
                        this._throwRTEException(MessageTranslator.translate("error.objectisclosed", this.toString()), RteReturnCode.SQLRECEIVE_LINE_DOWN);
                    }
                    BufferUtils.position(this._receiveBuffer, readCount);
                    BufferUtils.flip(this._receiveBuffer);
                    block15: while (this._receiveBuffer.remaining() > 0) {
                        block16: for (int i = 0; i < 500; ++i) {
                            switch (this._sslEngine.getHandshakeStatus()) {
                                case NOT_HANDSHAKING: 
                                case FINISHED: 
                                case NEED_UNWRAP: {
                                    break;
                                }
                                case NEED_WRAP: 
                                case NEED_TASK: {
                                    throw new AssertionError((Object)("Unexpected handshake status: " + (Object)((Object)handshakeStatus)));
                                }
                                default: {
                                    throw new AssertionError((Object)("Unknown handshake status: " + (Object)((Object)handshakeStatus)));
                                }
                            }
                            SSLEngineResult result = this._sslEngine.unwrap(this._receiveBuffer, this._applicationBuffer);
                            handshakeStatus = result.getHandshakeStatus();
                            switch (result.getStatus()) {
                                case OK: {
                                    continue block15;
                                }
                                case BUFFER_UNDERFLOW: {
                                    this._receiveBuffer.compact();
                                    readCount = this._readBytes(this._receiveBuffer.array(), this._receiveBuffer.position(), this._receiveBuffer.capacity() - this._receiveBuffer.position());
                                    if (readCount == -1) {
                                        this._throwRTEException(MessageTranslator.translate("error.objectisclosed", this.toString()), RteReturnCode.SQLRECEIVE_LINE_DOWN);
                                    }
                                    BufferUtils.position(this._receiveBuffer, this._receiveBuffer.position() + readCount);
                                    BufferUtils.flip(this._receiveBuffer);
                                    continue block16;
                                }
                                case BUFFER_OVERFLOW: {
                                    BufferUtils.flip(this._applicationBuffer);
                                    ByteBuffer temp = ByteBuffer.allocate(this._applicationBuffer.capacity() * 2);
                                    temp.put(this._applicationBuffer);
                                    this._applicationBuffer = temp;
                                    continue block16;
                                }
                                case CLOSED: {
                                    this._throwRTEException(MessageTranslator.translate("error.objectisclosed", this.toString()), RteReturnCode.SQLRECEIVE_LINE_DOWN);
                                    continue block16;
                                }
                                default: {
                                    throw new AssertionError((Object)("Unknown status: " + (Object)((Object)result.getStatus())));
                                }
                            }
                        }
                    }
                    BufferUtils.flip(this._applicationBuffer);
                }
                copiedCount = Math.min(remaining, this._applicationBuffer.remaining());
                this._applicationBuffer.get(buffer, pos, copiedCount);
                pos += copiedCount;
            }
        }
        catch (SSLException e) {
            this._throwRTEException(MessageTranslator.translate("error.unwrap.failed", e.getMessage()), RteReturnCode.SQLRECEIVE_LINE_DOWN);
        }
        return len;
    }
}

