/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.jdbc.trace;

import com.sap.db.annotations.GuardedBy;
import com.sap.db.annotations.ThreadSafe;
import com.sap.db.jdbc.trace.TraceRecord;
import com.sap.db.util.FileUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;

@ThreadSafe
public class TraceRecordPublisher {
    private static final TraceRecordPublisher INSTANCE = new TraceRecordPublisher();
    @GuardedBy(value="this")
    private String _performanceTraceFilePath = "jdbcperformancetrace.prt";
    @GuardedBy(value="this")
    private PrintWriter _writer;
    @GuardedBy(value="TraceRecordPublisher.class")
    private static boolean _isTestMode;
    @GuardedBy(value="this")
    private TraceRecord _testLastTraceRecord;

    public static TraceRecordPublisher getInstance() {
        return INSTANCE;
    }

    private TraceRecordPublisher() {
    }

    public synchronized String getPerformanceTraceFilePath() {
        return this._performanceTraceFilePath;
    }

    public synchronized void setPerformanceTraceFilePath(String performanceTraceFilePath) {
        if (performanceTraceFilePath == null && this._performanceTraceFilePath == null || performanceTraceFilePath.equals(this._performanceTraceFilePath)) {
            return;
        }
        this._performanceTraceFilePath = performanceTraceFilePath;
        this.close();
    }

    public synchronized void publish(TraceRecord r) {
        if (TraceRecordPublisher.isTestMode()) {
            this._testLastTraceRecord = r;
            return;
        }
        this._checkWriter();
        this._writer.println(r.toString());
    }

    public synchronized void close() {
        if (this._writer == null) {
            return;
        }
        this._writer.close();
        this._writer = null;
    }

    private void _checkWriter() {
        if (this._writer != null) {
            return;
        }
        this.close();
        String fileName = FileUtils.getFileName(this._performanceTraceFilePath);
        String fileExtension = FileUtils.getFileExtension(this._performanceTraceFilePath);
        String directoryName = FileUtils.getDirectoryName(this._performanceTraceFilePath);
        File directory = FileUtils.createDirectoryIfNecessary(directoryName);
        try {
            File file = File.createTempFile(fileName, fileExtension, directory);
            FileUtils.limitAccessToReadWriteByOwner(file);
            this._writer = new PrintWriter(new FileOutputStream(file), true);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static synchronized boolean isTestMode() {
        return _isTestMode;
    }

    public static synchronized void setTestMode(boolean isTestMode) {
        _isTestMode = isTestMode;
    }

    public synchronized TraceRecord getLastTraceRecord() {
        return this._testLastTraceRecord;
    }
}

