/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.util;

import com.sap.db.annotations.Immutable;
import com.sap.db.jdbc.RteReturnCode;
import com.sap.db.jdbc.exceptions.RTEException;
import com.sap.db.jdbc.trace.Tracer;
import com.sap.db.util.Base64Utils;
import com.sap.db.util.ByteUtils;
import com.sap.db.util.CharsetUtils;
import com.sap.db.util.MessageTranslator;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.Socket;

@Immutable
public final class ProxyUtils {
    private static final byte DBG_FILLER = -2;
    private static final String ERROR_WRITE_FAILED = "Write error";
    private static final String ERROR_READ_FAILED = "Read error";
    private static final String ERROR_CONNECT_FAILED = "Connect failed";

    private ProxyUtils() {
        throw new AssertionError((Object)"Non-instantiable class");
    }

    public static void doSocksAuthentication(Tracer tracer, Socket socket, String host, int port, String proxyUserName, String proxyPassword, String proxyScpAccount) throws RTEException {
        InputStream inputStream;
        OutputStream outputStream;
        byte[] buffer = new byte[1024];
        try {
            outputStream = socket.getOutputStream();
        }
        catch (IOException e) {
            throw new RTEException(tracer, MessageTranslator.translate("error.socks.connect", ERROR_WRITE_FAILED, e.getMessage()), RteReturnCode.SQLSEND_LINE_DOWN);
        }
        try {
            inputStream = socket.getInputStream();
        }
        catch (IOException e) {
            throw new RTEException(tracer, MessageTranslator.translate("error.socks.connect", ERROR_READ_FAILED, e.getMessage()), RteReturnCode.SQLRECEIVE_LINE_DOWN);
        }
        int method = Socks._doNegotiationForAuthenticationMethod(tracer, buffer, outputStream, inputStream);
        switch (method) {
            case 0: {
                break;
            }
            case 1: {
                throw new RTEException(tracer, MessageTranslator.translate("error.socks.connect", "Unsupported authentication method", method), RteReturnCode.SQLRECEIVE_LINE_DOWN);
            }
            case 2: {
                Socks._doUserNamePasswordAuthentication(tracer, buffer, outputStream, inputStream, proxyUserName, proxyPassword, proxyScpAccount);
                break;
            }
            case 128: {
                Socks._doCustomJWTAuthentication(tracer, outputStream, inputStream, proxyUserName, proxyPassword, proxyScpAccount);
                break;
            }
            default: {
                throw new AssertionError((Object)("Unexpected method type: " + method));
            }
        }
        Socks._doConnect(tracer, buffer, outputStream, inputStream, host, port);
    }

    public static void doHttpAuthentication(Tracer tracer, Socket socket, String host, int port, String proxyUserName, String proxyPassword) throws RTEException {
        InputStream inputStream;
        OutputStream outputStream;
        try {
            outputStream = socket.getOutputStream();
        }
        catch (IOException e) {
            throw new RTEException(tracer, MessageTranslator.translate("error.http.connect", ERROR_WRITE_FAILED, e.getMessage()), RteReturnCode.SQLSEND_LINE_DOWN);
        }
        try {
            inputStream = socket.getInputStream();
        }
        catch (IOException e) {
            throw new RTEException(tracer, MessageTranslator.translate("error.http.connect", ERROR_READ_FAILED, e.getMessage()), RteReturnCode.SQLRECEIVE_LINE_DOWN);
        }
        Http._doConnect(tracer, outputStream, inputStream, host, port, proxyUserName, proxyPassword);
    }

    private static class Http {
        private static final String HTTP_NEWLINE = "\r\n";

        private Http() {
        }

        private static void _doConnect(Tracer tracer, OutputStream outputStream, InputStream inputStream, String host, int port, String proxyUserName, String proxyPassword) throws RTEException {
            String address = host + ":" + port;
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(outputStream, CharsetUtils.US_ASCII));
            BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream, CharsetUtils.US_ASCII));
            boolean ok = false;
            int status = -1;
            String message = "Unknown error";
            try {
                writer.write("CONNECT " + address + " HTTP/1.1" + HTTP_NEWLINE);
                writer.write("Host: " + address + HTTP_NEWLINE);
                if (proxyUserName != null && !proxyUserName.isEmpty() || proxyPassword != null && !proxyPassword.isEmpty()) {
                    String credentials = Base64Utils.encodeToString((proxyUserName + ":" + proxyPassword).getBytes(CharsetUtils.US_ASCII));
                    writer.write("Proxy-Authorization: basic " + credentials + HTTP_NEWLINE);
                }
                writer.write(HTTP_NEWLINE);
                writer.flush();
            }
            catch (IOException e) {
                throw new RTEException(tracer, MessageTranslator.translate("error.http.connect", ProxyUtils.ERROR_WRITE_FAILED, e.getMessage()), RteReturnCode.SQLSEND_LINE_DOWN);
            }
            try {
                int idx2;
                int idx1;
                String line = reader.readLine();
                if (line != null && (idx1 = line.indexOf(32)) != -1 && (idx2 = line.indexOf(32, idx1 + 1)) != -1) {
                    try {
                        status = Integer.parseInt(line.substring(idx1 + 1, idx2));
                    }
                    catch (NumberFormatException e) {
                        throw new RTEException(tracer, MessageTranslator.translate("error.http.connect", ProxyUtils.ERROR_READ_FAILED, "Can't parse HTTP Connect response: " + line), RteReturnCode.SQLRECEIVE_LINE_DOWN);
                    }
                    message = line.substring(idx2 + 1);
                    boolean bl = ok = status > 0 && status < 300;
                }
                if (!ok) {
                    throw new RTEException(tracer, MessageTranslator.translate("error.http.connect", ProxyUtils.ERROR_READ_FAILED, "Status: " + status + " " + message), RteReturnCode.SQLRECEIVE_LINE_DOWN);
                }
                while ((reader.ready() || inputStream.available() != 0) && (line = reader.readLine()) != null) {
                }
            }
            catch (IOException e) {
                throw new RTEException(tracer, MessageTranslator.translate("error.http.connect", ProxyUtils.ERROR_READ_FAILED, e.getMessage()), RteReturnCode.SQLRECEIVE_LINE_DOWN);
            }
        }
    }

    private static class Socks {
        private static final int BUFFER_SIZE = 1024;
        private static final int SOCKS_VERSION = 5;
        private static final int METHOD_NO_AUTHENTICATION_REQUIRED = 0;
        private static final int METHOD_GSSAPI = 1;
        private static final int METHOD_USERNAME_PASSWORD = 2;
        private static final int METHOD_CUSTOM_SAPCLOUD_JWT = 128;
        private static final int METHOD_VERSION = 1;
        private static final int METHOD_USERNAME_PASSWORD_MAX_ULEN = 255;
        private static final int METHOD_USERNAME_PASSWORD_MAX_PLEN = 255;
        private static final int METHOD_CUSTOM_SAPCLOUD_JWT_MAX_ULEN = 524288;
        private static final int METHOD_CUSTOM_SAPCLOUD_JWT_MAX_PLEN = 255;
        private static final int METHOD_STATUS_OK = 0;
        private static final int MAX_ADDR_LENGTH = 255;
        private static final int MAX_PORT_VALUE = 65535;
        private static final int COMMAND_CONNECT = 1;
        private static final int ADDRESS_TYPE_IPV4 = 1;
        private static final int ADDRESS_TYPE_DOMAINNAME = 3;
        private static final int ADDRESS_TYPE_IPV6 = 4;
        private static final int RESERVED = 0;
        private static final String ERROR_UNSUPPORTED_SOCKS_VERSION = "Unsupported SOCKS version";
        private static final String ERROR_UNSUPPORTED_AUTHENTICATION_METHOD = "Unsupported authentication method";
        private static final String ERROR_USERNAME_NOT_SPECIFIED = "User name not specified";
        private static final String ERROR_USERNAME_TOO_LONG = "User name too long";
        private static final String ERROR_PASSWORD_NOT_SPECIFIED = "Password not specified";
        private static final String ERROR_PASSWORD_TOO_LONG = "Password too long";
        private static final String ERROR_UNSUPPORTED_AUTHENTICATION_METHOD_VERSION = "Unsupported authentication method version";
        private static final String ERROR_AUTHENTICATION_FAILED = "Authentication failed";
        private static final String ERROR_ADDRESS_NOT_SPECIFIED = "Address not specified";
        private static final String ERROR_ADDRESS_TOO_LONG = "Address too long";
        private static final String ERROR_PORT_OUT_OF_RANGE = "Port out of range";

        private Socks() {
        }

        private static int _doNegotiationForAuthenticationMethod(Tracer tracer, byte[] buffer, OutputStream outputStream, InputStream inputStream) throws RTEException {
            int off = 0;
            ByteUtils.putByte(5, buffer, off++);
            ByteUtils.putByte(4, buffer, off++);
            ByteUtils.putByte(0, buffer, off++);
            ByteUtils.putByte(1, buffer, off++);
            ByteUtils.putByte(2, buffer, off++);
            ByteUtils.putByte(128, buffer, off++);
            int len = off;
            Socks._write(tracer, outputStream, buffer, len);
            Socks._read(tracer, inputStream, buffer, 2);
            off = 0;
            int ver = ByteUtils.getUByte(buffer, off++);
            if (ver != 5) {
                throw new RTEException(tracer, MessageTranslator.translate("error.socks.connect", ERROR_UNSUPPORTED_SOCKS_VERSION, ver), RteReturnCode.SQLRECEIVE_LINE_DOWN);
            }
            int method = ByteUtils.getUByte(buffer, off++);
            switch (method) {
                case 0: 
                case 1: 
                case 2: 
                case 128: {
                    break;
                }
                default: {
                    throw new RTEException(tracer, MessageTranslator.translate("error.socks.connect", ERROR_UNSUPPORTED_AUTHENTICATION_METHOD, method), RteReturnCode.SQLRECEIVE_LINE_DOWN);
                }
            }
            return method;
        }

        private static void _doUserNamePasswordAuthentication(Tracer tracer, byte[] buffer, OutputStream outputStream, InputStream inputStream, String proxyUserName, String proxyPassword, String proxyScpAccount) throws RTEException {
            if (proxyScpAccount != null && !proxyScpAccount.isEmpty()) {
                int idx = proxyScpAccount.indexOf(46);
                if (idx != -1) {
                    byte[] leftPart = proxyScpAccount.substring(0, idx - 1).getBytes(CharsetUtils.US_ASCII);
                    byte[] rightPart = proxyScpAccount.substring(idx + 1).getBytes(CharsetUtils.US_ASCII);
                    proxyUserName = "1." + Base64Utils.encodeToString(leftPart) + '.' + Base64Utils.encodeToString(rightPart);
                } else {
                    proxyUserName = "1." + Base64Utils.encodeToString(proxyScpAccount.getBytes(CharsetUtils.US_ASCII));
                }
            }
            if (proxyUserName == null || proxyUserName.isEmpty()) {
                throw new RTEException(tracer, MessageTranslator.translate("error.socks.connect", ERROR_USERNAME_NOT_SPECIFIED, ""), RteReturnCode.SQLSEND_LINE_DOWN);
            }
            byte[] uname = proxyUserName.getBytes(CharsetUtils.US_ASCII);
            int ulen = uname.length;
            if (ulen > 255) {
                throw new RTEException(tracer, MessageTranslator.translate("error.socks.connect", ERROR_USERNAME_TOO_LONG, "maximum supported length is 255"), RteReturnCode.SQLSEND_LINE_DOWN);
            }
            if (proxyPassword == null || proxyPassword.isEmpty()) {
                throw new RTEException(tracer, MessageTranslator.translate("error.socks.connect", ERROR_PASSWORD_NOT_SPECIFIED, ""), RteReturnCode.SQLSEND_LINE_DOWN);
            }
            byte[] passwd = proxyPassword.getBytes(CharsetUtils.US_ASCII);
            int plen = passwd.length;
            if (plen > 255) {
                throw new RTEException(tracer, MessageTranslator.translate("error.socks.connect", ERROR_PASSWORD_TOO_LONG, "maximum supported length is 255"), RteReturnCode.SQLSEND_LINE_DOWN);
            }
            int off = 0;
            ByteUtils.putByte(1, buffer, off++);
            ByteUtils.putByte(ulen, buffer, off++);
            ByteUtils.putBytes(uname, buffer, off);
            off += ulen;
            ByteUtils.putByte(plen, buffer, off++);
            ByteUtils.putBytes(passwd, buffer, off);
            int len = off += plen;
            Socks._write(tracer, outputStream, buffer, len);
            Socks._handleAuthenticationReply(tracer, buffer, inputStream);
        }

        private static void _doCustomJWTAuthentication(Tracer tracer, OutputStream outputStream, InputStream inputStream, String proxyUserName, String proxyPassword, String proxyScpAccount) throws RTEException {
            int plen;
            byte[] passwd;
            if (proxyScpAccount != null && !proxyScpAccount.isEmpty()) {
                proxyPassword = Base64Utils.encodeToString(proxyScpAccount.getBytes(CharsetUtils.US_ASCII));
            }
            if (proxyUserName == null || proxyUserName.isEmpty()) {
                throw new RTEException(tracer, MessageTranslator.translate("error.socks.connect", ERROR_USERNAME_NOT_SPECIFIED, ""), RteReturnCode.SQLSEND_LINE_DOWN);
            }
            byte[] uname = proxyUserName.getBytes(CharsetUtils.US_ASCII);
            int ulen = uname.length;
            if (ulen > 524288) {
                throw new RTEException(tracer, MessageTranslator.translate("error.socks.connect", ERROR_USERNAME_TOO_LONG, "maximum supported length is 524288"), RteReturnCode.SQLSEND_LINE_DOWN);
            }
            if (proxyPassword == null || proxyPassword.isEmpty()) {
                passwd = null;
                plen = 0;
            } else {
                passwd = proxyPassword.getBytes(CharsetUtils.US_ASCII);
                plen = passwd.length;
                if (plen > 255) {
                    throw new RTEException(tracer, MessageTranslator.translate("error.socks.connect", ERROR_PASSWORD_TOO_LONG, "maximum supported length is 255"), RteReturnCode.SQLSEND_LINE_DOWN);
                }
            }
            int bufferSize = 5 + ulen + 1 + plen;
            byte[] buffer = new byte[bufferSize];
            int off = 0;
            ByteUtils.putByte(1, buffer, off++);
            ByteUtils.putIntBigEndian(ulen, buffer, off);
            ByteUtils.putBytes(uname, buffer, off += 4);
            off += ulen;
            ByteUtils.putByte(plen, buffer, off++);
            if (plen > 0) {
                ByteUtils.putBytes(passwd, buffer, off);
                off += plen;
            }
            int len = off;
            Socks._write(tracer, outputStream, buffer, len);
            Socks._handleAuthenticationReply(tracer, buffer, inputStream);
        }

        private static void _handleAuthenticationReply(Tracer tracer, byte[] buffer, InputStream inputStream) throws RTEException {
            int status;
            Socks._read(tracer, inputStream, buffer, 2);
            int off = 0;
            int ver = ByteUtils.getUByte(buffer, off++);
            if (ver != 1) {
                throw new RTEException(tracer, MessageTranslator.translate("error.socks.connect", ERROR_UNSUPPORTED_AUTHENTICATION_METHOD_VERSION, ver), RteReturnCode.SQLRECEIVE_LINE_DOWN);
            }
            if ((status = ByteUtils.getUByte(buffer, off++)) != 0) {
                throw new RTEException(tracer, MessageTranslator.translate("error.socks.connect", ERROR_AUTHENTICATION_FAILED, status), RteReturnCode.SQLRECEIVE_LINE_DOWN);
            }
        }

        private static void _doConnect(Tracer tracer, byte[] buffer, OutputStream outputStream, InputStream inputStream, String host, int port) throws RTEException {
            int rsv;
            int rep;
            if (host == null || host.isEmpty()) {
                throw new RTEException(tracer, MessageTranslator.translate("error.socks.connect", ERROR_ADDRESS_NOT_SPECIFIED, ""), RteReturnCode.SQLSEND_LINE_DOWN);
            }
            byte[] dstaddr = host.getBytes(CharsetUtils.US_ASCII);
            int dstaddrlen = dstaddr.length;
            if (dstaddrlen > 255) {
                throw new RTEException(tracer, MessageTranslator.translate("error.socks.connect", ERROR_ADDRESS_TOO_LONG, "maximum supported length is 255"), RteReturnCode.SQLSEND_LINE_DOWN);
            }
            if (port < 0 || port > 65535) {
                throw new RTEException(tracer, MessageTranslator.translate("error.socks.connect", ERROR_PORT_OUT_OF_RANGE, port), RteReturnCode.SQLSEND_LINE_DOWN);
            }
            int off = 0;
            ByteUtils.putByte(5, buffer, off++);
            ByteUtils.putByte(1, buffer, off++);
            ByteUtils.putByte(0, buffer, off++);
            ByteUtils.putByte(3, buffer, off++);
            ByteUtils.putByte(dstaddrlen, buffer, off++);
            ByteUtils.putBytes(dstaddr, buffer, off);
            ByteUtils.putShortBigEndian(port, buffer, off += dstaddrlen);
            int len = off += 2;
            Socks._write(tracer, outputStream, buffer, len);
            Socks._read(tracer, inputStream, buffer, 4);
            off = 0;
            int ver = ByteUtils.getUByte(buffer, off++);
            if (ver != 5) {
                throw new RTEException(tracer, MessageTranslator.translate("error.socks.connect", ERROR_UNSUPPORTED_SOCKS_VERSION, ver), RteReturnCode.SQLRECEIVE_LINE_DOWN);
            }
            if ((rep = ByteUtils.getUByte(buffer, off++)) != 0) {
                String repErrMsg;
                switch (rep) {
                    case 1: {
                        repErrMsg = "General SOCKS server failure";
                        break;
                    }
                    case 2: {
                        repErrMsg = "Connection not allowed by ruleset";
                        break;
                    }
                    case 3: {
                        repErrMsg = "Network unreachable";
                        break;
                    }
                    case 4: {
                        repErrMsg = "Host unreachable";
                        break;
                    }
                    case 5: {
                        repErrMsg = "Connection refused";
                        break;
                    }
                    case 6: {
                        repErrMsg = "TTL expired";
                        break;
                    }
                    case 7: {
                        repErrMsg = "Command not supported";
                        break;
                    }
                    case 8: {
                        repErrMsg = "Address type not supported";
                        break;
                    }
                    default: {
                        repErrMsg = "Unknown error";
                    }
                }
                throw new RTEException(tracer, MessageTranslator.translate("error.socks.connect", ProxyUtils.ERROR_CONNECT_FAILED, rep + ": " + repErrMsg), RteReturnCode.SQLRECEIVE_LINE_DOWN);
            }
            if ((rsv = ByteUtils.getUByte(buffer, off++)) != 0) {
                // empty if block
            }
            int atyp = ByteUtils.getUByte(buffer, off++);
            try {
                inputStream.read(buffer, 0, 1024);
            }
            catch (IOException e) {
                throw new RTEException(tracer, MessageTranslator.translate("error.socks.connect", ProxyUtils.ERROR_READ_FAILED, e.getMessage()), RteReturnCode.SQLRECEIVE_LINE_DOWN);
            }
        }

        private static void _write(Tracer tracer, OutputStream outputStream, byte[] buffer, int len) throws RTEException {
            try {
                outputStream.write(buffer, 0, len);
            }
            catch (IOException e) {
                throw new RTEException(tracer, MessageTranslator.translate("error.socks.connect", ProxyUtils.ERROR_WRITE_FAILED, e.getMessage()), RteReturnCode.SQLSEND_LINE_DOWN);
            }
        }

        private static void _read(Tracer tracer, InputStream inputStream, byte[] buffer, int len) throws RTEException {
            int readCount;
            try {
                readCount = inputStream.read(buffer, 0, len);
            }
            catch (IOException e) {
                throw new RTEException(tracer, MessageTranslator.translate("error.socks.connect", ProxyUtils.ERROR_READ_FAILED, e.getMessage()), RteReturnCode.SQLRECEIVE_LINE_DOWN);
            }
            if (readCount < len) {
                throw new RTEException(tracer, MessageTranslator.translate("error.socks.connect", ProxyUtils.ERROR_READ_FAILED, len), RteReturnCode.SQLRECEIVE_LINE_DOWN);
            }
        }
    }
}

