/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.jdbc.converters;

import com.sap.db.annotations.GuardedBy;
import com.sap.db.annotations.ThreadSafe;
import com.sap.db.jdbc.ColumnEncryptionKey;
import com.sap.db.jdbc.ConnectionSapDB;
import com.sap.db.jdbc.converters.AbstractConverter;
import com.sap.db.jdbc.packet.DataType;
import com.sap.db.jdbc.packet.ParameterMode;
import com.sap.db.jdbc.packet.ParameterOption;
import com.sap.db.util.ByteUtils;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Locale;
import java.util.Set;
import java.util.TimeZone;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@ThreadSafe
abstract class AbstractDateTimeConverter
extends AbstractConverter {
    private static final int DATE_MASK_NULL = 32768;
    private static final int TIME_MASK_NULL = 128;
    private static final long HOURS_PER_DAY = 24L;
    private static final long MINUTES_PER_HOUR = 60L;
    private static final long SECONDS_PER_MINUTE = 60L;
    private static final long SECONDS_PER_HOUR = 3600L;
    private static final long SECONDS_PER_DAY = 86400L;
    private static final long MILLISECONDS_PER_SECOND = 1000L;
    private static final long MILLISECONDS_PER_MINUTE = 60000L;
    private static final long MILLISECONDS_PER_HOUR = 3600000L;
    private static final long MILLISECONDS_PER_DAY = 86400000L;
    private static final long HUNDRED_NANOSECONDS_PER_SECOND = 10000000L;
    private static final long HUNDRED_NANOSECONDS_PER_MINUTE = 600000000L;
    private static final long HUNDRED_NANOSECONDS_PER_HOUR = 36000000000L;
    private static final long HUNDRED_NANOSECONDS_PER_DAY = 864000000000L;
    private static final long EPOCH_CONVERSION_DAYS = 719164L;
    private static final long EPOCH_CONVERSION_MILLISECONDS = 62135769600000L;
    private static final int ZEITENWENDE = 1721424;
    private static final int JGREG = 2299161;
    protected static final long ONE_DAY_BEFORE_HANA_EPOCH_MILLISECONDS = -62135856000000L;
    protected static final long ONE_SECOND_BEFORE_HANA_EPOCH_MILLISECONDS = -62135769601000L;
    protected static final long HUNDRED_NANOSECONDS_BEFORE_HANA_EPOCH_MILLISECONDS = -62135769600001L;
    protected static final int HUNDRED_NANOSECONDS_BEFORE_HANA_EPOCH_NANOSECONDS = 999999900;
    private static final TimeZone TIME_ZONE_UTC = TimeZone.getTimeZone("UTC");
    private static final long MINIMUM_MILLISECONDS;
    private static final int MINIMUM_NANOSECONDS;
    private static final long MAXIMUM_MILLISECONDS;
    private static final int MAXIMUM_NANOSECONDS;
    private static final ThreadLocal<DateFormat> DATE_FORMAT_PREFIX;
    private static final ThreadLocal<DateFormat> DATE_FORMAT_SUFFIX;
    private static final Pattern PATTERN_DATE;
    private static final Pattern PATTERN_TIME;
    private static final Pattern PATTERN_TIMESTAMP;
    private static final Pattern PATTERN_DIGITS;
    protected static final ThreadLocal<Calendar> _staticCal;
    protected final Lock _calLock;
    @GuardedBy(value="_calLock")
    protected final Calendar _cal;
    protected static final TimeZone _staticTZ;
    protected final TimeZone _tz;

    protected AbstractDateTimeConverter(ConnectionSapDB connection, Set<ParameterOption> parameterOptions, ParameterMode parameterMode, DataType dataType, int index, int inputFieldPos, int outputFieldPos, int length, int fraction, String schemaName, String tableName, String columnName, String columnLabel, boolean isEncrypted, ColumnEncryptionKey columnEncryptionKey, boolean isDeterministic) throws SQLException {
        super(connection, parameterOptions, parameterMode, dataType, index, inputFieldPos, outputFieldPos, length, fraction, schemaName, tableName, columnName, columnLabel, isEncrypted, columnEncryptionKey, isDeterministic);
        if (this._timeZonePerObject) {
            this._calLock = new ReentrantLock();
            this._cal = Calendar.getInstance();
            this._tz = TimeZone.getDefault();
        } else {
            this._calLock = null;
            this._cal = null;
            this._tz = null;
        }
    }

    @Override
    public int getColumnDisplaySize() {
        return this.getPrecision();
    }

    protected static long _convertDateToMilliseconds(byte[] buffer, int offset, Calendar calendar) {
        int year = buffer[offset] & 0xFF | buffer[offset + 1] << 8 & 0xFF00;
        byte month = buffer[offset + 2];
        byte day = buffer[offset + 3];
        if ((year & 0x8000) != 0) {
            year &= Short.MAX_VALUE;
        }
        if ((year & 0x4000) != 0) {
            year |= 0x8000;
        }
        calendar.clear();
        calendar.set(year, month, day);
        long ms = calendar.getTimeInMillis();
        return ms;
    }

    protected static long _convertTimeToMilliseconds(byte[] buffer, int offset, Calendar calendar, boolean setCurrentDate) {
        int hour = buffer[offset];
        byte minute = buffer[offset + 1];
        int millisecond = buffer[offset + 2] & 0xFF | buffer[offset + 3] << 8 & 0xFF00;
        if ((hour & 0x80) != 0) {
            hour &= 0x7F;
        }
        calendar.clear();
        if (setCurrentDate) {
            calendar.setTimeInMillis(System.currentTimeMillis());
            calendar.set(14, 0);
        }
        calendar.set(11, hour);
        calendar.set(12, minute);
        calendar.set(13, millisecond / 1000);
        long ms = calendar.getTimeInMillis();
        if (!setCurrentDate) {
            ms = AbstractDateTimeConverter._normalizeTimeMilliseconds(ms);
        }
        return ms;
    }

    protected static long _convertTimestampToMilliseconds(byte[] buffer, int offset, Calendar calendar) {
        int year = buffer[offset] & 0xFF | buffer[offset + 1] << 8 & 0xFF00;
        byte month = buffer[offset + 2];
        byte day = buffer[offset + 3];
        int hour = buffer[offset + 4];
        byte minute = buffer[offset + 5];
        int millisecond = buffer[offset + 6] & 0xFF | buffer[offset + 7] << 8 & 0xFF00;
        if ((year & 0x8000) != 0) {
            year &= Short.MAX_VALUE;
        }
        if ((year & 0x4000) != 0) {
            year |= 0x8000;
        }
        if ((hour & 0x80) != 0) {
            hour &= 0x7F;
        }
        calendar.clear();
        calendar.set(year, month, day, hour, minute, millisecond / 1000);
        calendar.set(14, millisecond % 1000);
        long ms = calendar.getTimeInMillis();
        return ms;
    }

    protected static byte[] _convertMillisecondsToDate(long ms, Calendar calendar) throws SQLException {
        calendar.setTimeInMillis(ms);
        short year = (short)(calendar.get(1) | 0x8000);
        byte month = (byte)calendar.get(2);
        byte day = (byte)calendar.get(5);
        byte[] date = new byte[4];
        ByteUtils.putShort(year, date, 0);
        ByteUtils.putByte(month, date, 2);
        ByteUtils.putByte(day, date, 3);
        return date;
    }

    protected static byte[] _convertMillisecondsToTime(long ms, Calendar calendar) throws SQLException {
        calendar.setTimeInMillis(ms);
        byte hour = (byte)(calendar.get(11) | 0x80);
        byte minute = (byte)calendar.get(12);
        short millisecond = (short)(calendar.get(13) * 1000);
        byte[] time = new byte[4];
        ByteUtils.putByte(hour, time, 0);
        ByteUtils.putByte(minute, time, 1);
        ByteUtils.putShort(millisecond, time, 2);
        return time;
    }

    protected static byte[] _convertMillisecondsToTimestamp(long ms, Calendar calendar) throws SQLException {
        calendar.setTimeInMillis(ms);
        short year = (short)(calendar.get(1) | 0x8000);
        byte month = (byte)calendar.get(2);
        byte day = (byte)calendar.get(5);
        byte hour = (byte)(calendar.get(11) | 0x80);
        byte minute = (byte)calendar.get(12);
        short millisecond = (short)(calendar.get(13) * 1000 + calendar.get(14));
        byte[] timestamp = new byte[8];
        ByteUtils.putShort(year, timestamp, 0);
        ByteUtils.putByte(month, timestamp, 2);
        ByteUtils.putByte(day, timestamp, 3);
        ByteUtils.putByte(hour, timestamp, 4);
        ByteUtils.putByte(minute, timestamp, 5);
        ByteUtils.putShort(millisecond, timestamp, 6);
        return timestamp;
    }

    protected static byte[] _convertStringToDate(String value, Calendar calendar) throws SQLException {
        String v = AbstractDateTimeConverter._normalizeDateString(value);
        try {
            Date date = Date.valueOf(v);
            return AbstractDateTimeConverter._convertMillisecondsToDate(date.getTime(), calendar);
        }
        catch (IllegalArgumentException e) {
            throw AbstractDateTimeConverter._newSetConversionException(value, "java.sql.Date");
        }
    }

    protected static byte[] _convertStringToTime(String value, Calendar calendar) throws SQLException {
        String v = AbstractDateTimeConverter._normalizeTimeString(value);
        try {
            Time time = Time.valueOf(v);
            return AbstractDateTimeConverter._convertMillisecondsToTime(time.getTime(), calendar);
        }
        catch (IllegalArgumentException e) {
            throw AbstractDateTimeConverter._newSetConversionException(value, "java.sql.Time");
        }
    }

    protected static byte[] _convertStringToTimestamp(String value, Calendar calendar) throws SQLException {
        String v = AbstractDateTimeConverter._normalizeTimestampString(value);
        try {
            Timestamp timestamp = Timestamp.valueOf(v);
            return AbstractDateTimeConverter._convertMillisecondsToTimestamp(timestamp.getTime(), calendar);
        }
        catch (IllegalArgumentException e) {
            throw AbstractDateTimeConverter._newSetConversionException(value, "java.sql.Timestamp");
        }
    }

    protected static long _convertDayDateToMilliseconds(int dayDate, Calendar calendar) {
        int dtday = dayDate - 1;
        int[] ymd = AbstractDateTimeConverter._getDateComponents(dtday);
        calendar.clear();
        calendar.set(ymd[0], ymd[1], ymd[2]);
        long ms = calendar.getTimeInMillis();
        return ms;
    }

    protected static long _convertSecondTimeToMilliseconds(int secondTime, Calendar calendar, boolean setCurrentDate) {
        int st = secondTime - 1;
        int second = st % 60;
        int minute = (st /= 60) % 60;
        int hour = st / 60;
        calendar.clear();
        if (setCurrentDate) {
            calendar.setTimeInMillis(System.currentTimeMillis());
            calendar.set(14, 0);
        }
        calendar.set(11, hour);
        calendar.set(12, minute);
        calendar.set(13, second);
        long ms = calendar.getTimeInMillis();
        if (!setCurrentDate) {
            ms = AbstractDateTimeConverter._normalizeTimeMilliseconds(ms);
        }
        return ms;
    }

    protected static long _convertSecondDateToMilliseconds(long secondDate, Calendar calendar) {
        long sd = secondDate - 1L;
        long dtday = sd / 86400L;
        int[] ymd = AbstractDateTimeConverter._getDateComponents(dtday);
        long timevalue = sd - dtday * 86400L;
        int hour = (int)(timevalue / 3600L);
        int minute = (int)((timevalue -= 3600L * (long)hour) / 60L);
        int second = (int)(timevalue -= 60L * (long)minute);
        calendar.clear();
        calendar.set(ymd[0], ymd[1], ymd[2], hour, minute, second);
        long ms = calendar.getTimeInMillis();
        return ms;
    }

    protected static long _convertLongDateToMilliseconds(long longDate, Calendar calendar) {
        long ld = (longDate - 1L) / 10000L * 10000L;
        long dtday = ld / 864000000000L;
        int[] ymd = AbstractDateTimeConverter._getDateComponents(dtday);
        long timevalue = ld - dtday * 864000000000L;
        int hour = (int)(timevalue / 36000000000L);
        int minute = (int)((timevalue -= 36000000000L * (long)hour) / 600000000L);
        int second = (int)((timevalue -= 600000000L * (long)minute) / 10000000L);
        int fraction = (int)(timevalue -= 10000000L * (long)second);
        calendar.clear();
        calendar.set(ymd[0], ymd[1], ymd[2], hour, minute, second);
        calendar.set(14, fraction / 10000);
        long ms = calendar.getTimeInMillis();
        return ms;
    }

    protected static int _convertLongDateToNanoseconds(long longDate) {
        int ns = (int)((longDate - 1L) % 10000000L * 100L);
        return ns;
    }

    protected static int _convertMillisecondsToDayDate(long ms, Calendar cal, TimeZone timeZone) throws SQLException {
        TimeZone tz = cal != null ? cal.getTimeZone() : timeZone;
        int offset = tz.getOffset(ms);
        AbstractDateTimeConverter._checkRange(ms += (long)offset, 0);
        int dayDate = (int)((ms + 62135769600000L) / 86400000L + 1L);
        return dayDate;
    }

    protected static int _convertMillisecondsToSecondTime(long ms, Calendar cal, TimeZone timeZone) throws SQLException {
        TimeZone tz = cal != null ? cal.getTimeZone() : timeZone;
        int offset = tz.getOffset(ms);
        AbstractDateTimeConverter._checkRange(ms += (long)offset, 0);
        long hour = ms / 3600000L % 24L;
        long minute = ms / 60000L % 60L;
        long second = ms / 1000L % 60L;
        int secondTime = (int)(hour * 3600L + minute * 60L + second + 1L);
        if (secondTime < 1) {
            secondTime = (int)((long)secondTime + 86400L);
        } else if ((long)secondTime > 86401L) {
            secondTime = (int)((long)secondTime - 86400L);
        }
        return secondTime;
    }

    protected static long _convertMillisecondsToSecondDate(long ms, Calendar cal, TimeZone timeZone) throws SQLException {
        TimeZone tz = cal != null ? cal.getTimeZone() : timeZone;
        int offset = tz.getOffset(ms);
        AbstractDateTimeConverter._checkRange(ms += (long)offset, 0);
        long secondDate = (ms + 62135769600000L) / 1000L + 1L;
        return secondDate;
    }

    protected static long _convertMillisecondsAndNanosecondsToLongDate(long ms, int ns, Calendar cal, TimeZone timeZone) throws SQLException {
        TimeZone tz = cal != null ? cal.getTimeZone() : timeZone;
        int offset = tz.getOffset(ms);
        int nanos = ns / 100;
        AbstractDateTimeConverter._checkRange(ms += (long)offset, ns);
        long longDate = (ms + 62135769600000L) / 1000L * 10000000L + (long)nanos + 1L;
        return longDate;
    }

    protected static long _normalizeTimeMilliseconds(long ms) {
        long m = ms < 0L ? ms + 86400000L : (ms > 86400000L ? ms - 86400000L : ms);
        return m;
    }

    protected static long _normalizeTimeMilliseconds(long ms, Calendar cal) {
        cal.setTimeInMillis(ms);
        cal.set(1970, 0, 1);
        long m = cal.getTimeInMillis();
        return m;
    }

    protected static int _convertStringToDayDate(String value, TimeZone timeZone) throws SQLException {
        if (value.isEmpty()) {
            return 0;
        }
        String v = AbstractDateTimeConverter._normalizeDateString(value);
        try {
            Date date = Date.valueOf(v);
            return AbstractDateTimeConverter._convertMillisecondsToDayDate(date.getTime(), null, timeZone);
        }
        catch (IllegalArgumentException e) {
            throw AbstractDateTimeConverter._newSetConversionException(value, "java.sql.Date");
        }
    }

    protected static int _convertStringToSecondTime(String value, TimeZone timeZone) throws SQLException {
        if (value.isEmpty()) {
            return 0;
        }
        String v = AbstractDateTimeConverter._normalizeTimeString(value);
        try {
            Time time = Time.valueOf(v);
            return AbstractDateTimeConverter._convertMillisecondsToSecondTime(time.getTime(), null, timeZone);
        }
        catch (IllegalArgumentException e) {
            throw AbstractDateTimeConverter._newSetConversionException(value, "java.sql.Time");
        }
    }

    protected static long _convertStringToSecondDate(String value, TimeZone timeZone) throws SQLException {
        if (value.isEmpty()) {
            return 0L;
        }
        String v = AbstractDateTimeConverter._normalizeTimestampString(value);
        try {
            Timestamp timestamp = Timestamp.valueOf(v);
            return AbstractDateTimeConverter._convertMillisecondsToSecondDate(timestamp.getTime(), null, timeZone);
        }
        catch (IllegalArgumentException e) {
            throw AbstractDateTimeConverter._newSetConversionException(value, "java.sql.Timestamp");
        }
    }

    protected static long _convertStringToLongDate(String value, TimeZone timeZone) throws SQLException {
        if (value.isEmpty()) {
            return 0L;
        }
        String v = AbstractDateTimeConverter._normalizeTimestampString(value);
        try {
            Timestamp timestamp = Timestamp.valueOf(v);
            return AbstractDateTimeConverter._convertMillisecondsAndNanosecondsToLongDate(timestamp.getTime(), timestamp.getNanos(), null, timeZone);
        }
        catch (IllegalArgumentException e) {
            throw AbstractDateTimeConverter._newSetConversionException(value, "java.sql.Timestamp");
        }
    }

    protected static String _formatTimestamp(Timestamp value, boolean includeNanos) {
        if (value == null) {
            return null;
        }
        String s = value.toString();
        int idx = s.indexOf(".");
        if (idx == -1) {
            return s;
        }
        return includeNanos ? s.substring(0, idx) + String.format(".%09d", value.getNanos()) : s.substring(0, idx);
    }

    protected TimeZone _getTimeZone() {
        return this._timeZonePerObject ? this._tz : _staticTZ;
    }

    private static int[] _getDateComponents(long dtday) {
        long ja;
        long julian = dtday + 1721424L;
        if (julian >= 2299161L) {
            long jalpha = (int)(((double)(julian - 1867216L) - 0.25) / 36524.25);
            ja = julian + 1L + jalpha - (long)((int)(0.25 * (double)jalpha));
        } else {
            ja = julian;
        }
        long jb = ja + 1524L;
        long jc = (int)(6680.0 + ((double)(jb - 2439870L) - 122.1) / 365.25);
        long jd = (int)((double)(365L * jc) + 0.25 * (double)jc);
        long je = (int)((double)(jb - jd) / 30.6001);
        int day = (int)(jb - jd - (long)((int)(30.6001 * (double)je)));
        int month = (int)(je - 1L);
        if (month > 12) {
            month -= 12;
        }
        int year = (int)(jc - 4715L);
        if (month > 2) {
            --year;
        }
        if (year <= 0) {
            // empty if block
        }
        return new int[]{--year, month - 1, day};
    }

    private static void _checkRange(long ms, int ns) throws SQLException {
        if (ms < MINIMUM_MILLISECONDS || ms == MINIMUM_MILLISECONDS && ns < MINIMUM_NANOSECONDS || ms > MAXIMUM_MILLISECONDS || ms == MAXIMUM_MILLISECONDS && ns > MAXIMUM_NANOSECONDS) {
            throw AbstractDateTimeConverter._newSetDateTimeValueOutOfRangeException(AbstractDateTimeConverter._formatAsUTCWithNanos(ms, ns), AbstractDateTimeConverter._formatAsUTCWithNanos(MINIMUM_MILLISECONDS, MINIMUM_NANOSECONDS), AbstractDateTimeConverter._formatAsUTCWithNanos(MAXIMUM_MILLISECONDS, MAXIMUM_NANOSECONDS));
        }
    }

    private static String _formatAsUTCWithNanos(long ms, int ns) {
        Timestamp timestamp = new Timestamp(ms);
        timestamp.setNanos(ns);
        return DATE_FORMAT_PREFIX.get().format(timestamp) + String.format("%09d", timestamp.getNanos()) + DATE_FORMAT_SUFFIX.get().format(timestamp);
    }

    private static String _normalizeDateString(String value) throws SQLException {
        String v;
        block6: {
            block7: {
                block5: {
                    v = value.trim();
                    Matcher m = PATTERN_DATE.matcher(v);
                    if (!m.matches()) break block5;
                    v = AbstractDateTimeConverter._zeroPad(m.group(1), 4) + "-" + AbstractDateTimeConverter._zeroPad(m.group(2), 2) + "-" + AbstractDateTimeConverter._zeroPad(m.group(3), 2, "1");
                    break block6;
                }
                if (!PATTERN_DIGITS.matcher(v).matches()) break block7;
                switch (v.length()) {
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: {
                        v = AbstractDateTimeConverter._zeroPad(v, 4) + "-01-01";
                        break block6;
                    }
                    case 6: {
                        v = v.substring(0, 4) + "-" + v.substring(4, 6) + "-01";
                        break block6;
                    }
                    case 8: {
                        v = v.substring(0, 4) + "-" + v.substring(4, 6) + "-" + v.substring(6, 8);
                        break block6;
                    }
                    default: {
                        throw AbstractDateTimeConverter._newSetConversionException(value, "java.sql.Date");
                    }
                }
            }
            v = value;
        }
        return v;
    }

    private static String _normalizeTimeString(String value) throws SQLException {
        String v;
        block6: {
            block7: {
                block5: {
                    v = value.trim();
                    Matcher m = PATTERN_TIME.matcher(v);
                    if (!m.matches()) break block5;
                    v = AbstractDateTimeConverter._zeroPad(m.group(1), 2) + ":" + AbstractDateTimeConverter._zeroPad(m.group(2), 2) + ":" + AbstractDateTimeConverter._zeroPad(m.group(3), 2);
                    break block6;
                }
                if (!PATTERN_DIGITS.matcher(v).matches()) break block7;
                switch (v.length()) {
                    case 1: 
                    case 2: {
                        v = AbstractDateTimeConverter._zeroPad(v, 2) + ":00:00";
                        break block6;
                    }
                    case 4: {
                        v = v.substring(0, 2) + ":" + v.substring(2, 4) + ":00";
                        break block6;
                    }
                    case 6: {
                        v = v.substring(0, 2) + ":" + v.substring(2, 4) + ":" + v.substring(4, 6);
                        break block6;
                    }
                    default: {
                        throw AbstractDateTimeConverter._newSetConversionException(value, "java.sql.Time");
                    }
                }
            }
            v = value;
        }
        return v;
    }

    private static String _normalizeTimestampString(String value) throws SQLException {
        String v;
        block9: {
            block11: {
                block10: {
                    Matcher m;
                    block8: {
                        v = value.trim();
                        m = PATTERN_TIMESTAMP.matcher(v);
                        if (!m.matches()) break block8;
                        v = AbstractDateTimeConverter._zeroPad(m.group(1), 4) + "-" + AbstractDateTimeConverter._zeroPad(m.group(2), 2) + "-" + AbstractDateTimeConverter._zeroPad(m.group(3), 2) + " " + AbstractDateTimeConverter._zeroPad(m.group(4), 2) + ":" + AbstractDateTimeConverter._zeroPad(m.group(5), 2) + ":" + AbstractDateTimeConverter._zeroPad(m.group(6), 2) + "." + AbstractDateTimeConverter._rightZeroPadOrTruncate(m.group(7), 9);
                        break block9;
                    }
                    m = PATTERN_DATE.matcher(v);
                    if (!m.matches()) break block10;
                    v = AbstractDateTimeConverter._zeroPad(m.group(1), 4) + "-" + AbstractDateTimeConverter._zeroPad(m.group(2), 2) + "-" + AbstractDateTimeConverter._zeroPad(m.group(3), 2, "1") + " 00:00:00";
                    break block9;
                }
                if (!PATTERN_DIGITS.matcher(v).matches()) break block11;
                switch (v.length()) {
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: {
                        v = AbstractDateTimeConverter._zeroPad(v, 4) + "-01-01 00:00:00";
                        break block9;
                    }
                    case 6: {
                        v = v.substring(0, 4) + "-" + v.substring(4, 6) + "-01 00:00:00";
                        break block9;
                    }
                    case 8: {
                        v = v.substring(0, 4) + "-" + v.substring(4, 6) + "-" + v.substring(6, 8) + " 00:00:00";
                        break block9;
                    }
                    case 10: {
                        v = v.substring(0, 4) + "-" + v.substring(4, 6) + "-" + v.substring(6, 8) + " " + v.substring(8, 10) + ":00:00";
                        break block9;
                    }
                    case 12: {
                        v = v.substring(0, 4) + "-" + v.substring(4, 6) + "-" + v.substring(6, 8) + " " + v.substring(8, 10) + ":" + v.substring(10, 12) + ":00";
                        break block9;
                    }
                    case 14: {
                        v = v.substring(0, 4) + "-" + v.substring(4, 6) + "-" + v.substring(6, 8) + " " + v.substring(8, 10) + ":" + v.substring(10, 12) + ":" + v.substring(12, 14);
                        break block9;
                    }
                    default: {
                        throw AbstractDateTimeConverter._newSetConversionException(value, "java.sql.Timestamp");
                    }
                }
            }
            v = value;
        }
        return v;
    }

    private static String _zeroPad(String value, int requiredLength) {
        return AbstractDateTimeConverter._zeroPad(value, requiredLength, "");
    }

    private static String _zeroPad(String value, int requiredLength, String defaultValue) {
        return String.format("%" + requiredLength + "s", value != null ? value : defaultValue).replace(' ', '0');
    }

    private static String _rightZeroPadOrTruncate(String value, int requiredLength) {
        String v = value != null ? value : "";
        int len = v.length();
        if (len < requiredLength) {
            return String.format("%-" + requiredLength + "s", value != null ? value : "").replace(' ', '0');
        }
        if (len > requiredLength) {
            return v.substring(0, requiredLength);
        }
        return v;
    }

    static {
        Calendar calendar = Calendar.getInstance(TIME_ZONE_UTC);
        calendar.clear();
        calendar.set(0, 1);
        calendar.set(1, 1);
        calendar.set(2, 0);
        calendar.set(5, 1);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        MINIMUM_MILLISECONDS = calendar.getTime().getTime();
        MINIMUM_NANOSECONDS = 0;
        calendar.clear();
        calendar.set(0, 1);
        calendar.set(1, 9999);
        calendar.set(2, 11);
        calendar.set(5, 31);
        calendar.set(11, 23);
        calendar.set(12, 59);
        calendar.set(13, 59);
        calendar.set(14, 999);
        MAXIMUM_MILLISECONDS = calendar.getTime().getTime();
        MAXIMUM_NANOSECONDS = 999999900;
        DATE_FORMAT_PREFIX = ThreadLocal.withInitial(() -> {
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.", Locale.ENGLISH);
            dateFormat.setTimeZone(TIME_ZONE_UTC);
            return dateFormat;
        });
        DATE_FORMAT_SUFFIX = ThreadLocal.withInitial(() -> {
            SimpleDateFormat dateFormat = new SimpleDateFormat(" zzz G", Locale.ENGLISH);
            dateFormat.setTimeZone(TIME_ZONE_UTC);
            return dateFormat;
        });
        PATTERN_DATE = Pattern.compile("(\\d{1,4})(?:-|/|\\.)(\\d{1,2})(?:(?:-|/|\\.)(\\d{1,2})(?: .*)?)?");
        PATTERN_TIME = Pattern.compile("(\\d{1,2})\\:(\\d{1,2})(?:\\:(\\d{1,2})(?:\\.\\d*)?)?");
        PATTERN_TIMESTAMP = Pattern.compile("(\\d{1,4})(?:-|/|\\.)(\\d{1,2})(?:-|/|\\.)(\\d{1,2})(?: +|T)(\\d{1,2})(?:\\:(\\d{1,2})(?:\\:(\\d{1,2})(?:\\.(\\d*))?)?)?(?:Z|(?:[+-](?:\\d{2}:\\d{2}|\\d{4}|\\d{2})))?");
        PATTERN_DIGITS = Pattern.compile("\\d+");
        _staticCal = ThreadLocal.withInitial(Calendar::getInstance);
        _staticTZ = TimeZone.getDefault();
    }
}

