/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.util;

import com.sap.db.annotations.NotThreadSafe;
import com.sap.db.jdbc.ColumnEncryptionKey;
import com.sap.db.jdbc.exceptions.SQLExceptionSapDB;
import com.sap.db.util.ARIACBCImpl;
import com.sap.db.util.ARIAKey;
import com.sap.db.util.CSEBlockCipher;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.InvalidParameterSpecException;
import java.sql.SQLException;
import javax.crypto.BadPaddingException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;

@NotThreadSafe
public final class AriaCbc
extends CSEBlockCipher {
    public static final String JAVA_ALGORITHM_NAME = "ARIA";
    public static final String HANA_ALGORITHM_NAME = "ARIA-256-CBC";
    public static final String TRANSFORMATION_NAME = "ARIA/CBC/PKCS7Padding";
    private final SecureRandom _byteGenerator = SecureRandom.getInstance("SHA1PRNG");
    private final ARIACBCImpl _cipher;

    public AriaCbc(int keySizeInBits) throws NoSuchAlgorithmException, InvalidKeyException {
        if (!ARIACBCImpl.KeySize.isValidKeySizeInBits(keySizeInBits)) {
            throw new NoSuchAlgorithmException(String.format("Invalid key size specified: %d", keySizeInBits));
        }
        try {
            this._cipher = new ARIACBCImpl(ARIACBCImpl.KeySize.getKeySize(keySizeInBits));
        }
        catch (InvalidKeyException e) {
            throw new NoSuchAlgorithmException(String.format("Key size specified was invalid: %d", keySizeInBits));
        }
    }

    @Override
    public Key generateKey() throws SQLException {
        try {
            byte[] randomBytes = new byte[this._cipher.getKeySize().getKeySizeInBytes()];
            this._byteGenerator.nextBytes(randomBytes);
            return new ARIAKey(randomBytes);
        }
        catch (InvalidKeyException e) {
            throw SQLExceptionSapDB.newInstance("error.keygeneration.failed", e.getMessage());
        }
    }

    @Override
    public Key getKey(byte[] keyBytes, String algorithmName) throws SQLException {
        try {
            return new ARIAKey(keyBytes);
        }
        catch (InvalidKeyException ex) {
            throw SQLExceptionSapDB.newInstance("error.cse.invalidblockcipherkey", HANA_ALGORITHM_NAME);
        }
    }

    @Override
    public IvParameterSpec getRandomIv() throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidParameterSpecException {
        byte[] randomBytes = new byte[16];
        this._byteGenerator.nextBytes(randomBytes);
        return new IvParameterSpec(randomBytes, 0, randomBytes.length);
    }

    @Override
    public byte[] encrypt(Key publicKey, byte[] input, IvParameterSpec ivParameterSpec) throws SQLException {
        byte[] output;
        try {
            this._cipher.setKey(publicKey);
            this._cipher.setIV(ivParameterSpec);
            this._cipher.prependIV(false);
            output = this._cipher.encrypt(input);
        }
        catch (InvalidKeyException e) {
            throw SQLExceptionSapDB.newInstance((Throwable)e, "error.crypto.extension.not_installed", e.getMessage());
        }
        catch (InvalidAlgorithmParameterException e) {
            throw SQLExceptionSapDB.newInstance((Throwable)e, "error.encrypt.failed", e.getMessage());
        }
        return output;
    }

    @Override
    public byte[] encrypt(ColumnEncryptionKey cek, boolean isDeterministic, byte[] input) throws SQLException {
        byte[] output;
        try {
            IvParameterSpec ivParameterSpec = isDeterministic ? this.getDeterministicIv(cek.getKey(), input) : this.getRandomIv();
            this._cipher.setKey(cek.getKey());
            this._cipher.setIV(ivParameterSpec);
            this._cipher.prependIV(true);
            output = this._cipher.encrypt(input);
        }
        catch (InvalidKeyException e) {
            throw SQLExceptionSapDB.newInstance((Throwable)e, "error.crypto.extension.not_installed", e.getMessage());
        }
        catch (InvalidAlgorithmParameterException | NoSuchAlgorithmException | InvalidParameterSpecException | NoSuchPaddingException e) {
            throw SQLExceptionSapDB.newInstance((Throwable)e, "error.encrypt.failed", e.getMessage());
        }
        return output;
    }

    @Override
    public byte[] decrypt(ColumnEncryptionKey cek, byte[] packet, int offset, int length) throws SQLException {
        byte[] output;
        try {
            IvParameterSpec ivParameterSpec = new IvParameterSpec(packet, offset, 16);
            this._cipher.setKey(cek.getKey());
            this._cipher.setIV(ivParameterSpec);
            this._cipher.prependIV(false);
            output = this._cipher.decrypt(packet, offset + ivParameterSpec.getIV().length, length - ivParameterSpec.getIV().length);
        }
        catch (InvalidKeyException e) {
            throw SQLExceptionSapDB.newInstance((Throwable)e, "error.crypto.extension.not_installed", e.getMessage());
        }
        catch (InvalidAlgorithmParameterException | BadPaddingException e) {
            throw SQLExceptionSapDB.newInstance((Throwable)e, "error.decrypt.failed", e.getMessage());
        }
        return output;
    }

    @Override
    public String getJavaAlgorithmName(String algorithmName) {
        if (algorithmName.equalsIgnoreCase(HANA_ALGORITHM_NAME)) {
            return JAVA_ALGORITHM_NAME;
        }
        return "UNKNOWN";
    }

    @Override
    public String getTransformationName(String algorithmName) {
        if (algorithmName.equalsIgnoreCase(HANA_ALGORITHM_NAME)) {
            return TRANSFORMATION_NAME;
        }
        return "UNKNOWN";
    }
}

