/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.jdbc.packet;

import com.sap.db.annotations.Immutable;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.Set;

@Immutable
public enum PartAttribute {
    LastPacket(1),
    NextPacket(2),
    FirstPacket(4),
    RowNotFound(8),
    ResultSetClosed(16);

    private static final PartAttribute[] VALUES;
    private final int _value;

    public static Set<PartAttribute> decode(int value) {
        EnumSet<PartAttribute> partAttributes = EnumSet.noneOf(PartAttribute.class);
        for (PartAttribute partAttribute : VALUES) {
            if ((value & partAttribute.getValue()) == 0) continue;
            partAttributes.add(partAttribute);
        }
        return partAttributes;
    }

    public static String getDisplayString(int value) {
        Set<PartAttribute> partAttributes = PartAttribute.decode(value);
        return value + (partAttributes.isEmpty() ? "(none)" : Arrays.toString(partAttributes.toArray()));
    }

    private PartAttribute(int value) {
        if (Integer.numberOfTrailingZeros(value) != this.ordinal()) {
            throw new AssertionError((Object)("Value/ordinal mismatch: value = " + value + "; ordinal = " + this.ordinal()));
        }
        this._value = value;
    }

    public int getValue() {
        return this._value;
    }

    static {
        VALUES = PartAttribute.values();
    }
}

