/*
 * Decompiled with CFR 0.152.
 */
package com.google.gson.internal.bind;

import com.google.common.annotations.Beta;
import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.internal.;
import com.google.gson.internal.ConstructorConstructor;
import com.google.gson.internal.JsonReaderInternalAccess;
import com.google.gson.internal.ObjectConstructor;
import com.google.gson.internal.bind.TypeAdapterRuntimeTypeWrapper;
import com.google.gson.internal.bind.TypeAdapters;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import io.vavr.Tuple;
import io.vavr.Tuple2;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@Beta
public final class CustomMapTypeAdapterFactory
implements TypeAdapterFactory {
    private final ConstructorConstructor constructorConstructor = new ConstructorConstructor(Collections.emptyMap());
    private final Map<JsonToken, Tuple2<Predicate<Object>, TypeAdapter<?>>> customAdapters = new LinkedHashMap();

    public void registerAdapter(@Nonnull JsonToken type, @Nonnull Predicate<Object> ableToWrite, @Nonnull TypeAdapter<?> adapter) {
        this.customAdapters.put(type, Tuple.of(ableToWrite, adapter));
    }

    @Nullable
    public <T> TypeAdapter<T> create(@Nonnull Gson gson, @Nonnull TypeToken<T> typeToken) {
        Type type = typeToken.getType();
        if (!Map.class.isAssignableFrom(typeToken.getRawType())) {
            return null;
        }
        Type[] keyAndValueTypes = .Gson.Types.getMapKeyAndValueTypes((Type)type, (Class).Gson.Types.getRawType((Type)type));
        Type keyType = keyAndValueTypes[0];
        Type valueType = keyAndValueTypes[1];
        return new Adapter(gson, keyType, this.getKeyTypeAdapter(gson, keyType), valueType, this.getValueTypeAdapter(gson, valueType), this.constructorConstructor.get(typeToken));
    }

    private TypeAdapter<?> getValueTypeAdapter(@Nonnull Gson gson, @Nonnull Type valueType) {
        final TypeAdapter valueAdapter = gson.getAdapter(TypeToken.get((Type)valueType));
        return new TypeAdapter<Object>(){

            public void write(@Nonnull JsonWriter out, @Nullable Object value) throws IOException {
                for (Tuple2 adapterEntry : CustomMapTypeAdapterFactory.this.customAdapters.values()) {
                    if (!((Predicate)adapterEntry._1()).test(value)) continue;
                    ((TypeAdapter)adapterEntry._2()).write(out, value);
                    return;
                }
                valueAdapter.write(out, value);
            }

            @Nullable
            public Object read(@Nonnull JsonReader in) throws IOException {
                Tuple2 adapterEntry = (Tuple2)CustomMapTypeAdapterFactory.this.customAdapters.get(in.peek());
                if (adapterEntry != null) {
                    return ((TypeAdapter)adapterEntry._2()).read(in);
                }
                return valueAdapter.read(in);
            }
        };
    }

    private TypeAdapter<?> getKeyTypeAdapter(@Nonnull Gson gson, @Nonnull Type keyType) {
        return keyType == Boolean.TYPE || keyType == Boolean.class ? TypeAdapters.BOOLEAN_AS_STRING : gson.getAdapter(TypeToken.get((Type)keyType));
    }

    private static final class Adapter<K, V>
    extends TypeAdapter<Map<K, V>> {
        private final TypeAdapter<K> keyTypeAdapter;
        private final TypeAdapter<V> valueTypeAdapter;
        private final ObjectConstructor<? extends Map<K, V>> constructor;

        private Adapter(@Nonnull Gson context, @Nullable Type keyType, @Nonnull TypeAdapter<K> keyTypeAdapter, @Nullable Type valueType, @Nonnull TypeAdapter<V> valueTypeAdapter, @Nonnull ObjectConstructor<? extends Map<K, V>> constructor) {
            this.keyTypeAdapter = new TypeAdapterRuntimeTypeWrapper(context, keyTypeAdapter, keyType);
            this.valueTypeAdapter = new TypeAdapterRuntimeTypeWrapper(context, valueTypeAdapter, valueType);
            this.constructor = constructor;
        }

        @Nullable
        public Map<K, V> read(@Nonnull JsonReader in) throws IOException {
            JsonToken peek = in.peek();
            if (peek == JsonToken.NULL) {
                in.nextNull();
                return null;
            }
            Map map = (Map)this.constructor.construct();
            if (peek == JsonToken.BEGIN_ARRAY) {
                in.beginArray();
                while (in.hasNext()) {
                    in.beginArray();
                    Object key = this.keyTypeAdapter.read(in);
                    Object value = this.valueTypeAdapter.read(in);
                    Object replaced = map.put(key, value);
                    if (replaced != null) {
                        throw new JsonSyntaxException("duplicate key: " + key);
                    }
                    in.endArray();
                }
                in.endArray();
            } else {
                in.beginObject();
                while (in.hasNext()) {
                    Object value;
                    JsonReaderInternalAccess.INSTANCE.promoteNameToValue(in);
                    Object key = this.keyTypeAdapter.read(in);
                    Object replaced = map.put(key, value = this.valueTypeAdapter.read(in));
                    if (replaced == null) continue;
                    throw new JsonSyntaxException("duplicate key: " + key);
                }
                in.endObject();
            }
            return map;
        }

        public void write(@Nonnull JsonWriter out, @Nullable Map<K, V> map) throws IOException {
            if (map == null) {
                out.nullValue();
                return;
            }
            out.beginObject();
            for (Map.Entry<K, V> entry : map.entrySet()) {
                out.name(String.valueOf(entry.getKey()));
                this.valueTypeAdapter.write(out, entry.getValue());
            }
            out.endObject();
        }
    }
}

