/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.datamodel.odata.client;

import com.google.common.annotations.Beta;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.sap.cloud.sdk.datamodel.odata.client.JsonLookup;
import com.sap.cloud.sdk.datamodel.odata.client.JsonPath;
import com.sap.cloud.sdk.datamodel.odata.client.ODataProtocol;
import io.vavr.control.Option;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Beta
public class ODataResponseDeserializer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ODataResponseDeserializer.class);
    @Nonnull
    private final ODataProtocol protocol;

    public void positionReaderToResultSet(@Nonnull JsonReader reader) throws IOException {
        List<String> nodes = this.protocol.getPathToResultSet().getPaths().get(0).getNodes();
        reader.beginObject();
        for (int i = 0; i < nodes.size(); ++i) {
            while (reader.peek() == JsonToken.NAME && !nodes.get(i).equals(reader.nextName())) {
                JsonParser.parseReader((JsonReader)reader);
            }
            if (i >= nodes.size() - 1) continue;
            reader.beginObject();
        }
        reader.beginArray();
    }

    @Nonnull
    public Option<JsonArray> getElementToResultSet(@Nonnull JsonElement element) {
        JsonElement resultElement = this.getResultJsonElement(element, this.protocol.getPathToResultSet());
        return Option.of((Object)resultElement).filter(JsonElement::isJsonArray).map(JsonElement::getAsJsonArray);
    }

    @Nonnull
    public Option<JsonObject> getElementToResultSingle(@Nonnull JsonElement element) {
        JsonElement resultElement = this.getResultJsonElement(element, this.protocol.getPathToResultSingle());
        return Option.of((Object)resultElement).filter(JsonElement::isJsonObject).map(JsonElement::getAsJsonObject);
    }

    @Nonnull
    public Option<JsonArray> getElementToResultPrimitiveSet(@Nonnull JsonElement element) {
        JsonElement resultElement = this.getResultJsonElement(element, this.protocol.getPathToResultPrimitive());
        return Option.of((Object)resultElement).filter(JsonElement::isJsonArray).map(JsonElement::getAsJsonArray);
    }

    @Nonnull
    public Option<JsonPrimitive> getElementToResultPrimitiveSingle(@Nonnull JsonElement element) {
        JsonElement resultElement = this.getResultJsonElement(element, this.protocol.getPathToResultPrimitive());
        return Option.of((Object)resultElement).filter(JsonElement::isJsonPrimitive).map(JsonElement::getAsJsonPrimitive);
    }

    @Nullable
    private JsonElement getResultJsonElement(@Nonnull JsonElement element, @Nonnull JsonLookup lookup) {
        for (JsonPath path : lookup.getPaths()) {
            JsonElement result = this.getResultJsonElement(element, path);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    @Nullable
    private JsonElement getResultJsonElement(@Nonnull JsonElement element, @Nonnull JsonPath path) {
        List<String> nodes = path.getNodes();
        JsonElement resultElement = element;
        for (int i = 0; i < nodes.size(); ++i) {
            if (resultElement == null || !resultElement.isJsonObject()) {
                log.warn("JSON path {} could not be resolved for {} at position {}.", new Object[]{path, resultElement, i});
                return null;
            }
            if (nodes.get(i).equals("*")) {
                if (!resultElement.getAsJsonObject().entrySet().isEmpty()) {
                    resultElement = (JsonElement)((Map.Entry)resultElement.getAsJsonObject().entrySet().iterator().next()).getValue();
                    continue;
                }
                log.warn("Wildcard in JSON path {}  did not match anything for {}.", (Object)path, (Object)resultElement);
                return null;
            }
            resultElement = resultElement.getAsJsonObject().get(nodes.get(i));
        }
        return resultElement;
    }

    @Generated
    public ODataResponseDeserializer(@Nonnull ODataProtocol protocol) {
        if (protocol == null) {
            throw new NullPointerException("protocol is marked non-null but is null");
        }
        this.protocol = protocol;
    }
}

