/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.datamodel.odata.client.query;

import com.google.common.annotations.Beta;
import com.google.common.base.Strings;
import com.sap.cloud.sdk.datamodel.odata.client.ODataProtocol;
import com.sap.cloud.sdk.datamodel.odata.client.expression.OrderExpression;
import com.sap.cloud.sdk.datamodel.odata.client.expression.ValueBoolean;
import com.sap.cloud.sdk.datamodel.odata.client.query.Order;
import com.sap.cloud.sdk.datamodel.odata.client.query.QuerySerializable;
import com.sap.cloud.sdk.datamodel.odata.client.query.QuerySerializer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.Generated;

@Beta
public final class StructuredQuery
implements QuerySerializable {
    @Nonnull
    private final String entityOrPropertyName;
    private final boolean isRoot;
    private final ODataProtocol protocol;
    @Nonnull
    private final Collection<String> simpleSelectors = new LinkedHashSet<String>();
    @Nonnull
    private final Collection<StructuredQuery> complexSelectors = new LinkedHashSet<StructuredQuery>();
    @Nonnull
    private final Collection<ValueBoolean> filters = new ArrayList<ValueBoolean>();
    @Nonnull
    private final Map<String, String> customParameters = new HashMap<String, String>();
    @Nullable
    private OrderExpression orderBy = null;
    @Nullable
    Number top;
    @Nullable
    Number skip;
    @Nullable
    String search;

    @Nonnull
    public static StructuredQuery onEntity(@Nonnull String entityName, @Nonnull ODataProtocol protocol) {
        return new StructuredQuery(entityName, true, protocol);
    }

    @Nonnull
    public static StructuredQuery asNestedQueryOnProperty(@Nonnull String fieldName, @Nonnull ODataProtocol protocol) {
        return new StructuredQuery(fieldName, false, protocol);
    }

    @Nonnull
    public StructuredQuery select(String ... fields) {
        this.simpleSelectors.addAll(Arrays.asList(fields));
        return this;
    }

    @Nonnull
    public StructuredQuery select(StructuredQuery ... subqueries) {
        List<StructuredQuery> queries = Arrays.asList(subqueries);
        List fields = queries.stream().map(StructuredQuery::getEntityOrPropertyName).collect(Collectors.toList());
        this.complexSelectors.removeIf(selector -> fields.contains(selector.getEntityOrPropertyName()));
        this.complexSelectors.addAll(queries);
        return this;
    }

    @Nonnull
    public StructuredQuery filter(ValueBoolean ... filters) {
        this.filters.addAll(Arrays.asList(filters));
        return this;
    }

    @Nonnull
    public StructuredQuery top(@Nonnull Number top) {
        this.top = top;
        return this;
    }

    @Nonnull
    public StructuredQuery skip(@Nonnull Number skip) {
        this.skip = skip;
        return this;
    }

    @Nonnull
    public StructuredQuery orderBy(@Nonnull String field, @Nonnull Order order) {
        if (this.orderBy == null) {
            this.orderBy = OrderExpression.of(field, order);
        } else {
            this.orderBy.and(field, order);
        }
        return this;
    }

    @Nonnull
    public StructuredQuery orderBy(@Nonnull OrderExpression ordering) {
        this.orderBy = ordering;
        return this;
    }

    @Nonnull
    public StructuredQuery search(@Nonnull String search) {
        this.search = search;
        return this;
    }

    @Nonnull
    public StructuredQuery withCustomParameter(@Nonnull String key, @Nullable String value) {
        if (Strings.isNullOrEmpty((String)key)) {
            throw new IllegalArgumentException("Custom parameter key must not be null or empty.");
        }
        if (!this.isRoot()) {
            throw new IllegalStateException("Custom query parameters can only be added to the HTTP query but not to nested OData queries on navigation properties.");
        }
        this.customParameters.put(key, value);
        return this;
    }

    @Nonnull
    public StructuredQuery withInlineCount() {
        Map.Entry<String, String> queryOption = this.getProtocol().getQueryOptionInlineCount(true);
        this.customParameters.put(queryOption.getKey(), queryOption.getValue());
        return this;
    }

    @Override
    @Nonnull
    public String getEncodedQueryString() {
        return QuerySerializer.serializeAndEncodeQuery(this, true);
    }

    @Override
    @Nonnull
    public String getQueryString() {
        return QuerySerializer.serializeAndEncodeQuery(this, false);
    }

    @Generated
    private StructuredQuery(@Nonnull String entityOrPropertyName, boolean isRoot, ODataProtocol protocol) {
        if (entityOrPropertyName == null) {
            throw new NullPointerException("entityOrPropertyName is marked non-null but is null");
        }
        this.entityOrPropertyName = entityOrPropertyName;
        this.isRoot = isRoot;
        this.protocol = protocol;
    }

    @Nonnull
    @Generated
    public String getEntityOrPropertyName() {
        return this.entityOrPropertyName;
    }

    @Generated
    public boolean isRoot() {
        return this.isRoot;
    }

    @Generated
    public ODataProtocol getProtocol() {
        return this.protocol;
    }

    @Nonnull
    @Generated
    public Collection<String> getSimpleSelectors() {
        return this.simpleSelectors;
    }

    @Nonnull
    @Generated
    public Collection<StructuredQuery> getComplexSelectors() {
        return this.complexSelectors;
    }

    @Nonnull
    @Generated
    public Collection<ValueBoolean> getFilters() {
        return this.filters;
    }

    @Nonnull
    @Generated
    public Map<String, String> getCustomParameters() {
        return this.customParameters;
    }

    @Nullable
    @Generated
    public OrderExpression getOrderBy() {
        return this.orderBy;
    }

    @Nullable
    @Generated
    public Number getTop() {
        return this.top;
    }

    @Nullable
    @Generated
    public Number getSkip() {
        return this.skip;
    }

    @Nullable
    @Generated
    public String getSearch() {
        return this.search;
    }
}

