/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.datamodel.odata.client.request;

import com.google.common.annotations.Beta;
import com.sap.cloud.sdk.datamodel.odata.client.ODataProtocol;
import com.sap.cloud.sdk.datamodel.odata.client.expression.ODataResourcePath;
import com.sap.cloud.sdk.datamodel.odata.client.request.ODataHttpRequest;
import com.sap.cloud.sdk.datamodel.odata.client.request.ODataRequestGeneric;
import com.sap.cloud.sdk.datamodel.odata.client.request.ODataRequestResultGeneric;
import com.sap.cloud.sdk.datamodel.odata.client.request.ODataUriFactory;
import java.net.URI;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.Generated;
import org.apache.http.client.HttpClient;

@Beta
public class ODataRequestCreate
extends ODataRequestGeneric {
    @Nonnull
    private final String serializedEntity;

    public ODataRequestCreate(@Nonnull String servicePath, @Nonnull String entityName, @Nonnull String serializedEntity, @Nonnull ODataProtocol protocol) {
        this(servicePath, ODataResourcePath.of(entityName), serializedEntity, protocol);
    }

    public ODataRequestCreate(@Nonnull String servicePath, @Nonnull ODataResourcePath entityPath, @Nonnull String serializedEntity, @Nonnull ODataProtocol protocol) {
        super(servicePath, entityPath, protocol);
        this.addHeader("Content-Type", "application/json");
        this.addHeader("Accept", "application/json");
        this.serializedEntity = serializedEntity;
    }

    @Override
    @Nonnull
    public URI getRelativeUri() {
        return ODataUriFactory.createAndEncodeUri(this.getServicePath(), this.getResourcePath(), this.getRequestQuery());
    }

    @Override
    @Nonnull
    public ODataRequestResultGeneric execute(@Nonnull HttpClient httpClient) {
        ODataHttpRequest request = ODataHttpRequest.forBodyJson(this, httpClient, this.serializedEntity);
        return (ODataRequestResultGeneric)this.tryExecuteWithCsrfToken(httpClient, request::requestPost).get();
    }

    @Nonnull
    @Generated
    public String getSerializedEntity() {
        return this.serializedEntity;
    }

    @Override
    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ODataRequestCreate)) {
            return false;
        }
        ODataRequestCreate other = (ODataRequestCreate)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$serializedEntity = this.getSerializedEntity();
        String other$serializedEntity = other.getSerializedEntity();
        return !(this$serializedEntity == null ? other$serializedEntity != null : !this$serializedEntity.equals(other$serializedEntity));
    }

    @Override
    @Generated
    protected boolean canEqual(@Nullable Object other) {
        return other instanceof ODataRequestCreate;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $serializedEntity = this.getSerializedEntity();
        result = result * 59 + ($serializedEntity == null ? 43 : $serializedEntity.hashCode());
        return result;
    }
}

