/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.datamodel.odata.client.request;

import com.google.common.collect.Iterables;
import com.google.common.collect.Streams;
import io.vavr.CheckedFunction0;
import io.vavr.control.Option;
import io.vavr.control.Try;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.HttpVersion;
import org.apache.http.ProtocolVersion;
import org.apache.http.StatusLine;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.message.BasicHttpResponse;
import org.apache.http.message.BasicStatusLine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ODataRequestResultMultipartParser {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ODataRequestResultMultipartParser.class);
    private static final String BATCH_NEW_LINE = "\r\n";
    private static final Pattern PATTERN_BOUNDARY_DELIMITER = Pattern.compile("boundary=([\\w_-]+)");
    @Nonnull
    final String batchContent;
    @Nonnull
    final Iterable<String> contentType;

    @Nullable
    HttpResponse extractHttpResponseForReceiving(int positionInBatchMultipart) {
        String batchDelimiter = this.getDelimiterFromHeader();
        String selectedResponse = ODataRequestResultMultipartParser.getPayloadFromBoundary(this.batchContent, positionInBatchMultipart, batchDelimiter);
        BatchItemPayload payload = this.createBatchItemPayload(selectedResponse);
        return this.createHttpResponse(payload);
    }

    @Nullable
    HttpResponse extractHttpResponseForModifying(int positionInBatchMultipart, int positionInChangeset) {
        String batchDelimiter = this.getDelimiterFromHeader();
        String changeset = ODataRequestResultMultipartParser.getPayloadFromBoundary(this.batchContent, positionInBatchMultipart, batchDelimiter);
        String changesetDelimiter = this.getDelimiterFromChangeset(changeset);
        if (changesetDelimiter == null) {
            return this.extractHttpResponseForReceiving(positionInBatchMultipart);
        }
        String selectedResponse = ODataRequestResultMultipartParser.getPayloadFromBoundary(changeset, positionInChangeset, changesetDelimiter);
        if (selectedResponse == null && positionInChangeset > 0 && this.hasChangesetFailed(changeset, changesetDelimiter)) {
            selectedResponse = ODataRequestResultMultipartParser.getPayloadFromBoundary(changeset, 0, changesetDelimiter);
        }
        BatchItemPayload payload = this.createBatchItemPayload(selectedResponse);
        return this.createHttpResponse(payload);
    }

    private boolean hasChangesetFailed(@Nullable String content, @Nullable String changesetDelimiter) {
        int statusCode;
        Try<BasicStatusLine> firstStatusLine;
        BatchItemPayload firstItem;
        String payloadFromFirstItem;
        boolean changesetHasOnlyOneEntry;
        if (content == null || changesetDelimiter == null) {
            return false;
        }
        boolean bl = changesetHasOnlyOneEntry = StringUtils.countMatches((CharSequence)content, (CharSequence)changesetDelimiter) == 2;
        if (changesetHasOnlyOneEntry && (payloadFromFirstItem = ODataRequestResultMultipartParser.getPayloadFromBoundary(content, 0, changesetDelimiter)) != null && (firstItem = this.createBatchItemPayload(payloadFromFirstItem)) != null && !(firstStatusLine = this.constructStatusLineFromBatchItem(firstItem)).isFailure() && (statusCode = ((BasicStatusLine)firstStatusLine.get()).getStatusCode()) >= 400) {
            log.debug("The requested batch item in changeset of OData batch response could not be found due to a previous error response. That error response will be returned instead.");
            return true;
        }
        return false;
    }

    @Nullable
    private String getDelimiterFromChangeset(@Nullable String changeset) {
        if (changeset == null) {
            return null;
        }
        Matcher matcher = PATTERN_BOUNDARY_DELIMITER.matcher(changeset);
        if (!matcher.find()) {
            log.debug("Payload batch item delimiter for changeset \"{}\" could not be extracted from OData batch response except.", (Object)changeset);
            return null;
        }
        return "--" + matcher.group(1);
    }

    @Nullable
    private String getDelimiterFromHeader() {
        if (!Iterables.contains(this.contentType, (Object)"multipart/mixed")) {
            log.warn("Illegal value in HTTP header \"Content-Type\" of OData batch response.");
        }
        Optional<String> boundary = Streams.stream(this.contentType).map(PATTERN_BOUNDARY_DELIMITER::matcher).filter(Matcher::find).findFirst().map(m -> m.group(1));
        if (!boundary.isPresent()) {
            log.error("A boundary delimiter cannot be resolved from OData batch response header.");
            return null;
        }
        return "--" + boundary.get();
    }

    @Nonnull
    private Try<BasicStatusLine> constructStatusLineFromBatchItem(@Nonnull BatchItemPayload payload) {
        return Try.of((CheckedFunction0 & Serializable)() -> {
            String[] status = payload.getResponseStatus().split(" ", 3);
            Optional<HttpVersion> version = Stream.of(HttpVersion.HTTP_0_9, HttpVersion.HTTP_1_0, HttpVersion.HTTP_1_1).filter(v -> status[0].equalsIgnoreCase(v.toString())).findFirst();
            if (!version.isPresent()) {
                log.error("Unexpected HTTP version found in OData batch response item: {}", (Object)status[0]);
                throw new IllegalStateException("Unexpected HTTP version.");
            }
            int code = Integer.parseInt(status[1]);
            String reason = status[2];
            return new BasicStatusLine((ProtocolVersion)version.get(), code, reason);
        });
    }

    @Nullable
    private BatchItemPayload createBatchItemPayload(@Nullable String responseItem) {
        if (responseItem == null) {
            log.debug("Skipping the payload deserialization because of previous issues.");
            return null;
        }
        String[] splitResponse = responseItem.split("\r\n\r\n", 3);
        if (splitResponse.length < 2) {
            log.error("OData batch response item is malformed.");
            return null;
        }
        List<String> batchItemHeaders = Arrays.asList(splitResponse[0].split(BATCH_NEW_LINE));
        String[] responseHead = splitResponse[1].split(BATCH_NEW_LINE, 2);
        String responseStatus = responseHead[0];
        List<String> responseHeaders = responseHead.length > 1 ? Arrays.asList(responseHead[1].split(BATCH_NEW_LINE)) : Collections.emptyList();
        Option content = splitResponse.length > 2 ? Option.of((Object)splitResponse[2]).filter(StringUtils::isNotBlank) : Option.none();
        return new BatchItemPayload(batchItemHeaders, responseStatus, responseHeaders, (Option<String>)content);
    }

    @Nullable
    private static String getPayloadFromBoundary(@Nullable String content, int position, @Nullable String delimiter) {
        if (delimiter == null || content == null) {
            log.debug("Skipping the payload extraction because of previous issues.");
            return null;
        }
        int p = content.indexOf(delimiter);
        for (int i = 0; i < position + 1; ++i) {
            int newPosition = content.indexOf(delimiter, p + 1);
            if (i == position) {
                if (p < 0 || newPosition < 0) break;
                return content.substring(p + delimiter.length(), newPosition).trim();
            }
            p = newPosition;
        }
        log.error("Payload batch item with delimiter \"{}\" could not be extracted from OData batch response at position {}.", (Object)delimiter, (Object)position);
        return null;
    }

    @Nullable
    private HttpResponse createHttpResponse(@Nullable BatchItemPayload payload) {
        if (payload == null) {
            log.debug("Skipping the HttpResponse generation because of previous issues.");
            return null;
        }
        Try<BasicStatusLine> maybeStatusLine = this.constructStatusLineFromBatchItem(payload);
        StatusLine statusLine = (StatusLine)maybeStatusLine.onFailure(e -> log.error("Failed to construct status line for OData batch response item: {}", (Object)payload.getResponseStatus(), e)).getOrElse(() -> new BasicStatusLine((ProtocolVersion)HttpVersion.HTTP_1_1, 200, "Ok"));
        BasicHttpResponse httpResponse = new BasicHttpResponse(statusLine);
        for (String header : payload.getBatchItemHeaders()) {
            String[] headerParts = header.split(":", 2);
            httpResponse.setHeader(headerParts[0], headerParts[1]);
        }
        payload.getContent().peek(content -> httpResponse.setEntity((HttpEntity)new StringEntity(content, ContentType.APPLICATION_JSON)));
        return httpResponse;
    }

    @Generated
    public ODataRequestResultMultipartParser(@Nonnull String batchContent, @Nonnull Iterable<String> contentType) {
        if (batchContent == null) {
            throw new NullPointerException("batchContent is marked non-null but is null");
        }
        if (contentType == null) {
            throw new NullPointerException("contentType is marked non-null but is null");
        }
        this.batchContent = batchContent;
        this.contentType = contentType;
    }

    private static final class BatchItemPayload {
        @Nonnull
        private final List<String> batchItemHeaders;
        @Nonnull
        private final String responseStatus;
        @Nonnull
        private final List<String> responseHeaders;
        @Nonnull
        private final Option<String> content;

        @Generated
        public BatchItemPayload(@Nonnull List<String> batchItemHeaders, @Nonnull String responseStatus, @Nonnull List<String> responseHeaders, @Nonnull Option<String> content) {
            if (batchItemHeaders == null) {
                throw new NullPointerException("batchItemHeaders is marked non-null but is null");
            }
            if (responseStatus == null) {
                throw new NullPointerException("responseStatus is marked non-null but is null");
            }
            if (responseHeaders == null) {
                throw new NullPointerException("responseHeaders is marked non-null but is null");
            }
            if (content == null) {
                throw new NullPointerException("content is marked non-null but is null");
            }
            this.batchItemHeaders = batchItemHeaders;
            this.responseStatus = responseStatus;
            this.responseHeaders = responseHeaders;
            this.content = content;
        }

        @Nonnull
        @Generated
        public List<String> getBatchItemHeaders() {
            return this.batchItemHeaders;
        }

        @Nonnull
        @Generated
        public String getResponseStatus() {
            return this.responseStatus;
        }

        @Nonnull
        @Generated
        public List<String> getResponseHeaders() {
            return this.responseHeaders;
        }

        @Nonnull
        @Generated
        public Option<String> getContent() {
            return this.content;
        }

        @Generated
        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof BatchItemPayload)) {
                return false;
            }
            BatchItemPayload other = (BatchItemPayload)o;
            List<String> this$batchItemHeaders = this.getBatchItemHeaders();
            List<String> other$batchItemHeaders = other.getBatchItemHeaders();
            if (this$batchItemHeaders == null ? other$batchItemHeaders != null : !((Object)this$batchItemHeaders).equals(other$batchItemHeaders)) {
                return false;
            }
            String this$responseStatus = this.getResponseStatus();
            String other$responseStatus = other.getResponseStatus();
            if (this$responseStatus == null ? other$responseStatus != null : !this$responseStatus.equals(other$responseStatus)) {
                return false;
            }
            List<String> this$responseHeaders = this.getResponseHeaders();
            List<String> other$responseHeaders = other.getResponseHeaders();
            if (this$responseHeaders == null ? other$responseHeaders != null : !((Object)this$responseHeaders).equals(other$responseHeaders)) {
                return false;
            }
            Option<String> this$content = this.getContent();
            Option<String> other$content = other.getContent();
            return !(this$content == null ? other$content != null : !this$content.equals(other$content));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            List<String> $batchItemHeaders = this.getBatchItemHeaders();
            result = result * 59 + ($batchItemHeaders == null ? 43 : ((Object)$batchItemHeaders).hashCode());
            String $responseStatus = this.getResponseStatus();
            result = result * 59 + ($responseStatus == null ? 43 : $responseStatus.hashCode());
            List<String> $responseHeaders = this.getResponseHeaders();
            result = result * 59 + ($responseHeaders == null ? 43 : ((Object)$responseHeaders).hashCode());
            Option<String> $content = this.getContent();
            result = result * 59 + ($content == null ? 43 : $content.hashCode());
            return result;
        }

        @Nonnull
        @Generated
        public String toString() {
            return "ODataRequestResultMultipartParser.BatchItemPayload(batchItemHeaders=" + this.getBatchItemHeaders() + ", responseStatus=" + this.getResponseStatus() + ", responseHeaders=" + this.getResponseHeaders() + ", content=" + this.getContent() + ")";
        }
    }
}

