/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.datamodel.odata.client.request;

import com.google.common.annotations.Beta;
import com.google.common.base.Strings;
import com.google.common.escape.Escaper;
import com.google.common.net.PercentEscaper;
import com.google.common.net.UrlEscapers;
import com.sap.cloud.sdk.datamodel.odata.client.expression.ODataResourcePath;
import io.vavr.control.Option;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Beta
public class ODataUriFactory {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ODataUriFactory.class);
    private static final Predicate<String> VALID_URL_QUERY = Pattern.compile("^[a-zA-Z0-9/?:@\\-._~!$&'()*+,;=%]*$").asPredicate();
    public static final char[] SAFE_CHARS_IN_QUERY = new char[]{'_', '*', '-', ':', ',', '/', '\'', '(', ')', '.', '|'};
    private static final Escaper URL_QUERY_ESCAPER = new PercentEscaper(new String(SAFE_CHARS_IN_QUERY), false);

    @Nonnull
    static URI createAndEncodeUri(@Nonnull String servicePath, @Nonnull ODataResourcePath resourcePath, @Nullable String encodedQuery) {
        String encodedResourcePath = resourcePath.toEncodedPathString();
        return ODataUriFactory.createAndEncodeUri(servicePath, encodedResourcePath, encodedQuery);
    }

    @Nonnull
    static URI createAndEncodeUri(@Nonnull String servicePath, @Nonnull String encodedResourcePath, @Nullable String encodedQuery) {
        String encodedPath = ODataUriFactory.encodePath(servicePath);
        encodedPath = ODataUriFactory.sanitizeUrlPath(encodedPath);
        encodedPath = encodedPath + (encodedResourcePath.startsWith("/") ? encodedResourcePath : "/" + encodedResourcePath);
        Option maybeQueryEncoded = Option.of((Object)encodedQuery).filter(s -> !Strings.isNullOrEmpty((String)s));
        if (maybeQueryEncoded.isDefined() && !maybeQueryEncoded.exists(VALID_URL_QUERY)) {
            throw new IllegalArgumentException("The query part of OData request is not correctly encoded: \"" + encodedQuery + "\"");
        }
        String resultUrl = encodedPath + (String)maybeQueryEncoded.map(q -> "?" + q).getOrElse((Object)"");
        try {
            return new URI(resultUrl);
        }
        catch (URISyntaxException e) {
            log.error("Failed to construct URI for OData request with service path '{}', resource path '{}' and query '{}'.", new Object[]{servicePath, encodedResourcePath, encodedQuery, e});
            throw new IllegalArgumentException("Failed to construct URI.", e);
        }
    }

    @Nonnull
    public static String encodePath(@Nonnull String path) {
        return Arrays.stream(path.split("/")).map(ODataUriFactory::encodePathSegment).collect(Collectors.joining("/"));
    }

    @Nonnull
    public static String encodePathSegment(@Nonnull String path) {
        return UrlEscapers.urlPathSegmentEscaper().escape(path);
    }

    @Nonnull
    public static String encodeQuery(@Nonnull String input) {
        return URL_QUERY_ESCAPER.escape(input);
    }

    @Nonnull
    private static String sanitizeUrlPath(@Nonnull String path) {
        String pathWithPrefixingSlash = "/" + path;
        String pathWithoutDoubleSlashes = pathWithPrefixingSlash.replaceAll("//+", "/");
        return pathWithoutDoubleSlashes.replaceAll("/$", "");
    }
}

