package com.simboss.sdk.request;

import com.google.gson.reflect.TypeToken;
import com.simboss.sdk.constant.CardStatusConstants;
import com.simboss.sdk.constant.UriConstants;
import com.simboss.sdk.dto.ThreeIdCombineDTO;
import com.simboss.sdk.exception.SimbossException;
import com.simboss.sdk.response.SimbossResponse;

import java.lang.reflect.Type;
import java.util.TreeMap;

/**
 * 基础类
 * Created by Abel 2018-06-20.
 **/
public class DeviceModifyDeviceStatusRequest extends ThreeIdCombineDTO implements SimbossRequest {

  @Override
  public String getUri() {
    return UriConstants.URI_DEVICE_MODIFY_DEVICE_STATUS;
  }

  @Override
  public TreeMap<String, String> getParam() {
    TreeMap<String, String> map = super.getParam();
    if (status == null) {
      throw new SimbossException("param status is required");
    }
    map.put("status", status.getVal());
    return map;
  }

  @Override
  public Type getResponseType() {
    return new TypeToken<SimbossResponse>() {}.getType();
  }

  private CardStatusConstants.CarrierStatus status;

  public CardStatusConstants.CarrierStatus getStatus() {
    return status;
  }

  public void setStatus(CardStatusConstants.CarrierStatus status) {
    this.status = status;
  }
}
