/*
 * Decompiled with CFR 0.152.
 */
package com.simboss.sdk.conf;

import com.simboss.sdk.exception.SimbossException;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimbossConfig {
    private Logger logger = LoggerFactory.getLogger(SimbossConfig.class);
    private Integer connectionTimeout;
    private Integer socketTimeout;
    private Integer poolDefaultMaxPerRoute;
    private Integer poolMaxTotal;
    private String apiUrl;
    private String appId;
    private String appSecret;
    private Properties properties;

    public SimbossConfig() {
    }

    public SimbossConfig(String apiUrl, String appId, String appSecret) {
        this.setApiUrl(apiUrl);
        this.setAppId(appId);
        this.setAppSecret(appSecret);
    }

    public SimbossConfig withConf(String filePath) {
        FileInputStream in = null;
        try {
            in = new FileInputStream(filePath);
            Properties properties = new Properties();
            properties.load(in);
        }
        catch (IOException e) {
            throw new SimbossException("load config file error, errMsg:" + e.getMessage(), e);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    this.logger.error(e.getMessage(), (Throwable)e);
                }
            }
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SimbossConfig withConf(InputStream in) {
        Properties properties = null;
        try {
            properties = new Properties();
            properties.load(in);
        }
        catch (IOException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    this.logger.error(e.getMessage(), (Throwable)e);
                }
            }
        }
        this.withConfig(properties);
        return this;
    }

    public SimbossConfig withConfig(Properties properties) {
        this.properties = properties;
        return this;
    }

    public SimbossConfig build() {
        if (this.properties == null) {
            this.logger.info("no custom config, use system detail");
            this.properties = new Properties();
            InputStream in = null;
            try {
                in = SimbossConfig.class.getResourceAsStream("/simboss.properties");
                this.properties.load(in);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException e) {
                        this.logger.error(e.getMessage(), (Throwable)e);
                    }
                }
            }
        }
        if (this.properties == null) {
            return this;
        }
        this.setConnectionTimeout(this.getConfInt(this.properties, "http.connection.timeout", "10000"));
        this.setSocketTimeout(this.getConfInt(this.properties, "http.socket.timeout", "30000"));
        this.setPoolDefaultMaxPerRoute(this.getConfInt(this.properties, "http.pool.defaultMaxPerRoute", "50"));
        this.setPoolMaxTotal(this.getConfInt(this.properties, "http.pool.maxTotal", "50"));
        if (StringUtils.isBlank((String)this.getApiUrl())) {
            this.setApiUrl(this.properties.getProperty("simboss.api.url", "https://api.simboss.com"));
        }
        if (StringUtils.isBlank((String)this.getAppId())) {
            this.setAppId(this.properties.getProperty("simboss.api.appId"));
        }
        if (StringUtils.isBlank((String)this.getAppSecret())) {
            this.setAppSecret(this.properties.getProperty("simboss.api.appSecret"));
        }
        this.properties = null;
        return this;
    }

    private Integer getConfInt(Properties properties, String key, String defVal) {
        String v = properties.getProperty(key, defVal);
        return Integer.parseInt(v);
    }

    public Integer getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public void setConnectionTimeout(Integer connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    public Integer getSocketTimeout() {
        return this.socketTimeout;
    }

    public void setSocketTimeout(Integer socketTimeout) {
        this.socketTimeout = socketTimeout;
    }

    public Integer getPoolDefaultMaxPerRoute() {
        return this.poolDefaultMaxPerRoute;
    }

    public void setPoolDefaultMaxPerRoute(Integer poolDefaultMaxPerRoute) {
        this.poolDefaultMaxPerRoute = poolDefaultMaxPerRoute;
    }

    public Integer getPoolMaxTotal() {
        return this.poolMaxTotal;
    }

    public void setPoolMaxTotal(Integer poolMaxTotal) {
        this.poolMaxTotal = poolMaxTotal;
    }

    public String getApiUrl() {
        return this.apiUrl;
    }

    public void setApiUrl(String apiUrl) {
        this.apiUrl = apiUrl;
    }

    public String getAppId() {
        return this.appId;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public String getAppSecret() {
        return this.appSecret;
    }

    public void setAppSecret(String appSecret) {
        this.appSecret = appSecret;
    }
}

