/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.plugin.dockerfile;

import com.spotify.docker.client.auth.RegistryAuthSupplier;
import com.spotify.docker.client.messages.RegistryAuth;
import com.spotify.docker.client.messages.RegistryConfigs;
import java.util.HashMap;

public class MavenPomAuthSupplier
implements RegistryAuthSupplier {
    private String userName;
    private String password;

    public MavenPomAuthSupplier(String userName, String password) {
        this.userName = userName;
        this.password = password;
    }

    public boolean hasUserName() {
        return this.userName != null && !this.userName.equals("");
    }

    public RegistryAuth authFor(String server) {
        if (this.hasUserName()) {
            return RegistryAuth.builder().username(this.userName).password(this.password).build();
        }
        return null;
    }

    public RegistryAuth authForSwarm() {
        return null;
    }

    public RegistryConfigs authForBuild() {
        HashMap<String, RegistryAuth> allConfigs = new HashMap<String, RegistryAuth>();
        if (this.hasUserName()) {
            allConfigs.put("config", RegistryAuth.builder().username(this.userName).password(this.password).build());
        }
        return RegistryConfigs.create(allConfigs);
    }
}

