/*
 * Decompiled with CFR 0.152.
 */
package com.taosdata.jdbc.utils;

import com.taosdata.jdbc.TSDBConnection;
import com.taosdata.jdbc.TSDBJNIConnector;
import java.sql.Connection;
import java.sql.SQLException;

public class SqlSyntaxValidator {
    private static final String[] updateSQL = new String[]{"insert", "update", "delete", "create", "alter", "drop", "show", "describe", "use"};
    private static final String[] querySQL = new String[]{"select"};
    private TSDBConnection tsdbConnection;

    public SqlSyntaxValidator(Connection connection) {
        this.tsdbConnection = (TSDBConnection)connection;
    }

    public boolean validateSqlSyntax(String sql) throws SQLException {
        boolean res = false;
        if (this.tsdbConnection == null || this.tsdbConnection.isClosed()) {
            throw new SQLException("invalid connection");
        }
        TSDBJNIConnector jniConnector = this.tsdbConnection.getConnection();
        if (jniConnector == null) {
            throw new SQLException("jniConnector is null");
        }
        res = jniConnector.validateCreateTableSql(sql);
        return res;
    }

    public static boolean isValidForExecuteUpdate(String sql) {
        for (String prefix : updateSQL) {
            if (!sql.trim().toLowerCase().startsWith(prefix)) continue;
            return true;
        }
        return false;
    }

    public static boolean isUseSql(String sql) {
        return sql.trim().toLowerCase().startsWith(updateSQL[8]) || sql.trim().toLowerCase().matches("create\\s*database.*") || sql.toLowerCase().toLowerCase().matches("drop\\s*database.*");
    }

    public static boolean isUpdateSql(String sql) {
        return sql.trim().toLowerCase().startsWith(updateSQL[1]);
    }

    public static boolean isInsertSql(String sql) {
        return sql.trim().toLowerCase().startsWith(updateSQL[0]);
    }

    public static boolean isSelectSql(String sql) {
        return sql.trim().toLowerCase().startsWith(querySQL[0]);
    }
}

