/*
 * Decompiled with CFR 0.152.
 */
package com.taosdata.jdbc;

import com.taosdata.jdbc.AbstractResultSet;
import com.taosdata.jdbc.ColumnMetaData;
import com.taosdata.jdbc.TSDBError;
import com.taosdata.jdbc.TSDBResultSetMetaData;
import com.taosdata.jdbc.TSDBResultSetRowData;
import java.math.BigDecimal;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;

public class DatabaseMetaDataResultSet
extends AbstractResultSet {
    private List<ColumnMetaData> columnMetaDataList = new ArrayList<ColumnMetaData>();
    private List<TSDBResultSetRowData> rowDataList = new ArrayList<TSDBResultSetRowData>();
    private TSDBResultSetRowData rowCursor;
    private int cursorRowNumber = 0;

    public void setRowDataList(List<TSDBResultSetRowData> rowDataList) {
        this.rowDataList = rowDataList;
    }

    public void setColumnMetaDataList(List<ColumnMetaData> columnMetaDataList) {
        this.columnMetaDataList = columnMetaDataList;
    }

    @Override
    public boolean next() throws SQLException {
        boolean ret = false;
        if (!this.rowDataList.isEmpty() && this.cursorRowNumber < this.rowDataList.size()) {
            this.rowCursor = this.rowDataList.get(this.cursorRowNumber++);
            ret = true;
        }
        return ret;
    }

    @Override
    public void close() throws SQLException {
    }

    @Override
    public boolean wasNull() throws SQLException {
        return false;
    }

    @Override
    public String getString(int columnIndex) throws SQLException {
        int colType = this.columnMetaDataList.get(columnIndex - 1).getColType();
        return this.rowCursor.getString(columnIndex, colType);
    }

    @Override
    public boolean getBoolean(int columnIndex) throws SQLException {
        int colType = this.columnMetaDataList.get(columnIndex - 1).getColType();
        return this.rowCursor.getBoolean(columnIndex, colType);
    }

    @Override
    public byte getByte(int columnIndex) throws SQLException {
        int colType = this.columnMetaDataList.get(columnIndex - 1).getColType();
        return (byte)this.rowCursor.getInt(columnIndex, colType);
    }

    @Override
    public short getShort(int columnIndex) throws SQLException {
        int colType = this.columnMetaDataList.get(columnIndex - 1).getColType();
        return (short)this.rowCursor.getInt(columnIndex, colType);
    }

    @Override
    public int getInt(int columnIndex) throws SQLException {
        int colType = this.columnMetaDataList.get(columnIndex - 1).getColType();
        return this.rowCursor.getInt(columnIndex, colType);
    }

    @Override
    public long getLong(int columnIndex) throws SQLException {
        int colType = this.columnMetaDataList.get(columnIndex - 1).getColType();
        return this.rowCursor.getLong(columnIndex, colType);
    }

    @Override
    public float getFloat(int columnIndex) throws SQLException {
        int colType = this.columnMetaDataList.get(columnIndex - 1).getColType();
        return this.rowCursor.getFloat(columnIndex, colType);
    }

    @Override
    public double getDouble(int columnIndex) throws SQLException {
        int colType = this.columnMetaDataList.get(columnIndex - 1).getColType();
        return this.rowCursor.getDouble(columnIndex, colType);
    }

    @Override
    public byte[] getBytes(int columnIndex) throws SQLException {
        int colType = this.columnMetaDataList.get(columnIndex - 1).getColType();
        return this.rowCursor.getString(columnIndex, colType).getBytes();
    }

    @Override
    public Timestamp getTimestamp(int columnIndex) throws SQLException {
        int colType = this.columnMetaDataList.get(columnIndex - 1).getColType();
        return this.rowCursor.getTimestamp(columnIndex, colType);
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        return new TSDBResultSetMetaData(this.columnMetaDataList);
    }

    @Override
    public Object getObject(int columnIndex) throws SQLException {
        return this.rowCursor.getObject(columnIndex);
    }

    @Override
    public int findColumn(String columnLabel) throws SQLException {
        for (ColumnMetaData colMetaData : this.columnMetaDataList) {
            if (colMetaData.getColName() == null || !colMetaData.getColName().equals(columnLabel)) continue;
            return colMetaData.getColIndex();
        }
        throw TSDBError.createSQLException(8963);
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex) throws SQLException {
        int colType = this.columnMetaDataList.get(columnIndex - 1).getColType();
        double value = this.rowCursor.getDouble(columnIndex, colType);
        return BigDecimal.valueOf(value);
    }

    @Override
    public boolean isBeforeFirst() throws SQLException {
        return this.cursorRowNumber == 0;
    }

    @Override
    public boolean isAfterLast() throws SQLException {
        return this.rowDataList.iterator().hasNext();
    }

    @Override
    public boolean isFirst() throws SQLException {
        return this.cursorRowNumber == 1;
    }

    @Override
    public boolean isLast() throws SQLException {
        return this.cursorRowNumber == this.rowDataList.size();
    }

    @Override
    public void beforeFirst() throws SQLException {
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public void afterLast() throws SQLException {
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public boolean first() throws SQLException {
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public boolean last() throws SQLException {
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public int getRow() throws SQLException {
        if (this.cursorRowNumber > 0 && this.cursorRowNumber <= this.rowDataList.size()) {
            return this.cursorRowNumber;
        }
        return 0;
    }

    @Override
    public boolean absolute(int row) throws SQLException {
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public boolean relative(int rows) throws SQLException {
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public boolean previous() throws SQLException {
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public Statement getStatement() throws SQLException {
        return null;
    }

    @Override
    public Timestamp getTimestamp(int columnIndex, Calendar cal) throws SQLException {
        return this.getTimestamp(columnIndex);
    }

    @Override
    public boolean isClosed() throws SQLException {
        return false;
    }

    @Override
    public String getNString(int columnIndex) throws SQLException {
        return this.getString(columnIndex);
    }
}

