/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.ads.api;

import com.google.gson.reflect.TypeToken;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.Interceptor;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import com.tencent.ads.ApiCallback;
import com.tencent.ads.ApiClient;
import com.tencent.ads.ApiException;
import com.tencent.ads.ApiResponse;
import com.tencent.ads.Configuration;
import com.tencent.ads.Pair;
import com.tencent.ads.ProgressRequestBody;
import com.tencent.ads.ProgressResponseBody;
import com.tencent.ads.model.CustomAudienceFilesAddResponse;
import com.tencent.ads.model.CustomAudienceFilesGetResponse;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class CustomAudienceFilesApi {
    private ApiClient apiClient;

    public CustomAudienceFilesApi() {
        this(Configuration.getDefaultApiClient());
    }

    public CustomAudienceFilesApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Call customAudienceFilesAddCall(Long accountId, Long audienceId, String userIdType, File file, String operationType, String openAppId, String saltId, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/custom_audience_files/add";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (accountId != null) {
            localVarFormParams.put("account_id", accountId);
        }
        if (audienceId != null) {
            localVarFormParams.put("audience_id", audienceId);
        }
        if (userIdType != null) {
            localVarFormParams.put("user_id_type", userIdType);
        }
        if (file != null) {
            localVarFormParams.put("file", file);
        }
        if (operationType != null) {
            localVarFormParams.put("operation_type", operationType);
        }
        if (openAppId != null) {
            localVarFormParams.put("open_app_id", openAppId);
        }
        if (saltId != null) {
            localVarFormParams.put("salt_id", saltId);
        }
        if ((localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"multipart/form-data"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"accessToken", "nonce", "timestamp"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call customAudienceFilesAddValidateBeforeCall(Long accountId, Long audienceId, String userIdType, File file, String operationType, String openAppId, String saltId, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (accountId == null) {
            throw new ApiException("Missing the required parameter 'accountId' when calling customAudienceFilesAdd(Async)");
        }
        if (audienceId == null) {
            throw new ApiException("Missing the required parameter 'audienceId' when calling customAudienceFilesAdd(Async)");
        }
        if (userIdType == null) {
            throw new ApiException("Missing the required parameter 'userIdType' when calling customAudienceFilesAdd(Async)");
        }
        if (file == null) {
            throw new ApiException("Missing the required parameter 'file' when calling customAudienceFilesAdd(Async)");
        }
        Call call = this.customAudienceFilesAddCall(accountId, audienceId, userIdType, file, operationType, openAppId, saltId, progressListener, progressRequestListener);
        return call;
    }

    public CustomAudienceFilesAddResponse customAudienceFilesAdd(Long accountId, Long audienceId, String userIdType, File file, String operationType, String openAppId, String saltId) throws ApiException {
        ApiResponse<CustomAudienceFilesAddResponse> resp = this.customAudienceFilesAddWithHttpInfo(accountId, audienceId, userIdType, file, operationType, openAppId, saltId);
        return resp.getData();
    }

    public ApiResponse<CustomAudienceFilesAddResponse> customAudienceFilesAddWithHttpInfo(Long accountId, Long audienceId, String userIdType, File file, String operationType, String openAppId, String saltId) throws ApiException {
        Call call = this.customAudienceFilesAddValidateBeforeCall(accountId, audienceId, userIdType, file, operationType, openAppId, saltId, null, null);
        Type localVarReturnType = new TypeToken<CustomAudienceFilesAddResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call customAudienceFilesAddAsync(Long accountId, Long audienceId, String userIdType, File file, String operationType, String openAppId, String saltId, final ApiCallback<CustomAudienceFilesAddResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.customAudienceFilesAddValidateBeforeCall(accountId, audienceId, userIdType, file, operationType, openAppId, saltId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<CustomAudienceFilesAddResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call customAudienceFilesGetCall(Long accountId, Long audienceId, Long customAudienceFileId, Long page, Long pageSize, List<String> fields, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/custom_audience_files/get";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (accountId != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("account_id", accountId));
        }
        if (audienceId != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("audience_id", audienceId));
        }
        if (customAudienceFileId != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("custom_audience_file_id", customAudienceFileId));
        }
        if (page != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("page", page));
        }
        if (pageSize != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("page_size", pageSize));
        }
        if (fields != null) {
            localVarCollectionQueryParams.addAll(this.apiClient.parameterToPairs("multi", "fields", fields));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"text/plain"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"accessToken", "nonce", "timestamp"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call customAudienceFilesGetValidateBeforeCall(Long accountId, Long audienceId, Long customAudienceFileId, Long page, Long pageSize, List<String> fields, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (accountId == null) {
            throw new ApiException("Missing the required parameter 'accountId' when calling customAudienceFilesGet(Async)");
        }
        Call call = this.customAudienceFilesGetCall(accountId, audienceId, customAudienceFileId, page, pageSize, fields, progressListener, progressRequestListener);
        return call;
    }

    public CustomAudienceFilesGetResponse customAudienceFilesGet(Long accountId, Long audienceId, Long customAudienceFileId, Long page, Long pageSize, List<String> fields) throws ApiException {
        ApiResponse<CustomAudienceFilesGetResponse> resp = this.customAudienceFilesGetWithHttpInfo(accountId, audienceId, customAudienceFileId, page, pageSize, fields);
        return resp.getData();
    }

    public ApiResponse<CustomAudienceFilesGetResponse> customAudienceFilesGetWithHttpInfo(Long accountId, Long audienceId, Long customAudienceFileId, Long page, Long pageSize, List<String> fields) throws ApiException {
        Call call = this.customAudienceFilesGetValidateBeforeCall(accountId, audienceId, customAudienceFileId, page, pageSize, fields, null, null);
        Type localVarReturnType = new TypeToken<CustomAudienceFilesGetResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call customAudienceFilesGetAsync(Long accountId, Long audienceId, Long customAudienceFileId, Long page, Long pageSize, List<String> fields, final ApiCallback<CustomAudienceFilesGetResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.customAudienceFilesGetValidateBeforeCall(accountId, audienceId, customAudienceFileId, page, pageSize, fields, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<CustomAudienceFilesGetResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}

