/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.ads.api;

import com.google.gson.reflect.TypeToken;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.Interceptor;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import com.tencent.ads.ApiCallback;
import com.tencent.ads.ApiClient;
import com.tencent.ads.ApiException;
import com.tencent.ads.ApiResponse;
import com.tencent.ads.Configuration;
import com.tencent.ads.Pair;
import com.tencent.ads.ProgressRequestBody;
import com.tencent.ads.ProgressResponseBody;
import com.tencent.ads.model.WechatQualificationsAddResponse;
import com.tencent.ads.model.WechatQualificationsDeleteRequest;
import com.tencent.ads.model.WechatQualificationsDeleteResponse;
import com.tencent.ads.model.WechatQualificationsGetResponse;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class WechatQualificationsApi {
    private ApiClient apiClient;

    public WechatQualificationsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public WechatQualificationsApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Call wechatQualificationsAddCall(Long accountId, String wechatQualificationType, File wechatQualificationFile, String wechatQualificationFileSignature, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/wechat_qualifications/add";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (accountId != null) {
            localVarFormParams.put("account_id", accountId);
        }
        if (wechatQualificationType != null) {
            localVarFormParams.put("wechat_qualification_type", wechatQualificationType);
        }
        if (wechatQualificationFile != null) {
            localVarFormParams.put("wechat_qualification_file", wechatQualificationFile);
        }
        if (wechatQualificationFileSignature != null) {
            localVarFormParams.put("wechat_qualification_file_signature", wechatQualificationFileSignature);
        }
        if ((localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"multipart/form-data"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"accessToken", "nonce", "timestamp"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call wechatQualificationsAddValidateBeforeCall(Long accountId, String wechatQualificationType, File wechatQualificationFile, String wechatQualificationFileSignature, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (accountId == null) {
            throw new ApiException("Missing the required parameter 'accountId' when calling wechatQualificationsAdd(Async)");
        }
        if (wechatQualificationType == null) {
            throw new ApiException("Missing the required parameter 'wechatQualificationType' when calling wechatQualificationsAdd(Async)");
        }
        if (wechatQualificationFile == null) {
            throw new ApiException("Missing the required parameter 'wechatQualificationFile' when calling wechatQualificationsAdd(Async)");
        }
        if (wechatQualificationFileSignature == null) {
            throw new ApiException("Missing the required parameter 'wechatQualificationFileSignature' when calling wechatQualificationsAdd(Async)");
        }
        Call call = this.wechatQualificationsAddCall(accountId, wechatQualificationType, wechatQualificationFile, wechatQualificationFileSignature, progressListener, progressRequestListener);
        return call;
    }

    public WechatQualificationsAddResponse wechatQualificationsAdd(Long accountId, String wechatQualificationType, File wechatQualificationFile, String wechatQualificationFileSignature) throws ApiException {
        ApiResponse<WechatQualificationsAddResponse> resp = this.wechatQualificationsAddWithHttpInfo(accountId, wechatQualificationType, wechatQualificationFile, wechatQualificationFileSignature);
        return resp.getData();
    }

    public ApiResponse<WechatQualificationsAddResponse> wechatQualificationsAddWithHttpInfo(Long accountId, String wechatQualificationType, File wechatQualificationFile, String wechatQualificationFileSignature) throws ApiException {
        Call call = this.wechatQualificationsAddValidateBeforeCall(accountId, wechatQualificationType, wechatQualificationFile, wechatQualificationFileSignature, null, null);
        Type localVarReturnType = new TypeToken<WechatQualificationsAddResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call wechatQualificationsAddAsync(Long accountId, String wechatQualificationType, File wechatQualificationFile, String wechatQualificationFileSignature, final ApiCallback<WechatQualificationsAddResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.wechatQualificationsAddValidateBeforeCall(accountId, wechatQualificationType, wechatQualificationFile, wechatQualificationFileSignature, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<WechatQualificationsAddResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call wechatQualificationsDeleteCall(WechatQualificationsDeleteRequest data, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        WechatQualificationsDeleteRequest localVarPostBody = data;
        String localVarPath = "/wechat_qualifications/delete";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json", "application/xml"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"accessToken", "nonce", "timestamp"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call wechatQualificationsDeleteValidateBeforeCall(WechatQualificationsDeleteRequest data, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (data == null) {
            throw new ApiException("Missing the required parameter 'data' when calling wechatQualificationsDelete(Async)");
        }
        Call call = this.wechatQualificationsDeleteCall(data, progressListener, progressRequestListener);
        return call;
    }

    public WechatQualificationsDeleteResponse wechatQualificationsDelete(WechatQualificationsDeleteRequest data) throws ApiException {
        ApiResponse<WechatQualificationsDeleteResponse> resp = this.wechatQualificationsDeleteWithHttpInfo(data);
        return resp.getData();
    }

    public ApiResponse<WechatQualificationsDeleteResponse> wechatQualificationsDeleteWithHttpInfo(WechatQualificationsDeleteRequest data) throws ApiException {
        Call call = this.wechatQualificationsDeleteValidateBeforeCall(data, null, null);
        Type localVarReturnType = new TypeToken<WechatQualificationsDeleteResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call wechatQualificationsDeleteAsync(WechatQualificationsDeleteRequest data, final ApiCallback<WechatQualificationsDeleteResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.wechatQualificationsDeleteValidateBeforeCall(data, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<WechatQualificationsDeleteResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call wechatQualificationsGetCall(Long accountId, List<String> fields, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/wechat_qualifications/get";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (accountId != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("account_id", accountId));
        }
        if (fields != null) {
            localVarCollectionQueryParams.addAll(this.apiClient.parameterToPairs("multi", "fields", fields));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"text/plain"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"accessToken", "nonce", "timestamp"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call wechatQualificationsGetValidateBeforeCall(Long accountId, List<String> fields, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (accountId == null) {
            throw new ApiException("Missing the required parameter 'accountId' when calling wechatQualificationsGet(Async)");
        }
        Call call = this.wechatQualificationsGetCall(accountId, fields, progressListener, progressRequestListener);
        return call;
    }

    public WechatQualificationsGetResponse wechatQualificationsGet(Long accountId, List<String> fields) throws ApiException {
        ApiResponse<WechatQualificationsGetResponse> resp = this.wechatQualificationsGetWithHttpInfo(accountId, fields);
        return resp.getData();
    }

    public ApiResponse<WechatQualificationsGetResponse> wechatQualificationsGetWithHttpInfo(Long accountId, List<String> fields) throws ApiException {
        Call call = this.wechatQualificationsGetValidateBeforeCall(accountId, fields, null, null);
        Type localVarReturnType = new TypeToken<WechatQualificationsGetResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call wechatQualificationsGetAsync(Long accountId, List<String> fields, final ApiCallback<WechatQualificationsGetResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.wechatQualificationsGetValidateBeforeCall(accountId, fields, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<WechatQualificationsGetResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}

