/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.ads.examples.BasicOperations.AdsManagement;

import com.tencent.ads.ApiContextConfig;
import com.tencent.ads.TencentAds;
import com.tencent.ads.exception.TencentAdsResponseException;
import com.tencent.ads.exception.TencentAdsSDKException;
import com.tencent.ads.model.AdsGetResponseData;
import com.tencent.ads.model.FilteringStruct;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class GetAds {
    public String ACCESS_TOKEN = "YOUR ACCESS TOKEN";
    public TencentAds tencentAds;
    public Long accountId = null;
    public List<FilteringStruct> filtering = new ArrayList<FilteringStruct>();
    public Long page = null;
    public Long pageSize = null;
    public Boolean isDeleted = null;
    public List<String> fields = Arrays.asList("ad_id", "campaign_id", "adgroup_id", "adcreative_id", "ad_name");

    public void init() {
        this.tencentAds = TencentAds.getInstance();
        this.tencentAds.init(new ApiContextConfig().accessToken(this.ACCESS_TOKEN).isDebug(true));
        this.tencentAds.useSandbox();
        this.buildParams();
    }

    public void buildParams() {
        String field = "configured_status";
        FilteringStruct filteringStruct = new FilteringStruct();
        filteringStruct.setField(field);
        String operator = "EQUALS";
        filteringStruct.setOperator(operator);
        List<String> values = Arrays.asList("AD_STATUS_NORMAL");
        filteringStruct.setValues(values);
        this.filtering.add(filteringStruct);
    }

    public AdsGetResponseData getAds() throws Exception {
        AdsGetResponseData response = this.tencentAds.ads().adsGet(this.accountId, this.filtering, this.page, this.pageSize, this.isDeleted, this.fields);
        return response;
    }

    public static void main(String[] args) {
        try {
            GetAds getAds = new GetAds();
            getAds.init();
            AdsGetResponseData adsGetResponseData = getAds.getAds();
        }
        catch (TencentAdsResponseException e) {
            e.printStackTrace();
        }
        catch (TencentAdsSDKException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

