/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.ads.examples.WechatAds;

import com.tencent.ads.ApiContextConfig;
import com.tencent.ads.ApiException;
import com.tencent.ads.TencentAds;
import com.tencent.ads.exception.TencentAdsResponseException;
import com.tencent.ads.exception.TencentAdsSDKException;
import com.tencent.ads.model.AdcreativeCreativeElementsMp;
import com.tencent.ads.model.AdcreativesAddRequest;
import com.tencent.ads.model.AdcreativesAddResponseData;
import com.tencent.ads.model.AdgroupsAddRequest;
import com.tencent.ads.model.AdgroupsAddResponseData;
import com.tencent.ads.model.AdsAddRequest;
import com.tencent.ads.model.AdsAddResponseData;
import com.tencent.ads.model.AgeStruct;
import com.tencent.ads.model.BillingEvent;
import com.tencent.ads.model.CampaignType;
import com.tencent.ads.model.CampaignsAddRequest;
import com.tencent.ads.model.CampaignsAddResponseData;
import com.tencent.ads.model.DestinationType;
import com.tencent.ads.model.GeoLocations;
import com.tencent.ads.model.ImagesAddResponseData;
import com.tencent.ads.model.OptimizationGoal;
import com.tencent.ads.model.PageSpec;
import com.tencent.ads.model.ProfileType;
import com.tencent.ads.model.ProfilesAddRequest;
import com.tencent.ads.model.ProfilesAddResponseData;
import com.tencent.ads.model.PromotedObjectType;
import com.tencent.ads.model.WriteTargetingSettingForAdgroup;
import com.tencent.ads.utils.SignatureUtils;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.UUID;

public class AddLeadsAds {
    public String ACCESS_TOKEN = "YOUR ACCESS TOKEN";
    public Long ACCOUNT_ID = 0L;
    public String IMAGE_PATH = "YOUR AD IMAGE PATH";
    public String IMAGE_PROFILE_PATH = "YOUR AD IMAGE PROFILE PATH";
    public Long ADCREATIVE_TEMPLATE_ID = 450L;
    public String AD_TITLE = "YOUR AD TITLE";
    public String AD_DESCRIPTION = "YOUR AD DESCRIPTION";
    public String AD_URL = "YOUR AD PAGE URL";
    public TencentAds tencentAds;

    public void init() {
        this.tencentAds = TencentAds.getInstance();
        this.tencentAds.init(new ApiContextConfig().accessToken(this.ACCESS_TOKEN).isDebug(true));
        this.tencentAds.useSandbox();
    }

    public Long addLeadsAds() throws Exception {
        Long campaignId = this.addCampaign(CampaignType.NORMAL, PromotedObjectType.LEAD_AD);
        List<String> siteSet = Arrays.asList("SITE_SET_MOMENTS");
        Long adgroupId = this.addAdgroups(campaignId, PromotedObjectType.LEAD_AD, siteSet);
        String imageId = this.addImage(this.IMAGE_PATH);
        String imageIdLeads = this.addImage(this.IMAGE_PROFILE_PATH);
        Long profileId = this.addProfile(PromotedObjectType.LEAD_AD, imageIdLeads);
        Long adcreativeId = this.addAdcreative(this.ADCREATIVE_TEMPLATE_ID, this.AD_URL, PromotedObjectType.LEAD_AD, this.AD_TITLE, this.AD_DESCRIPTION, campaignId, Arrays.asList(imageId), siteSet, profileId);
        Long adId = this.addAd(adgroupId, adcreativeId);
        return adId;
    }

    protected Long addCampaign(CampaignType campaignType, PromotedObjectType promotedObjectType) throws ApiException {
        CampaignsAddRequest campaignsAddRequest = new CampaignsAddRequest();
        campaignsAddRequest.setAccountId(this.ACCOUNT_ID);
        campaignsAddRequest.setCampaignName("SDK sample campaign" + UUID.randomUUID().toString().substring(0, 6));
        campaignsAddRequest.setCampaignType(campaignType);
        campaignsAddRequest.setPromotedObjectType(promotedObjectType);
        campaignsAddRequest.setDailyBudget(0L);
        CampaignsAddResponseData responseData = this.tencentAds.campaigns().campaignsAdd(campaignsAddRequest);
        if (responseData != null) {
            return responseData.getCampaignId();
        }
        return null;
    }

    protected Long addAdgroups(Long campaignId, PromotedObjectType promotedObjectType, List<String> siteSet) throws ApiException {
        AdgroupsAddRequest data = new AdgroupsAddRequest();
        data.setAccountId(this.ACCOUNT_ID);
        data.setAdgroupName("SDK sample adgroup" + UUID.randomUUID().toString().substring(0, 6));
        data.setPromotedObjectType(promotedObjectType);
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        Date now = new Date();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(now);
        calendar.add(5, 1);
        Date start = calendar.getTime();
        calendar.setTime(now);
        calendar.add(5, 10);
        Date end = calendar.getTime();
        data.setBeginDate(df.format(start));
        data.setEndDate(df.format(end));
        data.setBillingEvent(BillingEvent.IMPRESSION);
        data.setBidAmount(5000L);
        data.setOptimizationGoal(OptimizationGoal.IMPRESSION);
        data.setDailyBudget(1000000L);
        String timeSeries = "111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111";
        data.setTimeSeries(timeSeries);
        data.setSiteSet(siteSet);
        WriteTargetingSettingForAdgroup targeting = new WriteTargetingSettingForAdgroup();
        targeting.age(Arrays.asList(new AgeStruct().max(45L).min(23L))).gender(Arrays.asList("MALE")).geoLocation(new GeoLocations().locationTypes(Arrays.asList("LIVE_IN")).regions(Arrays.asList(110000L)));
        data.setTargeting(targeting);
        data.setCampaignId(campaignId);
        AdgroupsAddResponseData responseData = this.tencentAds.adgroups().adgroupsAdd(data);
        if (responseData != null) {
            return responseData.getAdgroupId();
        }
        return null;
    }

    protected String addImage(String imageFile) throws Exception {
        ImagesAddResponseData responseData = this.tencentAds.images().imagesAdd(this.ACCOUNT_ID, "UPLOAD_TYPE_FILE", SignatureUtils.getMD5Checksum(imageFile), new File(imageFile), null, null, null);
        if (responseData != null) {
            return responseData.getImageId();
        }
        return null;
    }

    protected Long addProfile(PromotedObjectType promotedObjectType, String imageId) throws ApiException {
        ProfilesAddRequest addRequest = new ProfilesAddRequest();
        addRequest.setAccountId(this.ACCOUNT_ID);
        addRequest.setProfileName("SDKsample" + UUID.randomUUID().toString().substring(0, 4));
        addRequest.setProfileType(ProfileType.DEFINITION);
        addRequest.setPromotedObjectType(promotedObjectType);
        addRequest.setHeadImageId(imageId);
        addRequest.setDescription("SDKsample");
        ProfilesAddResponseData responseData = this.tencentAds.profiles().profilesAdd(addRequest);
        if (responseData != null) {
            return responseData.getProfileId();
        }
        return null;
    }

    protected Long addAdcreative(Long adcreativeTemplateId, String pageUrl, PromotedObjectType promotedObjectType, String creativeElementsTitle, String creativeElementsDesc, Long campaignId, List<String> imageIdList, List<String> siteSet, Long profileId) throws ApiException {
        AdcreativesAddRequest data = new AdcreativesAddRequest();
        data.setAccountId(this.ACCOUNT_ID);
        data.setAdcreativeName("SDK sample adcreative" + UUID.randomUUID().toString().substring(0, 6));
        data.setAdcreativeElements(new AdcreativeCreativeElementsMp().imageList(imageIdList).title(creativeElementsTitle).description(creativeElementsDesc));
        data.setPageSpec(new PageSpec().pageUrl(pageUrl));
        data.setPageType(DestinationType.DEFAULT);
        data.setAdcreativeTemplateId(adcreativeTemplateId);
        data.setPromotedObjectType(promotedObjectType);
        data.setCampaignId(campaignId);
        data.setSiteSet(siteSet);
        data.setProfileId(profileId);
        AdcreativesAddResponseData responseData = this.tencentAds.adcreatives().adcreativesAdd(data);
        if (responseData != null) {
            return responseData.getAdcreativeId();
        }
        return null;
    }

    protected Long addAd(Long adgroupId, Long adcreativeId) throws ApiException {
        AdsAddRequest data = new AdsAddRequest();
        data.setAccountId(this.ACCOUNT_ID);
        data.setAdgroupId(adgroupId);
        data.setAdcreativeId(adcreativeId);
        data.setAdName("SDK sample ad" + UUID.randomUUID().toString().substring(0, 6));
        AdsAddResponseData responseData = this.tencentAds.ads().adsAdd(data);
        if (responseData != null) {
            return responseData.getAdId();
        }
        return null;
    }

    public static void main(String[] args) {
        try {
            AddLeadsAds addLeadsAds = new AddLeadsAds();
            addLeadsAds.init();
            Long l = addLeadsAds.addLeadsAds();
        }
        catch (TencentAdsResponseException e) {
            e.printStackTrace();
        }
        catch (TencentAdsSDKException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

