/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.ads.api;

import com.google.gson.reflect.TypeToken;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.Interceptor;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import com.tencent.ads.ApiCallback;
import com.tencent.ads.ApiClient;
import com.tencent.ads.ApiException;
import com.tencent.ads.ApiResponse;
import com.tencent.ads.Configuration;
import com.tencent.ads.Pair;
import com.tencent.ads.ProgressRequestBody;
import com.tencent.ads.ProgressResponseBody;
import com.tencent.ads.model.CustomAudiencesAddRequest;
import com.tencent.ads.model.CustomAudiencesAddResponse;
import com.tencent.ads.model.CustomAudiencesDeleteRequest;
import com.tencent.ads.model.CustomAudiencesDeleteResponse;
import com.tencent.ads.model.CustomAudiencesGetResponse;
import com.tencent.ads.model.CustomAudiencesUpdateRequest;
import com.tencent.ads.model.CustomAudiencesUpdateResponse;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class CustomAudiencesApi {
    private ApiClient apiClient;

    public CustomAudiencesApi() {
        this(Configuration.getDefaultApiClient());
    }

    public CustomAudiencesApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Call customAudiencesAddCall(CustomAudiencesAddRequest data, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        CustomAudiencesAddRequest localVarPostBody = data;
        String localVarPath = "/custom_audiences/add";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json", "application/xml"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"accessToken", "nonce", "timestamp"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call customAudiencesAddValidateBeforeCall(CustomAudiencesAddRequest data, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (data == null) {
            throw new ApiException("Missing the required parameter 'data' when calling customAudiencesAdd(Async)");
        }
        Call call = this.customAudiencesAddCall(data, progressListener, progressRequestListener);
        return call;
    }

    public CustomAudiencesAddResponse customAudiencesAdd(CustomAudiencesAddRequest data) throws ApiException {
        ApiResponse<CustomAudiencesAddResponse> resp = this.customAudiencesAddWithHttpInfo(data);
        return resp.getData();
    }

    public ApiResponse<CustomAudiencesAddResponse> customAudiencesAddWithHttpInfo(CustomAudiencesAddRequest data) throws ApiException {
        Call call = this.customAudiencesAddValidateBeforeCall(data, null, null);
        Type localVarReturnType = new TypeToken<CustomAudiencesAddResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call customAudiencesAddAsync(CustomAudiencesAddRequest data, final ApiCallback<CustomAudiencesAddResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.customAudiencesAddValidateBeforeCall(data, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<CustomAudiencesAddResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call customAudiencesDeleteCall(CustomAudiencesDeleteRequest data, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        CustomAudiencesDeleteRequest localVarPostBody = data;
        String localVarPath = "/custom_audiences/delete";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json", "application/xml"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"accessToken", "nonce", "timestamp"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call customAudiencesDeleteValidateBeforeCall(CustomAudiencesDeleteRequest data, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (data == null) {
            throw new ApiException("Missing the required parameter 'data' when calling customAudiencesDelete(Async)");
        }
        Call call = this.customAudiencesDeleteCall(data, progressListener, progressRequestListener);
        return call;
    }

    public CustomAudiencesDeleteResponse customAudiencesDelete(CustomAudiencesDeleteRequest data) throws ApiException {
        ApiResponse<CustomAudiencesDeleteResponse> resp = this.customAudiencesDeleteWithHttpInfo(data);
        return resp.getData();
    }

    public ApiResponse<CustomAudiencesDeleteResponse> customAudiencesDeleteWithHttpInfo(CustomAudiencesDeleteRequest data) throws ApiException {
        Call call = this.customAudiencesDeleteValidateBeforeCall(data, null, null);
        Type localVarReturnType = new TypeToken<CustomAudiencesDeleteResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call customAudiencesDeleteAsync(CustomAudiencesDeleteRequest data, final ApiCallback<CustomAudiencesDeleteResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.customAudiencesDeleteValidateBeforeCall(data, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<CustomAudiencesDeleteResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call customAudiencesGetCall(Long accountId, Long audienceId, Long page, Long pageSize, String platform, List<String> fields, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/custom_audiences/get";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (accountId != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("account_id", accountId));
        }
        if (audienceId != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("audience_id", audienceId));
        }
        if (page != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("page", page));
        }
        if (pageSize != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("page_size", pageSize));
        }
        if (platform != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("platform", platform));
        }
        if (fields != null) {
            localVarCollectionQueryParams.addAll(this.apiClient.parameterToPairs("multi", "fields", fields));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"text/plain"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"accessToken", "nonce", "timestamp"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call customAudiencesGetValidateBeforeCall(Long accountId, Long audienceId, Long page, Long pageSize, String platform, List<String> fields, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (accountId == null) {
            throw new ApiException("Missing the required parameter 'accountId' when calling customAudiencesGet(Async)");
        }
        Call call = this.customAudiencesGetCall(accountId, audienceId, page, pageSize, platform, fields, progressListener, progressRequestListener);
        return call;
    }

    public CustomAudiencesGetResponse customAudiencesGet(Long accountId, Long audienceId, Long page, Long pageSize, String platform, List<String> fields) throws ApiException {
        ApiResponse<CustomAudiencesGetResponse> resp = this.customAudiencesGetWithHttpInfo(accountId, audienceId, page, pageSize, platform, fields);
        return resp.getData();
    }

    public ApiResponse<CustomAudiencesGetResponse> customAudiencesGetWithHttpInfo(Long accountId, Long audienceId, Long page, Long pageSize, String platform, List<String> fields) throws ApiException {
        Call call = this.customAudiencesGetValidateBeforeCall(accountId, audienceId, page, pageSize, platform, fields, null, null);
        Type localVarReturnType = new TypeToken<CustomAudiencesGetResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call customAudiencesGetAsync(Long accountId, Long audienceId, Long page, Long pageSize, String platform, List<String> fields, final ApiCallback<CustomAudiencesGetResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.customAudiencesGetValidateBeforeCall(accountId, audienceId, page, pageSize, platform, fields, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<CustomAudiencesGetResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call customAudiencesUpdateCall(CustomAudiencesUpdateRequest data, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        CustomAudiencesUpdateRequest localVarPostBody = data;
        String localVarPath = "/custom_audiences/update";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json", "application/xml"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"accessToken", "nonce", "timestamp"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call customAudiencesUpdateValidateBeforeCall(CustomAudiencesUpdateRequest data, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (data == null) {
            throw new ApiException("Missing the required parameter 'data' when calling customAudiencesUpdate(Async)");
        }
        Call call = this.customAudiencesUpdateCall(data, progressListener, progressRequestListener);
        return call;
    }

    public CustomAudiencesUpdateResponse customAudiencesUpdate(CustomAudiencesUpdateRequest data) throws ApiException {
        ApiResponse<CustomAudiencesUpdateResponse> resp = this.customAudiencesUpdateWithHttpInfo(data);
        return resp.getData();
    }

    public ApiResponse<CustomAudiencesUpdateResponse> customAudiencesUpdateWithHttpInfo(CustomAudiencesUpdateRequest data) throws ApiException {
        Call call = this.customAudiencesUpdateValidateBeforeCall(data, null, null);
        Type localVarReturnType = new TypeToken<CustomAudiencesUpdateResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call customAudiencesUpdateAsync(CustomAudiencesUpdateRequest data, final ApiCallback<CustomAudiencesUpdateResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.customAudiencesUpdateValidateBeforeCall(data, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<CustomAudiencesUpdateResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}

