/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cloud;

import com.tencent.cloud.RegionCodeFilter;
import com.tencent.cloud.STSPolicy;
import com.tencent.cloud.Scope;
import com.tencent.cloud.cos.util.Request;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.json.JSONArray;
import org.json.JSONObject;

public class CosStsClient {
    private static final int DEFAULT_DURATION_SECONDS = 1800;
    private static final String STS_DEFAULT_HOST = "sts.tencentcloudapi.com";

    public static JSONObject getCredential(TreeMap<String, Object> config) throws IOException {
        TreeMap<String, Object> params = new TreeMap<String, Object>();
        Parameters parameters = new Parameters();
        parameters.parse(config);
        if (parameters.secretId == null) {
            throw new IllegalArgumentException("secretId is null");
        }
        if (parameters.secretKey == null) {
            throw new IllegalArgumentException("secretKey is null");
        }
        String policy = parameters.policy;
        if (policy != null) {
            params.put("Policy", policy);
        } else {
            params.put("Policy", CosStsClient.getPolicy(parameters).toString());
        }
        params.put("DurationSeconds", parameters.duration);
        params.put("Name", "cos-sts-java");
        params.put("Action", "GetFederationToken");
        params.put("Version", "2018-08-13");
        String region = RegionCodeFilter.convert(parameters.region);
        params.put("Region", region);
        if (parameters.secretType != null) {
            params.put("SecretType", parameters.secretType);
        }
        String host = STS_DEFAULT_HOST;
        if (parameters.host != null) {
            host = parameters.host;
        }
        String path = "/";
        String result = null;
        JSONObject jsonResult = null;
        try {
            result = Request.send(params, parameters.secretId, parameters.secretKey, "POST", host, path);
            jsonResult = new JSONObject(result);
            JSONObject data = jsonResult.optJSONObject("Response");
            if (data == null) {
                data = jsonResult;
            }
            long expiredTime = data.getLong("ExpiredTime");
            data.put("startTime", expiredTime - (long)parameters.duration);
            return CosStsClient.downCompat(data);
        }
        catch (Exception e) {
            JSONObject error;
            JSONObject response;
            if (jsonResult != null && (response = jsonResult.optJSONObject("Response")) != null && (error = response.optJSONObject("Error")) != null) {
                String message = error.optString("Message");
                String code = error.optString("Code");
                if ("InvalidParameterValue".equals(code) && message != null && message.contains("Region") && RegionCodeFilter.block(region)) {
                    return CosStsClient.getCredential(config);
                }
            }
            throw new IOException("result = " + result, e);
        }
    }

    public static String getPolicy(List<Scope> scopes) {
        if (scopes == null || scopes.size() == 0) {
            return null;
        }
        STSPolicy stsPolicy = new STSPolicy();
        stsPolicy.addScope(scopes);
        return stsPolicy.toString();
    }

    private static JSONObject downCompat(JSONObject resultJson) {
        JSONObject dcJson = new JSONObject();
        for (String key : resultJson.keySet()) {
            Object value = resultJson.get(key);
            if (value instanceof JSONObject) {
                dcJson.put(CosStsClient.headerToLowerCase(key), (Object)CosStsClient.downCompat((JSONObject)value));
                continue;
            }
            String newKey = "Token".equals(key) ? "sessionToken" : CosStsClient.headerToLowerCase(key);
            dcJson.put(newKey, resultJson.get(key));
        }
        return dcJson;
    }

    private static String headerToLowerCase(String source) {
        return Character.toLowerCase(source.charAt(0)) + source.substring(1);
    }

    private static JSONObject getPolicy(Parameters parameters) {
        if (parameters.bucket == null) {
            throw new IllegalArgumentException("bucket == null");
        }
        if (parameters.allowPrefixes == null) {
            throw new IllegalArgumentException("allowPrefixes == null");
        }
        if (parameters.region == null) {
            throw new IllegalArgumentException("region == null");
        }
        String bucket = parameters.bucket;
        String region = parameters.region;
        int lastSplit = bucket.lastIndexOf("-");
        String appId = bucket.substring(lastSplit + 1);
        String[] allowPrefixes = parameters.allowPrefixes;
        ArrayList<String> resources = new ArrayList<String>(allowPrefixes.length);
        for (String prefix : allowPrefixes) {
            String p = prefix;
            if (!p.startsWith("/")) {
                p = "/" + p;
            }
            String resource = String.format("qcs::cos:%s:uid/%s:%s%s", region, appId, bucket, p);
            resources.add(resource);
        }
        JSONObject policy = new JSONObject();
        policy.put("version", (Object)"2.0");
        JSONArray statements = new JSONArray();
        JSONObject statement = new JSONObject();
        statement.put("effect", (Object)"allow");
        statement.put("action", (Object)parameters.allowActions);
        statement.put("resource", (Object)resources.toArray(new String[0]));
        statements.put((Object)statement);
        policy.put("statement", (Object)statements);
        return policy;
    }

    private static class Parameters {
        String secretId;
        String secretKey;
        int duration = 1800;
        String bucket;
        String region;
        String[] allowPrefixes;
        String[] allowActions;
        String policy;
        Integer secretType;
        String host;

        private Parameters() {
        }

        public void parse(Map<String, Object> config) {
            if (config == null) {
                throw new NullPointerException("config == null");
            }
            for (Map.Entry<String, Object> entry : config.entrySet()) {
                String key = entry.getKey();
                if ("SecretId".equalsIgnoreCase(key)) {
                    this.secretId = (String)entry.getValue();
                    continue;
                }
                if ("SecretKey".equalsIgnoreCase(key)) {
                    this.secretKey = (String)entry.getValue();
                    continue;
                }
                if ("durationSeconds".equalsIgnoreCase(key)) {
                    this.duration = (Integer)entry.getValue();
                    continue;
                }
                if ("bucket".equalsIgnoreCase(key)) {
                    this.bucket = (String)entry.getValue();
                    continue;
                }
                if ("region".equalsIgnoreCase(key)) {
                    this.region = (String)entry.getValue();
                    continue;
                }
                if ("allowPrefix".equalsIgnoreCase(key)) {
                    this.allowPrefixes = new String[]{(String)entry.getValue()};
                    continue;
                }
                if ("allowPrefixes".equalsIgnoreCase(key)) {
                    this.allowPrefixes = (String[])entry.getValue();
                    continue;
                }
                if ("policy".equalsIgnoreCase(key)) {
                    this.policy = (String)entry.getValue();
                    continue;
                }
                if ("allowActions".equalsIgnoreCase(key)) {
                    this.allowActions = (String[])entry.getValue();
                    continue;
                }
                if ("secretType".equalsIgnoreCase(key)) {
                    this.secretType = (Integer)entry.getValue();
                    continue;
                }
                if (!"host".equalsIgnoreCase(key)) continue;
                this.host = (String)entry.getValue();
            }
        }
    }
}

