/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.polaris.factory.api;

import com.tencent.polaris.api.config.Configuration;
import com.tencent.polaris.api.exception.PolarisException;
import com.tencent.polaris.client.api.SDKContext;
import com.tencent.polaris.factory.ConfigAPIFactory;
import com.tencent.polaris.router.api.core.RouterAPI;
import com.tencent.polaris.router.client.api.DefaultRouterAPI;
import java.io.InputStream;

public class RouterAPIFactory {
    public static RouterAPI createRouterAPI() throws PolarisException {
        Configuration configuration = ConfigAPIFactory.defaultConfig();
        return RouterAPIFactory.createRouterAPIByConfig(configuration);
    }

    public static RouterAPI createRouterAPIByContext(SDKContext sdkContext) throws PolarisException {
        DefaultRouterAPI defaultEngineAPI = new DefaultRouterAPI(sdkContext);
        defaultEngineAPI.init();
        return defaultEngineAPI;
    }

    public static RouterAPI createRouterAPIByConfig(Configuration config) throws PolarisException {
        SDKContext context = SDKContext.initContextByConfig((Configuration)config);
        return RouterAPIFactory.createRouterAPIByContext(context);
    }

    public static RouterAPI createRouterAPIByFile(InputStream stream) throws PolarisException {
        Configuration configuration = ConfigAPIFactory.loadConfig((InputStream)stream);
        return RouterAPIFactory.createRouterAPIByConfig(configuration);
    }
}

