/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.polaris.plugins.router.nearby;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.tencent.polaris.api.config.verify.Verifier;
import com.tencent.polaris.api.plugin.route.LocationLevel;
import com.tencent.polaris.factory.util.ConfigUtils;

public class NearbyRouterConfig
implements Verifier {
    @JsonProperty
    private Boolean enableReportLocalAddress;
    @JsonProperty
    private LocationLevel matchLevel;
    @JsonProperty
    private LocationLevel maxMatchLevel;
    @JsonProperty
    private Boolean strictNearby;
    @JsonProperty
    private Boolean enableDegradeByUnhealthyPercent;
    @JsonProperty
    private Integer unhealthyPercentToDegrade;

    public LocationLevel getMatchLevel() {
        return this.matchLevel;
    }

    public void setMatchLevel(LocationLevel matchLevel) {
        this.matchLevel = matchLevel;
    }

    public LocationLevel getMaxMatchLevel() {
        return this.maxMatchLevel;
    }

    public void setMaxMatchLevel(LocationLevel maxMatchLevel) {
        this.maxMatchLevel = maxMatchLevel;
    }

    public Boolean isStrictNearby() {
        return this.strictNearby;
    }

    public void setStrictNearby(Boolean strictNearby) {
        this.strictNearby = strictNearby;
    }

    public Boolean isEnableDegradeByUnhealthyPercent() {
        return this.enableDegradeByUnhealthyPercent;
    }

    public void setEnableDegradeByUnhealthyPercent(Boolean enableDegradeByUnhealthyPercent) {
        this.enableDegradeByUnhealthyPercent = enableDegradeByUnhealthyPercent;
    }

    public Integer getUnhealthyPercentToDegrade() {
        return this.unhealthyPercentToDegrade;
    }

    public void setUnhealthyPercentToDegrade(Integer unhealthyPercentToDegrade) {
        this.unhealthyPercentToDegrade = unhealthyPercentToDegrade;
    }

    public Boolean isEnableReportLocalAddress() {
        return this.enableReportLocalAddress;
    }

    public void setEnableReportLocalAddress(Boolean enableReportLocalAddress) {
        this.enableReportLocalAddress = enableReportLocalAddress;
    }

    public void verify() {
        ConfigUtils.validateNull((Object)this.enableReportLocalAddress, (String)"enableReportLocalAddress");
        ConfigUtils.validateNull((Object)this.matchLevel, (String)"matchLevel");
        ConfigUtils.validateNull((Object)this.maxMatchLevel, (String)"matchLevel");
        if (this.matchLevel.ordinal() > this.maxMatchLevel.ordinal()) {
            throw new IllegalArgumentException("matchLevel should smaller than maxMatchLevel");
        }
        ConfigUtils.validateNull((Object)this.strictNearby, (String)"strictNearby");
        ConfigUtils.validateNull((Object)this.enableDegradeByUnhealthyPercent, (String)"enableDegradeByUnhealthyPercent");
        ConfigUtils.validatePositive((Integer)this.unhealthyPercentToDegrade, (String)"unhealthyPercentToDegrade");
        if (this.unhealthyPercentToDegrade > 100) {
            throw new IllegalArgumentException("unhealthyPercentToDegrade should less than or equals 100");
        }
    }

    public void setDefault(Object defaultObject) {
        if (null != defaultObject) {
            NearbyRouterConfig nearbyRouterConfig = (NearbyRouterConfig)defaultObject;
            if (null == this.enableReportLocalAddress) {
                this.setEnableReportLocalAddress(nearbyRouterConfig.isEnableReportLocalAddress());
            }
            if (null == this.matchLevel) {
                this.setMatchLevel(nearbyRouterConfig.getMatchLevel());
            }
            if (null == this.maxMatchLevel) {
                this.setMaxMatchLevel(nearbyRouterConfig.getMaxMatchLevel());
            }
            if (null == this.strictNearby) {
                this.setStrictNearby(nearbyRouterConfig.isStrictNearby());
            }
            if (null == this.enableDegradeByUnhealthyPercent) {
                this.setEnableDegradeByUnhealthyPercent(nearbyRouterConfig.isEnableDegradeByUnhealthyPercent());
            }
            if (null == this.unhealthyPercentToDegrade) {
                this.setUnhealthyPercentToDegrade(nearbyRouterConfig.getUnhealthyPercentToDegrade());
            }
        }
    }

    public String toString() {
        return "NearbyRouterConfig{enableReportLocalAddress=" + this.enableReportLocalAddress + ", matchLevel='" + this.matchLevel + '\'' + ", maxMatchLevel='" + this.maxMatchLevel + '\'' + ", strictNearby=" + this.strictNearby + ", enableDegradeByUnhealthyPercent=" + this.enableDegradeByUnhealthyPercent + ", unhealthyPercentToDegrade=" + this.unhealthyPercentToDegrade + '}';
    }
}

