/*
 * Decompiled with CFR 0.152.
 */
package com.qq.tars.maven.gensrc;

import com.qq.tars.maven.gensrc.Tars2JavaConfig;
import com.qq.tars.maven.parse.TarsLexer;
import com.qq.tars.maven.parse.TarsParser;
import com.qq.tars.maven.parse.ast.TarsConst;
import com.qq.tars.maven.parse.ast.TarsCustomType;
import com.qq.tars.maven.parse.ast.TarsEnum;
import com.qq.tars.maven.parse.ast.TarsInterface;
import com.qq.tars.maven.parse.ast.TarsKey;
import com.qq.tars.maven.parse.ast.TarsMapType;
import com.qq.tars.maven.parse.ast.TarsNamespace;
import com.qq.tars.maven.parse.ast.TarsOperation;
import com.qq.tars.maven.parse.ast.TarsParam;
import com.qq.tars.maven.parse.ast.TarsPrimitiveType;
import com.qq.tars.maven.parse.ast.TarsRoot;
import com.qq.tars.maven.parse.ast.TarsStruct;
import com.qq.tars.maven.parse.ast.TarsStructMember;
import com.qq.tars.maven.parse.ast.TarsType;
import com.qq.tars.maven.parse.ast.TarsVectorType;
import java.io.File;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.antlr.runtime.ANTLRFileStream;
import org.antlr.runtime.CharStream;
import org.antlr.runtime.CommonTokenStream;
import org.antlr.runtime.Token;
import org.antlr.runtime.TokenSource;
import org.antlr.runtime.TokenStream;
import org.antlr.runtime.tree.CommonTree;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="tars2java", threadSafe=true)
public class Tars2JavaMojo
extends AbstractMojo {
    @Parameter(required=true)
    private Tars2JavaConfig tars2JavaConfig;
    private AtomicInteger var = new AtomicInteger(0);

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (!this.tars2JavaConfig.packagePrefixName.endsWith(".")) {
            this.tars2JavaConfig.packagePrefixName = this.tars2JavaConfig.packagePrefixName + ".";
        }
        if (this.tars2JavaConfig.tarsFiles.length == 0) {
            this.getLog().error((CharSequence)"configuration tarsFiles is missing...");
            return;
        }
        HashMap<String, List<TarsNamespace>> nsMap = new HashMap<String, List<TarsNamespace>>();
        for (String tarsFile : this.tars2JavaConfig.tarsFiles) {
            try {
                this.getLog().info((CharSequence)("Parse " + tarsFile + " ..."));
                TarsLexer tarsLexer = new TarsLexer((CharStream)new ANTLRFileStream(tarsFile, this.tars2JavaConfig.tarsFileCharset));
                CommonTokenStream tokens = new CommonTokenStream((TokenSource)tarsLexer);
                TarsParser tarsParser = new TarsParser((TokenStream)tokens);
                TarsRoot root = (TarsRoot)((Object)tarsParser.start().getTree());
                root.setTokenStream(tokens);
                for (TarsNamespace ns : root.namespaceList()) {
                    ArrayList<TarsNamespace> list = (ArrayList<TarsNamespace>)nsMap.get(ns.namespace());
                    if (list == null) {
                        list = new ArrayList<TarsNamespace>();
                        nsMap.put(ns.namespace(), list);
                    }
                    list.add(ns);
                }
            }
            catch (Throwable th) {
                this.getLog().error((CharSequence)("Parse " + tarsFile + " Error!"), th);
            }
        }
        for (Map.Entry entry : nsMap.entrySet()) {
            try {
                this.getLog().info((CharSequence)("generate code for namespace : " + (String)entry.getKey() + " ..."));
                this.genJava((String)entry.getKey(), (List)entry.getValue(), nsMap);
            }
            catch (Throwable th) {
                this.getLog().error((CharSequence)("generate code for namespace : " + (String)entry.getKey() + " Error!"), th);
            }
        }
    }

    private String getDoc(CommonTree ast, String prefix) {
        CommonTokenStream ts = ((TarsRoot)ast.getAncestor(56)).getTokenStream();
        Token t = ts.get(ast.getTokenStartIndex() - 1);
        if (t != null && t.getChannel() == 99) {
            return prefix + t.getText().replaceAll("\n\\s*\\*", "\n" + prefix + " *");
        }
        return "";
    }

    private void genJava(String nsName, List<TarsNamespace> namespaces, Map<String, List<TarsNamespace>> nsMap) throws Exception {
        this.getLog().info((CharSequence)("module " + nsName + " >>"));
        String packageName = Tars2JavaMojo.packageName(this.tars2JavaConfig.packagePrefixName, nsName);
        String dirPath = this.tars2JavaConfig.srcPath + '/' + packageName.replace('.', '/') + "/";
        new File(dirPath).mkdirs();
        ArrayList<TarsConst> allConst = new ArrayList<TarsConst>();
        for (TarsNamespace namespace : namespaces) {
            allConst.addAll(namespace.constList());
        }
        if (!allConst.isEmpty()) {
            this.genConst(dirPath, packageName, nsName, allConst);
        }
        for (TarsNamespace ns : namespaces) {
            for (TarsEnum e : ns.enumList()) {
                this.genEnum(dirPath, packageName, ns.namespace(), e);
            }
        }
        for (TarsNamespace ns : namespaces) {
            for (TarsStruct s : ns.structList()) {
                this.genStruct(dirPath, packageName, ns.namespace(), s, ns.keyMap().get(s.structName()), nsMap);
            }
        }
        for (TarsNamespace ns : namespaces) {
            for (TarsInterface tarsInterface : ns.interfaceList()) {
                if (this.tars2JavaConfig.servant) {
                    this.genServant(dirPath, packageName, ns.namespace(), tarsInterface, nsMap);
                    continue;
                }
                this.genPrx(dirPath, packageName, ns.namespace(), tarsInterface, nsMap);
                this.genPrxCallback(dirPath, packageName, ns.namespace(), tarsInterface, nsMap);
            }
        }
        this.getLog().info((CharSequence)("module " + nsName + " <<"));
    }

    private void printHead(PrintWriter out) {
        out.println("// **********************************************************************");
        out.println("// This file was generated by a TARS parser!");
        out.println("// TARS version 1.7.2.");
        out.println("// **********************************************************************");
        out.println();
    }

    private void printDoc(PrintWriter out, String doc) {
        if (doc != null && doc.startsWith("/**") && doc.endsWith("*/")) {
            out.println(doc.substring(0, doc.length()));
        }
    }

    private void genConst(String dirPath, String packageName, String namespace, List<TarsConst> constList) throws Exception {
        String constClass = Tars2JavaMojo.firstUpStr(namespace) + "Const";
        PrintWriter out = new PrintWriter(dirPath + constClass + ".java", this.tars2JavaConfig.charset);
        this.printHead(out);
        out.println("package " + packageName + ";");
        out.println();
        out.println("public interface " + constClass + " {");
        for (TarsConst cn : constList) {
            out.println(this.getDoc(cn, "\t"));
            out.println("\tpublic static final " + this.type(cn.constType(), null) + " " + cn.constName() + " = " + cn.constValue() + ";");
        }
        out.println("}");
        out.close();
        this.getLog().info((CharSequence)("generate Const " + constClass));
    }

    private void genEnum(String dirPath, String packageName, String namespace, TarsEnum e) throws Exception {
        String enumClass = e.enumName();
        PrintWriter out = new PrintWriter(dirPath + enumClass + ".java", this.tars2JavaConfig.charset);
        this.printHead(out);
        out.println("package " + packageName + ";");
        out.println();
        this.printDoc(out, this.getDoc(e, ""));
        out.println("public enum " + enumClass + " {");
        out.println();
        for (int i = 0; i < e.enumMemberList().size(); ++i) {
            String item = e.enumMemberList().get(i);
            String value = i < e.enumValueList().size() ? e.enumValueList().get(i) : String.valueOf(i);
            out.print("\t" + item + "(" + value + ")");
            if (i < e.enumMemberList().size() - 1) {
                out.println(",");
                continue;
            }
            out.println(";");
        }
        out.println();
        out.println("\tprivate final int value;");
        out.println();
        out.println("\tprivate " + e.enumName() + "(int value) {");
        out.println("\t\tthis.value = value;");
        out.println("\t}");
        out.println();
        out.println("\tpublic int value() {");
        out.println("\t\treturn this.value;");
        out.println("\t}");
        out.println();
        out.println("\t@Override");
        out.println("\tpublic String toString() {");
        out.println("\t\treturn this.name() + \":\" + this.value;");
        out.println("\t}");
        out.println();
        out.println("\tpublic static " + e.enumName() + " convert(int value) {");
        out.println("\t\tfor(" + e.enumName() + " v : values()) {");
        out.println("\t\t\tif(v.value() == value) {");
        out.println("\t\t\t\treturn v;");
        out.println("\t\t\t}");
        out.println("\t\t}");
        out.println("\t\treturn null;");
        out.println("\t}");
        out.println("}");
        out.close();
        this.getLog().info((CharSequence)("generate Enum " + enumClass));
    }

    private void genStruct(String dirPath, String packageName, String namespace, TarsStruct struct, TarsKey key, Map<String, List<TarsNamespace>> nsMap) throws Exception {
        int i;
        String k2;
        String structClass = struct.structName();
        PrintWriter out = new PrintWriter(dirPath + structClass + ".java", this.tars2JavaConfig.charset);
        this.printHead(out);
        out.println("package " + packageName + ";");
        out.println();
        out.println("import com.qq.tars.protocol.util.*;");
        out.println("import com.qq.tars.protocol.annotation.*;");
        out.println("import com.qq.tars.protocol.tars.*;");
        out.println("import com.qq.tars.protocol.tars.annotation.*;");
        out.println();
        this.printDoc(out, this.getDoc(struct, ""));
        out.println("@TarsStruct");
        if (key == null) {
            out.println("public class " + struct.structName() + " {");
        } else {
            out.println("public class " + struct.structName() + " implements Comparable<" + struct.structName() + "> {");
        }
        out.println();
        for (TarsStructMember m : struct.memberList()) {
            String defaultValue;
            out.println("\t@TarsStructProperty(order = " + m.tag() + ", isRequire = " + m.isRequire() + ")");
            String string = defaultValue = m.defaultValue() == null ? this.typeInit(m.memberType(), nsMap, false) : m.defaultValue();
            if (m.memberType().isPrimitive()) {
                TarsPrimitiveType primitiveType = m.memberType().asPrimitive();
                if (primitiveType.primitiveType().equals((Object)TarsPrimitiveType.PrimitiveType.LONG)) {
                    if (!defaultValue.endsWith("l") && !defaultValue.endsWith("L")) {
                        defaultValue = defaultValue + "L";
                    }
                } else if (primitiveType.primitiveType().equals((Object)TarsPrimitiveType.PrimitiveType.FLOAT)) {
                    if (!defaultValue.endsWith("f") && !defaultValue.endsWith("F")) {
                        defaultValue = defaultValue + "F";
                    }
                } else if (primitiveType.primitiveType().equals((Object)TarsPrimitiveType.PrimitiveType.DOUBLE) && !defaultValue.endsWith("d") && !defaultValue.endsWith("D")) {
                    defaultValue = defaultValue + "D";
                }
            }
            out.println("\tpublic " + this.type(m.memberType(), nsMap) + " " + m.memberName() + " = " + defaultValue + ";");
        }
        out.println();
        for (TarsStructMember m : struct.memberList()) {
            out.println("\tpublic " + this.type(m.memberType(), nsMap) + " " + Tars2JavaMojo.fieldGetter(m.memberName(), m.memberType()) + "() {");
            out.println("\t\treturn " + m.memberName() + ";");
            out.println("\t}");
            out.println();
            out.println("\tpublic void " + Tars2JavaMojo.fieldSetter(m.memberName(), m.memberType()) + "(" + this.type(m.memberType(), nsMap) + " " + m.memberName() + ") {");
            out.println("\t\tthis." + m.memberName() + " = " + m.memberName() + ";");
            out.println("\t}");
            out.println();
        }
        out.println("\tpublic " + struct.structName() + "() {");
        out.println("\t}");
        out.println();
        out.print("\tpublic " + struct.structName() + "(");
        for (int i2 = 0; i2 < struct.memberList().size(); ++i2) {
            TarsStructMember m;
            m = struct.memberList().get(i2);
            out.print(this.type(m.memberType(), nsMap) + " " + m.memberName());
            if (i2 >= struct.memberList().size() - 1) continue;
            out.print(", ");
        }
        out.println(") {");
        for (TarsStructMember m : struct.memberList()) {
            out.println("\t\tthis." + m.memberName() + " = " + m.memberName() + ";");
        }
        out.println("\t}");
        out.println();
        if (key != null) {
            out.println("\t@Override");
            out.println("\tpublic int compareTo(" + struct.structName() + " o) {");
            out.println("\t\tint c = 0;");
            for (String k2 : key.keyList()) {
                out.println("\t\tif((c = TarsUtil.compareTo(" + k2 + ", o." + k2 + ")) != 0 ) {");
                out.println("\t\t\treturn c;");
                out.println("\t\t}");
            }
            out.println("\t\treturn 0;");
            out.println("\t}");
            out.println();
        }
        if (key != null) {
            out.println();
            out.println("\t@Override");
            out.println("\tpublic int hashCode() {");
            out.println("\t\tfinal int prime = 31;");
            out.println("\t\tint result = 1;");
            for (int i3 = 0; i3 < key.keyList().size(); ++i3) {
                k2 = key.keyList().get(i3);
                out.println("\t\tresult = prime * result + TarsUtil.hashCode(" + k2 + ");");
            }
            out.println("\t\treturn result;");
            out.println("\t}");
            out.println();
        } else {
            out.println("\t@Override");
            out.println("\tpublic int hashCode() {");
            out.println("\t\tfinal int prime = 31;");
            out.println("\t\tint result = 1;");
            for (TarsStructMember m : struct.memberList()) {
                out.println("\t\tresult = prime * result + TarsUtil.hashCode(" + m.memberName() + ");");
            }
            out.println("\t\treturn result;");
            out.println("\t}");
            out.println();
        }
        out.println("\t@Override");
        out.println("\tpublic boolean equals(Object obj) {");
        out.println("\t\tif (this == obj) {");
        out.println("\t\t\treturn true;");
        out.println("\t\t}");
        out.println("\t\tif (obj == null) {");
        out.println("\t\t\treturn false;");
        out.println("\t\t}");
        out.println("\t\tif (!(obj instanceof " + struct.structName() + ")) {");
        out.println("\t\t\treturn false;");
        out.println("\t\t}");
        out.println("\t\t" + struct.structName() + " other = (" + struct.structName() + ") obj;");
        out.println("\t\treturn (");
        if (key != null) {
            for (i = 0; i < key.keyList().size(); ++i) {
                k2 = key.keyList().get(i);
                out.println("\t\t\tTarsUtil.equals(" + k2 + ", other." + k2 + ") " + (i < key.keyList().size() - 1 ? "&&" : ""));
            }
        } else {
            for (i = 0; i < struct.memberList().size(); ++i) {
                k2 = struct.memberList().get(i).memberName();
                out.println("\t\t\tTarsUtil.equals(" + k2 + ", other." + k2 + ") " + (i < struct.memberList().size() - 1 ? "&&" : ""));
            }
        }
        out.println("\t\t);");
        out.println("\t}");
        out.println();
        out.println("\t@Override");
        out.println("\tpublic String toString() {");
        out.println("\t\tStringBuilder sb = new StringBuilder(\"" + struct.structName() + "(\");");
        boolean first = true;
        for (TarsStructMember m : struct.memberList()) {
            if (!first) {
                out.println("\t\tsb.append(\", \");");
            }
            out.println("\t\tsb.append(\"" + m.memberName() + ":\");");
            boolean canBeNull = this.typeCanBeNull(m.memberType(), nsMap);
            if (canBeNull) {
                out.println("\t\tif (this." + m.memberName() + " == null) {");
                out.println("\t\t\tsb.append(\"null\");");
                out.println("\t\t} else {");
                out.print("\t");
            }
            out.println("\t\tsb.append(this." + m.memberName() + ");");
            if (canBeNull) {
                out.println("\t\t}");
            }
            first = false;
        }
        out.println("\t\tsb.append(\")\");");
        out.println("\t\treturn sb.toString();");
        out.println("\t}");
        out.println();
        out.println("\tpublic void writeTo(TarsOutputStream _os) {");
        for (TarsStructMember m : struct.memberList()) {
            if (!m.isRequire()) {
                if (m.memberType().isPrimitive() || this.isEnum(m.memberType(), nsMap)) {
                    TarsPrimitiveType primitiveType = m.memberType().asPrimitive();
                    if (primitiveType != null && primitiveType.primitiveType().equals((Object)TarsPrimitiveType.PrimitiveType.STRING)) {
                        out.println("\t\tif (null != " + m.memberName() + ") {");
                        out.println("\t\t\t_os.write(" + m.memberName() + ", " + m.tag() + ");");
                        out.println("\t\t}");
                        continue;
                    }
                    out.println("\t\t_os.write(" + m.memberName() + ", " + m.tag() + ");");
                    continue;
                }
                out.println("\t\tif (null != " + m.memberName() + ") {");
                out.println("\t\t\t_os.write(" + m.memberName() + ", " + m.tag() + ");");
                out.println("\t\t}");
                continue;
            }
            out.println("\t\t_os.write(" + m.memberName() + ", " + m.tag() + ");");
        }
        out.println("\t}");
        out.println();
        for (TarsStructMember m : struct.memberList()) {
            boolean isenum = this.isEnum(m.memberType(), nsMap);
            if ((isenum || !m.memberType().isCustom()) && !m.memberType().isMap() && !m.memberType().isVector()) continue;
            String memberName = "cache_" + m.memberName();
            out.println("\tstatic " + this.type(m.memberType(), true, nsMap) + " " + memberName + ";");
            out.println("\tstatic { ");
            this.genCacheVar(memberName, true, m.memberType(), nsMap, out);
            out.println("\t}");
        }
        out.println();
        out.println("\tpublic void readFrom(TarsInputStream _is) {");
        for (TarsStructMember m : struct.memberList()) {
            String type = null;
            boolean isenum = this.isEnum(m.memberType(), nsMap);
            if (!isenum && m.memberType().isCustom() || m.memberType().isMap() || m.memberType().isVector()) {
                type = this.type(m.memberType(), nsMap);
                out.println("\t\tthis." + m.memberName() + " = " + (type == null ? "" : "(" + type + ") ") + "_is.read(cache_" + m.memberName() + ", " + m.tag() + ", " + m.isRequire() + ");");
                continue;
            }
            if (m.memberType().isPrimitive()) {
                TarsPrimitiveType primitiveType = m.memberType().asPrimitive();
                if (primitiveType.primitiveType().equals((Object)TarsPrimitiveType.PrimitiveType.STRING)) {
                    out.println("\t\tthis." + m.memberName() + " = _is.readString(" + m.tag() + ", " + m.isRequire() + ");");
                    continue;
                }
                out.println("\t\tthis." + m.memberName() + " = " + (type == null ? "" : "(" + type + ") ") + "_is.read(" + m.memberName() + ", " + m.tag() + ", " + m.isRequire() + ");");
                continue;
            }
            out.println("\t\tthis." + m.memberName() + " = " + (type == null ? "" : "(" + type + ") ") + "_is.read(" + m.memberName() + ", " + m.tag() + ", " + m.isRequire() + ");");
        }
        out.println("\t}");
        out.println();
        out.println("}");
        out.close();
        this.getLog().info((CharSequence)("generate Struct " + structClass));
    }

    private String adaptDefaultValue(TarsStructMember m) {
        String typeSuffix = "";
        if (m.memberType().isPrimitive()) {
            TarsPrimitiveType.PrimitiveType type = m.memberType().asPrimitive().primitiveType();
            switch (type) {
                case FLOAT: {
                    typeSuffix = "F";
                    break;
                }
                case DOUBLE: {
                    typeSuffix = "D";
                    break;
                }
                case LONG: {
                    typeSuffix = "L";
                }
            }
        }
        return m.defaultValue() + typeSuffix;
    }

    private void genCacheVar(String memberName, boolean hasDeclare, TarsType type, Map<String, List<TarsNamespace>> nsMap, PrintWriter out) {
        if (type.isCustom() && !this.isEnum(type, nsMap)) {
            out.println("\t\t" + (hasDeclare ? memberName : this.type(type, true, nsMap) + " " + memberName) + " = new " + this.type(type, true, nsMap) + "();");
        } else if (type.isMap()) {
            TarsMapType mapType = type.asMap();
            out.println("\t\t" + (hasDeclare ? memberName : this.type(type, true, nsMap) + " " + memberName) + " = new java.util.HashMap<" + this.type(mapType.keyType(), true, nsMap) + ", " + this.type(mapType.valueType(), true, nsMap) + ">();");
            String varkey = "var_" + this.var.incrementAndGet();
            String varval = "var_" + this.var.incrementAndGet();
            this.genCacheVar(varkey, false, mapType.keyType(), nsMap, out);
            this.genCacheVar(varval, false, mapType.valueType(), nsMap, out);
            out.println("\t\t" + memberName + ".put(" + varkey + " ," + varval + ");");
        } else if (type.isVector()) {
            TarsVectorType v = type.asVector();
            String varType = "var_" + this.var.incrementAndGet();
            if (v.isByteArray()) {
                out.println("\t\t" + (hasDeclare ? memberName : this.type(type, false, nsMap) + " " + memberName) + " = new " + this.type(v.subType(), false, nsMap) + "[1];");
                this.genCacheVar(varType, false, v.subType(), nsMap, out);
                out.println("\t\t" + memberName + "[0] = " + varType + ";");
            } else {
                out.println("\t\t" + (hasDeclare ? memberName : this.type(type, true, nsMap) + " " + memberName) + " = new java.util.ArrayList<" + this.type(v.subType(), true, nsMap) + ">();");
                this.genCacheVar(varType, false, v.subType(), nsMap, out);
                out.println("\t\t" + memberName + ".add(" + varType + ");");
            }
        } else if (type.isPrimitive()) {
            out.println("\t\t" + (hasDeclare ? memberName : this.type(type, false, nsMap) + " " + memberName) + " = " + this.typeInit(type, nsMap, true) + ";");
        } else if (this.isEnum(type, nsMap)) {
            out.println("\t\t" + (hasDeclare ? memberName : this.type(type, false, nsMap) + " " + memberName) + " = " + this.typeInit(type, nsMap, true) + ";");
        }
    }

    public void genPrx(String dirPath, String packageName, String namespace, TarsInterface _interface, Map<String, List<TarsNamespace>> nsMap) throws Exception {
        String prxClass = _interface.interfaceName() + "Prx";
        PrintWriter out = new PrintWriter(dirPath + prxClass + ".java", this.tars2JavaConfig.charset);
        this.printHead(out);
        out.println("package " + packageName + ";");
        out.println();
        out.println("import com.qq.tars.protocol.annotation.*;");
        out.println("import com.qq.tars.protocol.tars.annotation.*;");
        out.println("import com.qq.tars.common.support.Holder;");
        out.println("import java.util.concurrent.CompletableFuture;");
        out.println();
        this.printDoc(out, this.getDoc(_interface, ""));
        out.println("@Servant");
        out.println("public interface " + prxClass + " {");
        for (TarsOperation op : _interface.operationList()) {
            out.println(this.getDoc(op, "\t"));
            out.println("\t " + this.type(op.retType(), nsMap) + " " + op.operationName() + "(" + this.operationParams(null, op.paramList(), null, true, nsMap) + ");");
            out.println(this.getDoc(op, "\t"));
            out.println("\t " + this.type(op.retType(), nsMap) + " " + op.operationName() + "(" + this.operationParams(null, op.paramList(), Arrays.asList("@TarsContext java.util.Map<String, String> ctx"), true, nsMap) + ");");
            out.println(this.getDoc(op, "\t"));
            out.println("\t void async_" + op.operationName() + "(" + this.operationParams(Arrays.asList("@TarsCallback " + prxClass + "Callback callback"), op.paramList(), null, false, nsMap) + ");");
            out.println(this.getDoc(op, "\t"));
            out.println("\t void async_" + op.operationName() + "(" + this.operationParams(Arrays.asList("@TarsCallback " + prxClass + "Callback callback"), op.paramList(), Arrays.asList("@TarsContext java.util.Map<String, String> ctx"), false, nsMap) + ");");
            out.println(this.getDoc(op, "\t"));
            out.println("\t CompletableFuture<" + this.type(op.retType(), true, nsMap) + ">  promise_" + op.operationName() + "(" + this.operationParams(null, op.paramList(), null, true, nsMap) + ");");
            out.println(this.getDoc(op, "\t"));
            out.println("\t CompletableFuture<" + this.type(op.retType(), true, nsMap) + ">  promise_" + op.operationName() + "(" + this.operationParams(null, op.paramList(), Arrays.asList("@TarsContext java.util.Map<String, String> ctx"), true, nsMap) + ");");
        }
        out.println("}");
        out.close();
        this.getLog().info((CharSequence)("generate Prx " + prxClass));
    }

    public void genServant(String dirPath, String packageName, String namespace, TarsInterface _interface, Map<String, List<TarsNamespace>> nsMap) throws Exception {
        String prxClass = _interface.interfaceName() + "Servant";
        PrintWriter out = new PrintWriter(dirPath + prxClass + ".java", this.tars2JavaConfig.charset);
        this.printHead(out);
        out.println("package " + packageName + ";");
        out.println();
        out.println("import com.qq.tars.protocol.annotation.*;");
        out.println("import com.qq.tars.protocol.tars.annotation.*;");
        out.println("import com.qq.tars.common.support.Holder;");
        out.println();
        this.printDoc(out, this.getDoc(_interface, ""));
        out.println("@Servant");
        out.println("public interface " + prxClass + " {");
        for (TarsOperation op : _interface.operationList()) {
            out.println(this.getDoc(op, "\t"));
            out.println("\t " + this.type(op.retType(), nsMap) + " " + op.operationName() + "(" + this.operationParams(null, op.paramList(), null, true, nsMap) + ");");
        }
        out.println("}");
        out.close();
        this.getLog().info((CharSequence)("generate Servant " + prxClass));
    }

    public void genPrxCallback(String dirPath, String packageName, String namespace, TarsInterface tarsInterface, Map<String, List<TarsNamespace>> nsMap) throws Exception {
        String prxClass = tarsInterface.interfaceName() + "PrxCallback";
        PrintWriter out = new PrintWriter(dirPath + prxClass + ".java", this.tars2JavaConfig.charset);
        this.printHead(out);
        out.println("package " + packageName + ";");
        out.println();
        out.println("import com.qq.tars.rpc.protocol.tars.support.TarsAbstractCallback;");
        out.println();
        this.printDoc(out, this.getDoc(tarsInterface, ""));
        out.println("public abstract class " + prxClass + " extends TarsAbstractCallback {");
        out.println();
        for (TarsOperation op : tarsInterface.operationList()) {
            String type = this.type(op.retType(), false, nsMap);
            if ("void".equals(type) || "Void".equals(type)) {
                out.println("\tpublic abstract void callback_" + op.operationName() + "(" + this.operationCallBackParams(null, op.paramList(), null, nsMap) + ");");
            } else {
                out.println("\tpublic abstract void callback_" + op.operationName() + "(" + this.operationCallBackParams(Arrays.asList(type + " ret"), op.paramList(), null, nsMap) + ");");
            }
            out.println();
        }
        out.println("}");
        out.close();
        this.getLog().info((CharSequence)("generate Prx " + prxClass));
    }

    private String type(TarsType jt, Map<String, List<TarsNamespace>> nsMap) {
        return this.type(jt, false, nsMap);
    }

    private String type(TarsType jt, boolean usePrimitiveWrapper, Map<String, List<TarsNamespace>> nsMap) {
        if (jt.isPrimitive()) {
            TarsPrimitiveType p = jt.asPrimitive();
            if (!usePrimitiveWrapper) {
                switch (p.primitiveType()) {
                    case VOID: {
                        return "void";
                    }
                    case BOOL: {
                        return "boolean";
                    }
                    case BYTE: {
                        return "byte";
                    }
                    case SHORT: {
                        return "short";
                    }
                    case INT: {
                        return "int";
                    }
                    case LONG: {
                        return "long";
                    }
                    case FLOAT: {
                        return "float";
                    }
                    case DOUBLE: {
                        return "double";
                    }
                    case STRING: {
                        return "String";
                    }
                }
                return "";
            }
            switch (p.primitiveType()) {
                case VOID: {
                    return "Void";
                }
                case BOOL: {
                    return "java.lang.Boolean";
                }
                case BYTE: {
                    return "java.lang.Byte";
                }
                case SHORT: {
                    return "java.lang.Short";
                }
                case INT: {
                    return "java.lang.Integer";
                }
                case LONG: {
                    return "java.lang.Long";
                }
                case FLOAT: {
                    return "java.lang.Float";
                }
                case DOUBLE: {
                    return "java.lang.Double";
                }
                case STRING: {
                    return "String";
                }
            }
            return "";
        }
        if (jt.isVector()) {
            TarsVectorType v = jt.asVector();
            if (v.isByteArray()) {
                return "byte[]";
            }
            return "java.util.List<" + this.type(v.subType(), true, nsMap) + ">";
        }
        if (jt.isMap()) {
            TarsMapType m = jt.asMap();
            return "java.util.Map<" + this.type(m.keyType(), true, nsMap) + ", " + this.type(m.valueType(), true, nsMap) + ">";
        }
        if (jt.isCustom()) {
            boolean isEnum;
            TarsCustomType ct = jt.asCustom();
            boolean bl = isEnum = nsMap != null ? this.isEnum(jt, nsMap) : false;
            if (isEnum) {
                if (!usePrimitiveWrapper) {
                    return "int";
                }
                return "java.lang.Integer";
            }
            if (ct.namespace() == null) {
                return ct.typeName();
            }
            return Tars2JavaMojo.packageName(this.tars2JavaConfig.packagePrefixName, ct.namespace()) + "." + ct.typeName();
        }
        return "";
    }

    private boolean isEnum(TarsType jt, Map<String, List<TarsNamespace>> nsMap) {
        ArrayList<TarsEnum> allEnum = new ArrayList<TarsEnum>();
        for (Map.Entry<String, List<TarsNamespace>> entry : nsMap.entrySet()) {
            for (TarsNamespace namespace : entry.getValue()) {
                allEnum.addAll(namespace.enumList());
            }
        }
        if (!allEnum.isEmpty()) {
            for (TarsEnum tarsEnum : allEnum) {
                if (!jt.typeName().equals(tarsEnum.enumName())) continue;
                return true;
            }
        }
        return false;
    }

    private boolean typeCanBeNull(TarsType jt, Map<String, List<TarsNamespace>> nsMap) {
        TarsPrimitiveType primitiveType;
        boolean canBeNull = true;
        if (jt.isCustom()) {
            boolean isEnum;
            boolean bl = isEnum = nsMap != null ? this.isEnum(jt, nsMap) : false;
            if (isEnum) {
                canBeNull = false;
            }
        }
        if (jt.isPrimitive() && (primitiveType = jt.asPrimitive()) != null && !primitiveType.primitiveType().equals((Object)TarsPrimitiveType.PrimitiveType.STRING)) {
            canBeNull = false;
        }
        return canBeNull;
    }

    private String typeInit(TarsType jt, Map<String, List<TarsNamespace>> nsMap, boolean useDefault) {
        if (!useDefault) {
            if (jt.isPrimitive()) {
                TarsPrimitiveType p = jt.asPrimitive();
                switch (p.primitiveType()) {
                    case VOID: {
                        return "";
                    }
                    case BOOL: {
                        return "false";
                    }
                    case BYTE: {
                        return "(byte)0";
                    }
                    case SHORT: {
                        return "(short)0";
                    }
                    case INT: {
                        return "0";
                    }
                    case LONG: {
                        return "0L";
                    }
                    case FLOAT: {
                        return "0F";
                    }
                    case DOUBLE: {
                        return "0D";
                    }
                    case STRING: {
                        return "\"\"";
                    }
                }
                return "";
            }
            return nsMap != null && this.isEnum(jt, nsMap) ? "0" : "null";
        }
        if (jt.isPrimitive()) {
            TarsPrimitiveType p = jt.asPrimitive();
            switch (p.primitiveType()) {
                case VOID: {
                    return "";
                }
                case BOOL: {
                    return "false";
                }
                case BYTE: {
                    return "(byte)0";
                }
                case SHORT: {
                    return "(short)0";
                }
                case INT: {
                    return "0";
                }
                case LONG: {
                    return "0L";
                }
                case FLOAT: {
                    return "0F";
                }
                case DOUBLE: {
                    return "0D";
                }
                case STRING: {
                    return "\"\"";
                }
            }
            return "";
        }
        if (jt.isVector()) {
            TarsVectorType v = jt.asVector();
            if (v.isByteArray()) {
                return "new byte[1]";
            }
            return "new java.util.ArrayList<" + this.type(v.subType(), true, nsMap) + ">()";
        }
        if (jt.isMap()) {
            TarsMapType m = jt.asMap();
            return "new java.util.HashMap<" + this.type(m.keyType(), true, nsMap) + ", " + this.type(m.valueType(), true, nsMap) + ">()";
        }
        if (jt.isCustom()) {
            boolean isEnum;
            TarsCustomType ct = jt.asCustom();
            boolean bl = isEnum = nsMap != null ? this.isEnum(jt, nsMap) : false;
            if (isEnum) {
                return "0";
            }
            if (ct.namespace() == null) {
                return "new " + ct.typeName() + "()";
            }
            return "new " + Tars2JavaMojo.packageName(this.tars2JavaConfig.packagePrefixName, ct.namespace()) + "." + ct.typeName() + "()";
        }
        return "";
    }

    public String operationCallBackParams(List<String> beforeParams, List<TarsParam> paramList, List<String> afterParams, Map<String, List<TarsNamespace>> nsMap) {
        StringBuilder sb = new StringBuilder();
        boolean isFirst = true;
        if (beforeParams != null) {
            for (String other : beforeParams) {
                if (isFirst) {
                    isFirst = false;
                } else {
                    sb.append(", ");
                }
                sb.append(other);
            }
        }
        for (TarsParam p : paramList) {
            if (!p.isOut()) continue;
            sb.append(isFirst ? "" : ", ");
            sb.append(this.type(p.paramType(), nsMap)).append(" ").append(p.paramName());
            if (!isFirst) continue;
            isFirst = false;
        }
        if (afterParams != null) {
            for (String other : afterParams) {
                if (isFirst) {
                    isFirst = false;
                } else {
                    sb.append(", ");
                }
                sb.append(other);
            }
        }
        return sb.toString();
    }

    public String operationParams(List<String> beforeParams, List<TarsParam> paramList, List<String> afterParams, boolean isSync, Map<String, List<TarsNamespace>> nsMap) {
        StringBuilder sb = new StringBuilder();
        boolean isFirst = true;
        if (beforeParams != null) {
            for (String other : beforeParams) {
                if (isFirst) {
                    isFirst = false;
                } else {
                    sb.append(", ");
                }
                sb.append(other);
            }
        }
        for (TarsParam p : paramList) {
            if (!isSync && p.isOut()) continue;
            if (p.isOut()) {
                sb.append(isFirst ? "" : ", ");
                sb.append("@TarsHolder(name=\"").append(p.paramName()).append("\") Holder<").append(this.type(p.paramType(), true, nsMap)).append("> ").append(p.paramName());
            } else {
                sb.append(isFirst ? "" : ", ");
                if (p.isRouteKey()) {
                    sb.append("@TarsRouteKey ");
                }
                sb.append("@TarsMethodParameter(name=\"").append(p.paramName()).append("\")").append(this.type(p.paramType(), nsMap)).append(" ").append(p.paramName());
            }
            if (!isFirst) continue;
            isFirst = false;
        }
        if (afterParams != null) {
            for (String other : afterParams) {
                if (isFirst) {
                    isFirst = false;
                } else {
                    sb.append(", ");
                }
                sb.append(other);
            }
        }
        return sb.toString();
    }

    private static String firstUpStr(String str) {
        if (str == null || str.length() < 1) {
            return str;
        }
        return str.substring(0, 1).toUpperCase() + str.substring(1);
    }

    private static String packageName(String packagePrefixName, String namespace) {
        if (!packagePrefixName.endsWith(".")) {
            packagePrefixName = packagePrefixName + ".";
        }
        return packagePrefixName + namespace.toLowerCase();
    }

    public static String fieldGetter(String fieldName, TarsType type) {
        if (type.isPrimitive() && type.asPrimitive().primitiveType() == TarsPrimitiveType.PrimitiveType.BOOL) {
            if (!fieldName.startsWith("is")) {
                return "is" + Tars2JavaMojo.firstUpStr(fieldName);
            }
            if (fieldName.length() <= 2) {
                return "is" + Tars2JavaMojo.firstUpStr(fieldName);
            }
            String third = fieldName.substring(2, 3);
            if (third.toUpperCase().equals(third)) {
                return fieldName;
            }
            return "is" + Tars2JavaMojo.firstUpStr(fieldName);
        }
        return "get" + Tars2JavaMojo.firstUpStr(fieldName);
    }

    public static String fieldSetter(String fieldName, TarsType type) {
        if (type.isPrimitive() && type.asPrimitive().primitiveType() == TarsPrimitiveType.PrimitiveType.BOOL) {
            if (!fieldName.startsWith("is")) {
                return "set" + Tars2JavaMojo.firstUpStr(fieldName);
            }
            if (fieldName.length() <= 2) {
                return "set" + Tars2JavaMojo.firstUpStr(fieldName);
            }
            String third = fieldName.substring(2, 3);
            if (third.toUpperCase().equals(third)) {
                return "set" + Tars2JavaMojo.firstUpStr(fieldName.substring(2));
            }
            return "set" + Tars2JavaMojo.firstUpStr(fieldName);
        }
        return "set" + Tars2JavaMojo.firstUpStr(fieldName);
    }
}

