/*
 * Decompiled with CFR 0.152.
 */
package com.qq.tars.maven.gensrc;

import com.qq.tars.maven.gensrc.Servant;
import com.qq.tars.maven.model.Dependency;
import com.qq.tars.maven.script.Platform;
import com.qq.tars.maven.util.ArchiveEntryUtils;
import com.qq.tars.maven.util.XMLConfigElement;
import com.qq.tars.maven.util.XMLConfigFile;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Writer;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.metadata.ArtifactMetadataSource;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.repository.ArtifactRepositoryFactory;
import org.apache.maven.artifact.repository.layout.ArtifactRepositoryLayout;
import org.apache.maven.artifact.resolver.ArtifactCollector;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.artifact.resolver.filter.ScopeArtifactFilter;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Execute;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectBuilder;
import org.apache.maven.shared.dependency.tree.DependencyNode;
import org.apache.maven.shared.dependency.tree.DependencyTreeBuilder;
import org.apache.maven.shared.mapping.MappingUtils;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.UnArchiver;
import org.codehaus.plexus.archiver.manager.ArchiverManager;
import org.codehaus.plexus.archiver.manager.NoSuchArchiverException;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.codehaus.plexus.context.Context;
import org.codehaus.plexus.context.ContextException;
import org.codehaus.plexus.interpolation.InterpolationException;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Contextualizable;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.InterpolationFilterReader;

@Mojo(name="build", defaultPhase=LifecyclePhase.PACKAGE, requiresDependencyResolution=ResolutionScope.RUNTIME, threadSafe=true)
@Execute(phase=LifecyclePhase.PACKAGE)
public class TarsBuildMojo
extends AbstractMojo
implements Contextualizable {
    @Parameter(defaultValue="${project}")
    private MavenProject project;
    @Parameter(defaultValue="${session}")
    private MavenSession session;
    @Parameter(alias="", defaultValue="${project.build.directory}/${project.build.finalName}")
    private File war;
    @Parameter
    protected String outputFileNameMapping;
    @Parameter(defaultValue="default")
    protected String repositoryLayout;
    @Parameter(defaultValue="false")
    protected boolean useTimestampInSnapshotFileName;
    @Parameter(defaultValue="${localRepository}", readonly=true, required=true)
    protected ArtifactRepository localRepository;
    @Parameter(defaultValue="${project.remoteArtifactRepositories}", readonly=true, required=true)
    protected List remoteRepositories;
    @Component
    private ArtifactFactory artifactFactory;
    @Component
    protected ArtifactResolver artifactResolver;
    @Component
    protected ArtifactRepositoryFactory artifactRepositoryFactory;
    @Component
    protected ArtifactMetadataSource artifactMetadataSource;
    @Component
    protected MavenProjectBuilder mavenProjectBuilder;
    @Component
    protected DependencyTreeBuilder dependencyTreeBuilder;
    @Component
    protected ArtifactCollector artifactCollector;
    @Component
    protected ArchiverManager archiverManager;
    protected PlexusContainer container;
    @Parameter
    private String platformName;
    @Parameter
    private String tarsGroupId;
    @Parameter
    private String tarsArtifactId;
    @Parameter
    private String tarsVersion;
    private static final String TARS_PROTOCOL = "tars";
    private static final String TUP_PROTOCOL = "tup";
    private static final String MAIN_CLASS = "com.qq.tars.server.startup.Main";
    protected static final String SCOPE_DEFAULT_PATTERN = "^((?!test).)*$";
    private String includedScope = "^((?!test).)*$";
    private List<Dependency> dependencyList = new ArrayList<Dependency>();
    private Pattern pattern;

    public void contextualize(Context context) throws ContextException {
        this.container = (PlexusContainer)context.get((Object)"plexus");
    }

    protected boolean includedScope(String scope) {
        if (this.pattern == null) {
            this.pattern = Pattern.compile(this.includedScope, 2);
        }
        return scope != null ? this.pattern.matcher(scope).matches() : Boolean.TRUE.booleanValue();
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.getLog().info((CharSequence)"Start run build...");
        try {
            File targetDir;
            File tarsDir;
            if (this.platformName == null) {
                String osName = System.getProperty("os.name");
                this.platformName = osName.toLowerCase().contains("windows") ? "windows" : "unix";
            }
            if ((tarsDir = new File(targetDir = new File(this.project.getBuild().getDirectory()), TARS_PROTOCOL)).exists()) {
                FileUtils.forceDelete((File)tarsDir);
            }
            tarsDir.mkdir();
            File binDir = new File(tarsDir, "bin");
            binDir.mkdir();
            File confDir = new File(tarsDir, "conf");
            confDir.mkdir();
            File dataDir = new File(tarsDir, "data");
            dataDir.mkdir();
            File binAppsDir = new File(binDir, "apps" + File.separator + "ROOT");
            binAppsDir.mkdir();
            FileUtils.copyDirectory((File)this.war, (File)binAppsDir);
            File binConfDir = new File(binDir, "conf");
            binConfDir.mkdir();
            File binLogDir = new File(binDir, "log");
            binLogDir.mkdir();
            File libDir = new File(binDir, "lib");
            libDir.mkdir();
            String app = this.getApp();
            String server = this.getServer();
            if (app == null || server == null) {
                throw new MojoExecutionException("Failed to build app server is null.");
            }
            String configFileName = String.format("%s.%s.%s", app, server, "config.conf");
            File configFile = new File(confDir, configFileName);
            this.getLog().info((CharSequence)String.format("Create config file %s ", configFile.getCanonicalPath()));
            this.createConfigScript(binDir, dataDir, binLogDir, configFile);
            this.installLibDependency(libDir);
            this.getLog().info((CharSequence)String.format("Create platform %s start script...", this.platformName));
            Platform platform = Platform.getInstance(this.platformName);
            String binscript = this.createBinScript(platform, libDir, binDir, configFile);
            this.getLog().info((CharSequence)("Start Script in " + binscript));
        }
        catch (Exception e) {
            this.getLog().error((Throwable)e);
            throw new MojoExecutionException("Failed to tars build", e);
        }
    }

    private void installLibDependency(File libDir) throws Exception {
        ArtifactRepository artifactRepository = this.getArtifactRepository(libDir.getAbsolutePath());
        this.getLog().info((CharSequence)"Install tars artifact...");
        Set projectDependency = this.project.getDependencyArtifacts();
        Artifact tarsArtifact = null;
        for (Artifact artifact : projectDependency) {
            if (!artifact.getArtifactId().contains(TARS_PROTOCOL)) continue;
            this.getLog().info((CharSequence)String.format("Use tars artifact %s-%s-%s", artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion()));
            tarsArtifact = artifact;
            break;
        }
        if (tarsArtifact == null) {
            tarsArtifact = this.artifactFactory.createArtifact(this.tarsGroupId, this.tarsArtifactId, this.tarsVersion, "compile", "jar");
        }
        this.artifactResolver.resolve(tarsArtifact, this.remoteRepositories, this.localRepository);
        this.installArtifact(tarsArtifact, libDir, artifactRepository, this.useTimestampInSnapshotFileName);
        MavenProject coreProject = this.mavenProjectBuilder.buildFromRepository(tarsArtifact, this.remoteRepositories, this.localRepository);
        ScopeArtifactFilter artifactFilter = new ScopeArtifactFilter("compile"){

            public boolean include(Artifact artifact) {
                return TarsBuildMojo.this.includedScope(artifact.getScope());
            }
        };
        HashSet<Artifact> artifacts = new HashSet<Artifact>();
        DependencyNode rootNode = this.dependencyTreeBuilder.buildDependencyTree(coreProject, this.localRepository, this.artifactFactory, this.artifactMetadataSource, (ArtifactFilter)artifactFilter, this.artifactCollector);
        for (DependencyNode child : rootNode.getChildren()) {
            this.collect(child, artifacts);
        }
        if (artifacts == null || artifacts.isEmpty()) {
            throw new MojoExecutionException("Unable to install tars artifact dependency.");
        }
        for (Artifact artifact : artifacts) {
            try {
                this.artifactResolver.resolve(artifact, this.remoteRepositories, this.localRepository);
            }
            catch (ArtifactNotFoundException | ArtifactResolutionException e) {
                throw new MojoExecutionException("Unable to resolve " + artifact, (Exception)e);
            }
            this.installArtifact(artifact, libDir, artifactRepository, this.useTimestampInSnapshotFileName);
        }
    }

    private void unArchiveArtifact(File destination, File artifactFile) throws MojoExecutionException, IOException {
        try {
            UnArchiver unArchiver = this.archiverManager.getUnArchiver(artifactFile);
            unArchiver.setSourceFile(artifactFile);
            unArchiver.setDestDirectory(destination);
            unArchiver.setOverwrite(true);
            unArchiver.extract();
        }
        catch (ArchiverException | NoSuchArchiverException e) {
            throw new MojoExecutionException("Unable to unarchive " + artifactFile.getName(), (Exception)e);
        }
    }

    private void collect(DependencyNode root, Set<Artifact> artifacts) {
        Stack<DependencyNode> stack = new Stack<DependencyNode>();
        stack.push(root);
        while (!stack.isEmpty()) {
            Artifact artifact;
            DependencyNode node = (DependencyNode)stack.pop();
            if (node.getState() != 0 || !this.includedScope((artifact = node.getArtifact()).getScope())) continue;
            this.getLog().info((CharSequence)("Adding Artefact: " + artifact.toString()));
            artifacts.add(artifact);
            if (node.getChildren().isEmpty()) continue;
            stack.addAll(node.getChildren());
        }
    }

    private ArtifactRepository getArtifactRepository(String outputDirectory) throws ArtifactNotFoundException, MojoFailureException {
        return this.artifactRepositoryFactory.createDeploymentArtifactRepository(TARS_PROTOCOL, "file://" + outputDirectory, this.getArtifactRepositoryLayout(), false);
    }

    protected ArtifactRepositoryLayout getArtifactRepositoryLayout() throws MojoFailureException {
        try {
            ArtifactRepositoryLayout artifactRepositoryLayout = null;
            artifactRepositoryLayout = (ArtifactRepositoryLayout)this.container.lookup("org.apache.maven.artifact.repository.layout.ArtifactRepositoryLayout", this.repositoryLayout);
            if (artifactRepositoryLayout == null) {
                throw new MojoFailureException("Unknown repository layout '" + this.repositoryLayout + "'.");
            }
            return artifactRepositoryLayout;
        }
        catch (ComponentLookupException e) {
            throw new MojoFailureException("Unable to lookup the repository layout component '" + this.repositoryLayout + "': " + e.getMessage());
        }
    }

    protected void installArtifact(Artifact artifact, File libDir, ArtifactRepository artifactRepository, boolean useTimestampInSnapshotFileName) throws MojoExecutionException {
        if (artifact != null && artifact.getFile() != null) {
            try {
                File source = artifact.getFile();
                File destination = libDir;
                if (!source.isDirectory()) {
                    if (this.outputFileNameMapping != null) {
                        String fileName = MappingUtils.evaluateFileNameMapping((String)this.outputFileNameMapping, (Artifact)artifact);
                        destination = new File(destination, fileName);
                    } else {
                        destination = new File(destination, source.getName());
                    }
                    FileUtils.copyFile((File)source, (File)destination);
                    Dependency dependency = new Dependency(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion(), artifact.getClassifier());
                    dependency.setRelativePath(destination.getCanonicalPath());
                    this.dependencyList.add(dependency);
                }
                this.getLog().info((CharSequence)("Installing artifact " + source.getPath() + " to " + destination));
            }
            catch (IOException e) {
                throw new MojoExecutionException("Failed to copy artifact.", (Exception)e);
            }
            catch (InterpolationException e) {
                throw new MojoExecutionException("Failed to map file name.", (Exception)((Object)e));
            }
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void createConfigScript(File binDir, File dataDir, File binLogDir, File configFile) throws Exception {
        InputStream in = null;
        FileWriter out = null;
        try {
            File servicesXMLFile = new File(this.war, "WEB-INF" + File.separator + "servants.xml");
            if (!servicesXMLFile.exists()) {
                throw new MojoExecutionException("failed to find WEB-INF/servants.xml,  servants will be disabled");
            }
            XMLConfigFile cfg = new XMLConfigFile();
            cfg.parse(new FileInputStream(servicesXMLFile));
            XMLConfigElement root = cfg.getRootElement();
            ArrayList<XMLConfigElement> elements = root.getChildList();
            in = this.getConfigTemplate();
            InputStreamReader reader = new InputStreamReader(this.getConfigTemplate());
            HashMap<String, Object> context = new HashMap<String, Object>();
            context.put("LOCALIP", this.getLocalIp());
            context.put("APP", this.getApp());
            context.put("SERVER", this.getServer());
            context.put("BASEPATH", binDir.getCanonicalPath());
            context.put("DATAPATH", dataDir.getCanonicalFile());
            context.put("LOGPATH", binLogDir.getCanonicalPath());
            context.put("JVMPARAMS", this.getJvmParams());
            context.put("MAINCLASS", MAIN_CLASS);
            context.put("CONFIG", configFile.getAbsolutePath());
            StringBuilder suf = new StringBuilder();
            for (XMLConfigElement element : elements) {
                if (!"servant".equals(element.getName())) continue;
                if (suf.length() > 0) {
                    suf.append("\n");
                }
                Servant servant = new Servant();
                servant.setName(element.getStringAttribute("name"));
                servant.setProtocol(element.getStringAttribute("protocol", TARS_PROTOCOL));
                servant.setPort(element.getStringAttribute("port"));
                suf.append(this.readServantScript(servant));
                if (servant.getProtocol() == null || !this.isJceOrWup(servant.getProtocol())) continue;
                context.put("ADMINPORT", servant.getPort());
            }
            context.put("SERVANTADAPTER", suf.toString());
            InterpolationFilterReader interpolationFilterReader = new InterpolationFilterReader((Reader)reader, context, "$", "$");
            out = new FileWriter(configFile);
            IOUtil.copy((Reader)interpolationFilterReader, (Writer)out);
        }
        catch (FileNotFoundException e) {
            try {
                throw new MojoExecutionException("Failed to get template for config file.", (Exception)e);
                catch (IOException e2) {
                    throw new MojoExecutionException("Failed to write config file.", (Exception)e2);
                }
            }
            catch (Throwable throwable) {
                IOUtil.close(out);
                IOUtil.close(in);
                throw throwable;
            }
        }
        IOUtil.close((Writer)out);
        IOUtil.close((InputStream)in);
    }

    private String getLocalIp() throws UnknownHostException {
        return System.getProperty("localIp", InetAddress.getLocalHost().getHostAddress());
    }

    private String getApp() {
        return System.getProperty("app", null);
    }

    private String getServer() {
        return System.getProperty("server", null);
    }

    private boolean isPackage() {
        return Boolean.parseBoolean(System.getProperty("package", "false"));
    }

    private String getJvmParams() {
        return System.getProperty("jvmParams", "-Xms1024m -Xmx1024m");
    }

    private boolean isJceOrWup(String protocol) {
        return TARS_PROTOCOL.equalsIgnoreCase(protocol) || TUP_PROTOCOL.equalsIgnoreCase(protocol);
    }

    private String readServantScript(Servant servant) throws Exception {
        InputStream in = null;
        try {
            in = this.getServantTemplate();
            HashMap<String, String> context = new HashMap<String, String>();
            context.put("LOCALIP", this.getLocalIp());
            context.put("APP", this.getApp());
            context.put("SERVER", this.getServer());
            context.put("SERVANTNAME", servant.getName());
            context.put("PORT", servant.getPort());
            context.put("PROTOCOL", servant.getProtocol() == null || this.isJceOrWup(servant.getProtocol()) ? TARS_PROTOCOL : "no_tars");
            InterpolationFilterReader interpolationFilterReader = new InterpolationFilterReader((Reader)new InputStreamReader(in), context, "$", "$");
            String string = IOUtil.toString((Reader)interpolationFilterReader);
            return string;
        }
        catch (FileNotFoundException e) {
            throw new MojoExecutionException("Failed to get template for servant file.", (Exception)e);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to write servant file.", (Exception)e);
        }
        finally {
            IOUtil.close((InputStream)in);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String createBinScript(Platform platform, File libDir, File binDir, File configFile) throws Exception {
        InputStream in = null;
        FileWriter out = null;
        in = this.getScriptTemplate(platform.getName());
        HashMap<String, String> context = new HashMap<String, String>();
        context.put("JVMPARAMS", this.getJvmParams());
        context.put("MAINCLASS", MAIN_CLASS);
        context.put("CONFIG", configFile.getAbsolutePath());
        context.put("CLASSPATH", platform.getClassPath(this.dependencyList));
        if (platform.isShowConsoleWindow()) {
            context.put("JAVA_BINARY", "java");
            context.put("UNIX_BACKGROUND", "");
        } else {
            context.put("JAVA_BINARY", "start /min javaw");
            context.put("UNIX_BACKGROUND", " &");
        }
        String interpolationToken = platform.getInterpolationToken();
        InterpolationFilterReader interpolationFilterReader = new InterpolationFilterReader((Reader)new InputStreamReader(in), context, interpolationToken, interpolationToken);
        String programName = "tars_start";
        FileUtils.forceMkdir((File)binDir);
        File binFile = new File(binDir, programName + platform.getBinFileExtension());
        if ("unix".equals(platform.getName()) && binFile.exists()) {
            try {
                ArchiveEntryUtils.chmod(binFile, 511, this.getLog(), true);
            }
            catch (ArchiverException ae) {
                throw new MojoExecutionException("Failed to change permission for bin file.", (Exception)((Object)ae));
            }
        }
        out = new FileWriter(binFile);
        this.getLog().debug((CharSequence)("Writing shell file for platform '" + platform.getName() + "' to '" + binFile.getAbsolutePath() + "'."));
        IOUtil.copy((Reader)interpolationFilterReader, (Writer)out);
        IOUtil.close((Writer)out);
        IOUtil.close((InputStream)in);
        if (!"unix".equals(platform.getName())) return binFile.getCanonicalPath();
        try {
            ArchiveEntryUtils.chmod(binFile, 511, this.getLog(), true);
            return binFile.getCanonicalPath();
        }
        catch (ArchiverException ae) {
            throw new MojoExecutionException("Failed to change permission for bin file.", (Exception)((Object)ae));
        }
        catch (FileNotFoundException e) {
            try {
                throw new MojoExecutionException("Failed to get template for bin file.", (Exception)e);
                catch (IOException e2) {
                    throw new MojoExecutionException("Failed to write bin file.", (Exception)e2);
                }
            }
            catch (Throwable throwable) {
                IOUtil.close(out);
                IOUtil.close((InputStream)in);
                throw throwable;
            }
        }
    }

    private InputStream getScriptTemplate(String platformName) throws MojoExecutionException {
        InputStream is = null;
        try {
            is = Platform.class.getResourceAsStream(platformName + "BinTemplate");
            if (is == null) {
                throw new MojoExecutionException("Unable to load internal template resource: " + platformName + "BinTemplate");
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException("Unable to load external template file", e);
        }
        return is;
    }

    private InputStream getConfigTemplate() throws MojoExecutionException {
        InputStream is = null;
        try {
            is = Platform.class.getResourceAsStream("configTemplate");
            if (is == null) {
                throw new MojoExecutionException("Unable to load internal template resource: configTemplate");
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException("Unable to load external template file", e);
        }
        return is;
    }

    private InputStream getServantTemplate() throws MojoExecutionException {
        InputStream is = null;
        try {
            is = Platform.class.getResourceAsStream("servantTemplate");
            if (is == null) {
                throw new MojoExecutionException("Unable to load internal template resource: configTemplate");
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException("Unable to load external template file", e);
        }
        return is;
    }
}

