/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.protocol;

import com.unboundid.asn1.ASN1Buffer;
import com.unboundid.asn1.ASN1BufferSequence;
import com.unboundid.asn1.ASN1Element;
import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.asn1.ASN1Sequence;
import com.unboundid.asn1.ASN1StreamReader;
import com.unboundid.asn1.ASN1StreamReaderSequence;
import com.unboundid.ldap.protocol.ProtocolMessages;
import com.unboundid.ldap.protocol.ProtocolOp;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.IntermediateResponse;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.util.Debug;
import com.unboundid.util.InternalUseOnly;
import com.unboundid.util.NotMutable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import java.util.ArrayList;

@InternalUseOnly
@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class IntermediateResponseProtocolOp
implements ProtocolOp {
    public static final byte TYPE_OID = -128;
    public static final byte TYPE_VALUE = -127;
    private static final long serialVersionUID = 118549806265654465L;
    private final ASN1OctetString value;
    private final String oid;

    public IntermediateResponseProtocolOp(String oid, ASN1OctetString value) {
        this.oid = oid;
        this.value = value == null ? null : new ASN1OctetString(-127, value.getValue());
    }

    public IntermediateResponseProtocolOp(IntermediateResponse response) {
        this.oid = response.getOID();
        ASN1OctetString responseValue = response.getValue();
        this.value = responseValue == null ? null : new ASN1OctetString(-127, responseValue.getValue());
    }

    IntermediateResponseProtocolOp(ASN1StreamReader reader) throws LDAPException {
        try {
            ASN1StreamReaderSequence opSequence = reader.beginSequence();
            String o = null;
            ASN1OctetString v = null;
            while (opSequence.hasMoreElements()) {
                byte type = (byte)reader.peek();
                if (type == -128) {
                    o = reader.readString();
                    continue;
                }
                if (type == -127) {
                    v = new ASN1OctetString(type, reader.readBytes());
                    continue;
                }
                throw new LDAPException(ResultCode.DECODING_ERROR, ProtocolMessages.ERR_INTERMEDIATE_RESPONSE_INVALID_ELEMENT.get(StaticUtils.toHex(type)));
            }
            this.oid = o;
            this.value = v;
        }
        catch (LDAPException le) {
            Debug.debugException(le);
            throw le;
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new LDAPException(ResultCode.DECODING_ERROR, ProtocolMessages.ERR_INTERMEDIATE_RESPONSE_CANNOT_DECODE.get(StaticUtils.getExceptionMessage(e)), e);
        }
    }

    public String getOID() {
        return this.oid;
    }

    public ASN1OctetString getValue() {
        return this.value;
    }

    @Override
    public byte getProtocolOpType() {
        return 121;
    }

    @Override
    public ASN1Element encodeProtocolOp() {
        ArrayList<ASN1OctetString> elements = new ArrayList<ASN1OctetString>(2);
        if (this.oid != null) {
            elements.add(new ASN1OctetString(-128, this.oid));
        }
        if (this.value != null) {
            elements.add(this.value);
        }
        return new ASN1Sequence(121, elements);
    }

    public static IntermediateResponseProtocolOp decodeProtocolOp(ASN1Element element) throws LDAPException {
        try {
            String oid = null;
            ASN1OctetString value = null;
            block7: for (ASN1Element e : ASN1Sequence.decodeAsSequence(element).elements()) {
                switch (e.getType()) {
                    case -128: {
                        oid = ASN1OctetString.decodeAsOctetString(e).stringValue();
                        continue block7;
                    }
                    case -127: {
                        value = ASN1OctetString.decodeAsOctetString(e);
                        continue block7;
                    }
                    default: {
                        throw new LDAPException(ResultCode.DECODING_ERROR, ProtocolMessages.ERR_INTERMEDIATE_RESPONSE_INVALID_ELEMENT.get(StaticUtils.toHex(e.getType())));
                    }
                }
            }
            return new IntermediateResponseProtocolOp(oid, value);
        }
        catch (LDAPException le) {
            Debug.debugException(le);
            throw le;
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new LDAPException(ResultCode.DECODING_ERROR, ProtocolMessages.ERR_COMPARE_REQUEST_CANNOT_DECODE.get(StaticUtils.getExceptionMessage(e)), e);
        }
    }

    @Override
    public void writeTo(ASN1Buffer buffer) {
        ASN1BufferSequence opSequence = buffer.beginSequence((byte)121);
        if (this.oid != null) {
            buffer.addOctetString((byte)-128, this.oid);
        }
        if (this.value != null) {
            buffer.addElement(this.value);
        }
        opSequence.end();
    }

    public IntermediateResponse toIntermediateResponse(Control ... controls) {
        return new IntermediateResponse(-1, this.oid, this.value, controls);
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        this.toString(buffer);
        return buffer.toString();
    }

    @Override
    public void toString(StringBuilder buffer) {
        buffer.append("IntermediateResponseProtocolOp(");
        if (this.oid != null) {
            buffer.append("oid='");
            buffer.append(this.oid);
            buffer.append('\'');
        }
        buffer.append(')');
    }
}

