/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.util;

import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;

@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public enum DebugType {
    ASN1("asn1"),
    CONNECT("connect"),
    EXCEPTION("exception"),
    LDAP("ldap"),
    LDIF("ldif"),
    MONITOR("monitor"),
    CODING_ERROR("coding-error"),
    OTHER("other");

    private final String name;

    private DebugType(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public static DebugType forName(String name) {
        switch (StaticUtils.toLowerCase(name)) {
            case "asn1": {
                return ASN1;
            }
            case "connect": {
                return CONNECT;
            }
            case "exception": {
                return EXCEPTION;
            }
            case "ldap": {
                return LDAP;
            }
            case "ldif": {
                return LDIF;
            }
            case "monitor": {
                return MONITOR;
            }
            case "codingerror": 
            case "coding-error": 
            case "coding_error": {
                return CODING_ERROR;
            }
            case "other": {
                return OTHER;
            }
        }
        return null;
    }

    public static String getTypeNameList() {
        StringBuilder buffer = new StringBuilder();
        DebugType[] types = DebugType.values();
        for (int i = 0; i < types.length; ++i) {
            if (i > 0) {
                buffer.append(", ");
            }
            buffer.append(types[i].getName());
        }
        return buffer.toString();
    }

    public String toString() {
        return this.name;
    }
}

