/*
 * Decompiled with CFR 0.152.
 */
package com.unfbx.chatgpt.interceptor;

import cn.hutool.json.JSONUtil;
import com.unfbx.chatgpt.entity.common.OpenAiResponse;
import com.unfbx.chatgpt.exception.BaseException;
import com.unfbx.chatgpt.exception.CommonError;
import java.io.IOException;
import java.util.Objects;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenAiResponseInterceptor
implements Interceptor {
    private static final Logger log = LoggerFactory.getLogger(OpenAiResponseInterceptor.class);

    public Response intercept(Interceptor.Chain chain) throws IOException {
        Request original = chain.request();
        Response response = chain.proceed(original);
        if (!response.isSuccessful()) {
            if (response.code() == CommonError.OPENAI_AUTHENTICATION_ERROR.code() || response.code() == CommonError.OPENAI_LIMIT_ERROR.code() || response.code() == CommonError.OPENAI_SERVER_ERROR.code()) {
                OpenAiResponse openAiResponse = (OpenAiResponse)JSONUtil.toBean((String)response.body().string(), OpenAiResponse.class);
                log.error(openAiResponse.getError().getMessage());
                throw new BaseException(openAiResponse.getError().getMessage());
            }
            String errorMsg = response.body().string();
            log.error("--------> \u8bf7\u6c42\u5f02\u5e38\uff1a{}", (Object)errorMsg);
            OpenAiResponse openAiResponse = (OpenAiResponse)JSONUtil.toBean((String)errorMsg, OpenAiResponse.class);
            if (Objects.nonNull(openAiResponse.getError())) {
                log.error(openAiResponse.getError().getMessage());
                throw new BaseException(openAiResponse.getError().getMessage());
            }
            throw new BaseException(CommonError.RETRY_ERROR);
        }
        return response;
    }
}

