/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.data.provider;

import com.vaadin.flow.data.provider.DataKeyMapper;
import com.vaadin.flow.function.ValueProvider;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class KeyMapper<V>
implements DataKeyMapper<V> {
    private int lastKey = 0;
    private final HashMap<Object, String> objectIdKeyMap = new HashMap();
    private final HashMap<String, V> keyObjectMap = new HashMap();
    private ValueProvider<V, Object> identifierGetter;

    public KeyMapper(ValueProvider<V, Object> identifierGetter) {
        this.identifierGetter = identifierGetter;
    }

    public KeyMapper() {
        this((ValueProvider & Serializable)v -> v);
    }

    @Override
    public String key(V o) {
        if (o == null) {
            return "null";
        }
        Object id = this.identifierGetter.apply(o);
        String key = this.objectIdKeyMap.get(id);
        if (key != null) {
            return key;
        }
        key = this.createKey();
        this.objectIdKeyMap.put(id, key);
        this.keyObjectMap.put(key, o);
        return key;
    }

    protected String createKey() {
        return String.valueOf(++this.lastKey);
    }

    @Override
    public boolean has(V o) {
        return this.objectIdKeyMap.containsKey(this.identifierGetter.apply(o));
    }

    @Override
    public V get(String key) {
        return this.keyObjectMap.get(key);
    }

    @Override
    public void remove(V removeobj) {
        String key = this.objectIdKeyMap.remove(this.identifierGetter.apply(removeobj));
        if (key != null) {
            this.keyObjectMap.remove(key);
        }
    }

    @Override
    public void removeAll() {
        this.objectIdKeyMap.clear();
        this.keyObjectMap.clear();
    }

    public boolean containsKey(String key) {
        return this.keyObjectMap.containsKey(key);
    }

    @Override
    public void refresh(V dataObject) {
        Object id = this.identifierGetter.apply(dataObject);
        String key = this.objectIdKeyMap.get(id);
        if (key != null) {
            this.keyObjectMap.put(key, dataObject);
        }
    }

    @Override
    public void setIdentifierGetter(ValueProvider<V, Object> identifierGetter) {
        if (this.identifierGetter != identifierGetter) {
            this.identifierGetter = identifierGetter;
            this.objectIdKeyMap.clear();
            for (Map.Entry<String, V> entry : this.keyObjectMap.entrySet()) {
                this.objectIdKeyMap.put(identifierGetter.apply(entry.getValue()), entry.getKey());
            }
        }
    }
}

