/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.data.provider;

import com.vaadin.flow.data.provider.SortDirection;
import com.vaadin.flow.data.provider.SortOrder;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public abstract class SortOrderBuilder<T extends SortOrder<V>, V>
implements Serializable {
    private final List<T> sortOrders = new ArrayList<T>();

    public SortOrderBuilder<T, V> thenAsc(V by) {
        return this.append(this.createSortOrder(by, SortDirection.ASCENDING));
    }

    public SortOrderBuilder<T, V> thenDesc(V by) {
        return this.append(this.createSortOrder(by, SortDirection.DESCENDING));
    }

    public final List<T> build() {
        return Collections.unmodifiableList(new ArrayList<T>(this.sortOrders));
    }

    protected abstract T createSortOrder(V var1, SortDirection var2);

    private final SortOrderBuilder<T, V> append(T sortOrder) {
        this.sortOrders.add(sortOrder);
        return this;
    }
}

