/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.data.selection;

import com.vaadin.flow.component.AbstractField;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.data.selection.SelectionEvent;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Optional;
import java.util.Set;

public class MultiSelectionEvent<C extends Component, T>
extends AbstractField.ComponentValueChangeEvent<C, Set<T>>
implements SelectionEvent<C, T> {
    public MultiSelectionEvent(C listing, HasValue<AbstractField.ComponentValueChangeEvent<C, Set<T>>, Set<T>> source, Set<T> oldSelection, boolean userOriginated) {
        super(listing, source, oldSelection, userOriginated);
    }

    @Override
    public Optional<T> getFirstSelectedItem() {
        return this.getValue().stream().findFirst();
    }

    @Override
    public Set<T> getAllSelectedItems() {
        return this.getValue();
    }

    public Set<T> getValue() {
        return Collections.unmodifiableSet((Set)super.getValue());
    }

    public Set<T> getOldSelection() {
        return Collections.unmodifiableSet((Set)this.getOldValue());
    }

    public Set<T> getRemovedSelection() {
        LinkedHashSet copy = new LinkedHashSet((Collection)this.getOldValue());
        copy.removeAll((Collection<?>)this.getValue());
        return copy;
    }

    public Set<T> getAddedSelection() {
        LinkedHashSet copy = new LinkedHashSet(this.getValue());
        copy.removeAll((Collection)this.getOldValue());
        return copy;
    }
}

